/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.Core;
import java.text.DecimalFormat;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxField {
    private String value;
    private String measureUnit = "";
    private String IX;
    private String format;

    public VsdxField(String id) {
        this.IX = id;
    }

    public VsdxField(Element contents) {
        this.IX = contents.getAttribute("IX");
        NodeList cells = contents.getChildNodes();
        block8: for (int i = 0; i < cells.getLength(); ++i) {
            if (cells.item(i).getNodeType() != 1) continue;
            Element cell = (Element)cells.item(i);
            String cellValue = cell.getAttribute("V");
            switch (cell.getAttribute("N")) {
                case "Value": {
                    this.value = cell.getTextContent();
                    if (cell.hasAttribute("V")) {
                        this.value = cellValue;
                    }
                    this.measureUnit = cell.getAttribute("U");
                    continue block8;
                }
                case "Format": {
                    this.format = cellValue;
                }
            }
        }
    }

    public String getText(String pageMeasureUnits) {
        return this.parseText(this.measureUnit);
    }

    private String parseText(String units) {
        if (units == null || units.isEmpty() || units.equals("STR")) {
            return this.value;
        }
        double valueConverted = 0.0;
        try {
            valueConverted = Double.parseDouble(this.value);
        }
        catch (Exception e) {
            Core.logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0430\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u0435\u043a\u0441\u0442\u0430 " + this.value + "(format: " + this.format + ", units: " + units + ")");
            return this.value;
        }
        String unitsLocalised = "";
        switch (units) {
            case "DL": 
            case "IN": 
            case "IN_F": {
                unitsLocalised = "\u0434\u044e\u0439\u043c";
                break;
            }
            case "FT": 
            case "F_I": {
                valueConverted *= 12.0;
                unitsLocalised = "\u0444\u0442";
                break;
            }
            case "MM": {
                valueConverted *= 25.4;
                unitsLocalised = "\u043c\u043c";
                break;
            }
            case "CM": {
                valueConverted *= 2.54;
                unitsLocalised = "\u0441\u043c";
                break;
            }
            case "M": {
                valueConverted *= 0.0254;
                unitsLocalised = "\u043c";
                break;
            }
            case "KM": {
                valueConverted *= 2.54E-5;
                unitsLocalised = "\u043a\u043c";
                break;
            }
            case "MI": 
            case "MI_F": {
                valueConverted *= 1.5783E-5;
                unitsLocalised = "\u043c\u0438";
                break;
            }
            default: {
                return this.value;
            }
        }
        return this.formatText(valueConverted, unitsLocalised);
    }

    private String formatText(double value, String units) {
        if (this.format == null) {
            return String.valueOf(value);
        }
        switch (this.format) {
            case "esc(0)": {
                return new DecimalFormat("0.0").format(value);
            }
            case "esc(1)": {
                return new DecimalFormat("0").format(value) + units.toLowerCase();
            }
            case "esc(2)": {
                return new DecimalFormat("0").format(value);
            }
            case "esc(3)": {
                return new DecimalFormat("0").format(value) + units.toLowerCase();
            }
            case "esc(4)": {
                return new DecimalFormat("0.0").format(value);
            }
            case "esc(5)": {
                return new DecimalFormat("0.0").format(value) + units.toLowerCase();
            }
            case "esc(6)": {
                return new DecimalFormat("0.00").format(value);
            }
            case "esc(7)": {
                return new DecimalFormat("0.00").format(value) + units.toLowerCase();
            }
            case "esc(8)": {
                return new DecimalFormat("0.000").format(value);
            }
            case "esc(9)": {
                return new DecimalFormat("0.000").format(value) + units.toLowerCase();
            }
        }
        return new DecimalFormat("0.00").format(value);
    }

    public void applyProperties(VsdxField other) {
        if (other == null) {
            return;
        }
        assert (this.IX != null && this.IX.equals(other.IX));
        if (other.value != null && !other.value.equals("")) {
            this.value = other.value;
        }
        if (other.measureUnit != null && !other.measureUnit.equals("")) {
            this.measureUnit = other.measureUnit;
        }
        if (other.format != null && !other.format.equals("")) {
            this.format = other.format;
        }
    }

    public String getIX() {
        return this.IX;
    }
}

