/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.PrimParam;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.converters.vsdx.VsdxAction;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VsdxProperty {
    private String name;
    private String label;
    private String value;
    private ValueType type;
    private String format;
    private String units;
    private String invisible;
    private String del;

    public VsdxProperty() {
    }

    public VsdxProperty(VsdxAction action, Map<String, String> userVars) {
        this.name = "Action" + action.getName();
        this.label = action.getMenu();
        if (this.label != null) {
            this.label = this.label.replace("&", "");
        }
        this.value = action.getChecked();
        String actionFormula = action.getActionFormula();
        if (!SchemeUtils.isEmpty(actionFormula) && SchemeUtils.isEmpty(action.getCheckedFormula())) {
            if (actionFormula.contains("Actions.Action") || actionFormula.contains("Scratch.")) {
                this.value = action.getActionValue();
            } else if (userVars != null) {
                for (Map.Entry<String, String> entry : userVars.entrySet()) {
                    String varName = entry.getKey();
                    if (SchemeUtils.isEmpty(varName) || !actionFormula.contains("User." + varName)) continue;
                    this.value = entry.getValue();
                    break;
                }
            }
        }
        this.type = ValueType.Boolean;
        this.format = "";
        this.invisible = "0";
    }

    public PrimParam createPrimParam() {
        PrimParam p = new PrimParam();
        p.setName(this.name);
        p.setCaption(this.label);
        p.setValue(this.value);
        switch (this.type) {
            case VariableList: 
            case FixedList: {
                String[] dictionaryEntries = (this.format == null ? "" : this.format).split(";");
                List<String> dict = p.getDict();
                dict.addAll(Arrays.asList(dictionaryEntries));
                if (VsdxProperty.scaleUnits(this.units) != 0.0) {
                    double valueNumber = VsdxUtils.convertDouble(this.value, null);
                    boolean success = false;
                    for (String dictItem : dict) {
                        String item = dictItem.toUpperCase();
                        for (String u : VsdxProperty.scaledUnitsList()) {
                            if (!item.endsWith(u.toUpperCase())) continue;
                            String itemValue = item.substring(0, item.length() - u.length()).trim();
                            try {
                                double scu = VsdxProperty.scaleUnits(u);
                                double itemNumber = VsdxUtils.convertDouble(itemValue, null) / (scu != 0.0 ? scu : 1.0);
                                if (!SchemeUtils.isEqual(itemNumber, valueNumber)) continue;
                                p.setValue(dictItem);
                                success = true;
                                break;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        }
                        if (!success) continue;
                        break;
                    }
                    p.setType(PrimParam.ValueType.Double);
                    try {
                        p.setValue("" + VsdxReader.inchToMM(this.value, null));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
            case String: 
            case Currency: 
            case Date: 
            case Duration: {
                p.setType(PrimParam.ValueType.String);
                break;
            }
            case Number: {
                if (VsdxProperty.scaleUnits(this.units) != 0.0) {
                    p.setType(PrimParam.ValueType.Double);
                    try {
                        p.setValue("" + VsdxReader.inchToMM(this.value, null));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                if (this.value.contains(".")) {
                    p.setType(PrimParam.ValueType.Double);
                    break;
                }
                p.setType(PrimParam.ValueType.Integer);
                break;
            }
            case Boolean: {
                p.setType(PrimParam.ValueType.Boolean);
                break;
            }
            case Undefined: {
                p.setType(PrimParam.ValueType.Undefined);
            }
        }
        return p;
    }

    public void applyProperties(VsdxProperty masterProperty) {
        if (masterProperty.name != null) {
            this.name = masterProperty.name;
        }
        if (masterProperty.label != null) {
            this.label = masterProperty.label;
        }
        if (masterProperty.value != null) {
            this.value = masterProperty.value;
        }
        if (masterProperty.type != null) {
            this.type = masterProperty.type;
        }
        if (masterProperty.format != null) {
            this.format = masterProperty.format;
        }
        if (masterProperty.invisible != null) {
            this.invisible = masterProperty.invisible;
        }
        if (masterProperty.units != null) {
            this.units = masterProperty.units;
        }
        if (masterProperty.del != null) {
            this.del = masterProperty.del;
        }
    }

    public boolean isVisible() {
        return this.invisible == null || this.invisible.isEmpty() || "0".equals(this.invisible);
    }

    public void setInvisible(String invisible) {
        this.invisible = invisible;
    }

    public String getInvisible() {
        return this.invisible;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ValueType getType() {
        return this.type;
    }

    public void setTypeFromId(String typeId) {
        switch (typeId) {
            case "0": {
                this.type = ValueType.String;
                break;
            }
            case "1": {
                this.type = ValueType.FixedList;
                break;
            }
            case "2": {
                this.type = ValueType.Number;
                break;
            }
            case "3": {
                this.type = ValueType.Boolean;
                break;
            }
            case "4": {
                this.type = ValueType.VariableList;
                break;
            }
            case "5": {
                this.type = ValueType.Date;
                break;
            }
            case "6": {
                this.type = ValueType.Duration;
                break;
            }
            case "7": {
                this.type = ValueType.Currency;
                break;
            }
            default: {
                this.type = ValueType.Undefined;
            }
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getDel() {
        return this.del;
    }

    public void setDel(String v) {
        this.del = v;
    }

    public boolean isDel() {
        return "1".equals(this.del);
    }

    public static List<String> scaledUnitsList() {
        return Arrays.asList("DL", "IN", "IN_F", "FT", "F_I", "MM", "CM", "M", "KM", "MI", "MI_F");
    }

    public static double scaleUnits(String units) {
        if (units == null || units.isEmpty()) {
            return 0.0;
        }
        switch (units.toUpperCase()) {
            case "DL": 
            case "IN": 
            case "IN_F": {
                return 1.0;
            }
            case "FT": 
            case "F_I": {
                return 12.0;
            }
            case "MM": {
                return 25.4;
            }
            case "CM": {
                return 2.54;
            }
            case "M": {
                return 0.0254;
            }
            case "KM": {
                return 2.54E-5;
            }
            case "MI": 
            case "MI_F": {
                return 1.5783E-5;
            }
        }
        return 0.0;
    }

    public static enum ValueType {
        String,
        Number,
        VariableList,
        FixedList,
        Boolean,
        Currency,
        Date,
        Duration,
        Undefined;

    }
}

