/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.BaseGraphic;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VsdxReader;
import inform.agent.schemes.converters.vsdx.VsdxGeometryRow;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class VsdxUtils {
    public static final int ELLIPSE_POINTS_COUNT = 60;
    public static final int ARC_POINTS_COUNT = 90;
    public static final int ARC_POINTS_MIN = 8;
    public static final int CALC_ARC_MAX = 10;
    private static final double MAX_CONVERT_NUMBER = 1.0E12;

    public static double convertDouble(String s, VsdxShape shape) {
        if (s == null || s.isEmpty() || VsdxUtils.isThemed(s)) {
            return 0.0;
        }
        double v = Double.parseDouble(s.trim());
        if (v > 1.0E12 || v < -1.0E12) {
            if (shape != null) {
                shape.InvalidConverting = true;
            }
            return 0.0;
        }
        return v;
    }

    public static double convertFromRealToPercent(String property, VsdxShape shape) {
        return VsdxUtils.convertDouble(property, shape) * 100.0;
    }

    public static int convertLineStyle(String value) {
        return VsdxUtils.convertLineStyle(value, false);
    }

    public static int convertLineStyle(String value, boolean noLine) {
        if (noLine) {
            return 5;
        }
        if (value == null) {
            return 5;
        }
        if (VsdxUtils.isThemed(value)) {
            return 0;
        }
        switch (SchemeUtils.convertInt(value)) {
            case 0: {
                return 5;
            }
            case 1: {
                return 0;
            }
            case 2: 
            case 9: 
            case 16: {
                return 1;
            }
            case 3: 
            case 10: 
            case 17: 
            case 23: {
                return 2;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 18: 
            case 21: {
                return 3;
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 19: {
                return 4;
            }
            case 6: 
            case 13: 
            case 20: 
            case 22: {
                return 4;
            }
        }
        return 0;
    }

    public static int convertFillStyle(String value) {
        return VsdxUtils.convertFillStyle(value, false);
    }

    public static int convertFillStyle(String value, boolean noFill) {
        if (noFill) {
            return 1;
        }
        if (value == null) {
            return 1;
        }
        if (VsdxUtils.isThemed(value)) {
            return 0;
        }
        switch (SchemeUtils.convertInt(value)) {
            case 0: {
                return 1;
            }
            case 2: {
                return 26;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 10;
            }
            case 9: {
                return 11;
            }
            case 10: {
                return 12;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 14;
            }
            case 13: {
                return 18;
            }
            case 14: {
                return 23;
            }
            case 15: {
                return 33;
            }
            case 16: {
                return 28;
            }
            case 17: {
                return 43;
            }
            case 18: {
                return 55;
            }
            case 19: {
                return 17;
            }
            case 20: {
                return 22;
            }
            case 21: {
                return 32;
            }
            case 22: {
                return 27;
            }
            case 23: {
                return 37;
            }
            case 24: {
                return 42;
            }
            case 25: {
                return 10001;
            }
            case 26: {
                return 10011;
            }
            case 27: {
                return 10002;
            }
            case 28: {
                return 10003;
            }
            case 29: {
                return 10013;
            }
            case 30: {
                return 10004;
            }
            case 31: {
                return 10008;
            }
            case 32: {
                return 10005;
            }
            case 33: {
                return 10006;
            }
            case 34: {
                return 10007;
            }
            case 35: {
                return 10019;
            }
            case 36: {
                return 10008;
            }
            case 37: {
                return 10005;
            }
            case 38: {
                return 10006;
            }
            case 39: {
                return 10007;
            }
            case 40: {
                return 10019;
            }
        }
        return 0;
    }

    public static int convertLineCap(String value) {
        if (value == null) {
            return 0;
        }
        if (VsdxUtils.isThemed(value)) {
            return 0;
        }
        switch (SchemeUtils.convertInt(value)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static int convertContactNumber(String value) {
        int v = (int)VsdxUtils.convertDouble(value, null);
        switch (v) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
        }
        return v;
    }

    public static int convertArrowType(String value) {
        if (value == null || VsdxUtils.isThemed(value) || "0".equals(value)) {
            return 0;
        }
        if ("Composite".equals(value)) {
            return 21;
        }
        int arrowType = SchemeUtils.convertInt(value);
        switch (arrowType) {
            case 1: {
                return 5;
            }
            case 2: {
                return 14;
            }
            case 3: 
            case 7: 
            case 8: 
            case 44: 
            case 45: {
                return 16;
            }
            case 4: 
            case 5: 
            case 6: {
                return 17;
            }
            case 9: {
                return 9;
            }
            case 10: 
            case 35: 
            case 36: 
            case 37: 
            case 42: {
                return 7;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 3;
            }
            case 14: {
                return 1;
            }
            case 15: {
                return 15;
            }
            case 20: 
            case 31: 
            case 32: 
            case 33: 
            case 41: {
                return 8;
            }
            case 21: {
                return 11;
            }
            case 22: {
                return 22;
            }
            case 24: 
            case 26: {
                return 19;
            }
            case 25: {
                return 25;
            }
            case 27: 
            case 28: {
                return 20;
            }
            case 29: {
                return 27;
            }
            case 30: {
                return 26;
            }
            case 34: {
                return 24;
            }
            case 38: {
                return 23;
            }
            case 39: {
                return 30;
            }
            case 40: {
                return 31;
            }
            case 43: {
                return 29;
            }
        }
        return 18;
    }

    public static double convertArrowSize(String sizeValue, int type, double lineWidth, double currentPageScale) {
        double result = 0.0;
        int size = VsdxUtils.isThemed(sizeValue) ? 0 : SchemeUtils.convertInt(sizeValue);
        switch (size) {
            case 0: {
                result = 0.25;
                break;
            }
            case 1: {
                result = 0.5;
                break;
            }
            case 2: {
                result = 0.75;
                break;
            }
            case 3: {
                result = 1.0;
                break;
            }
            case 4: {
                result = 1.25;
                break;
            }
            case 5: {
                result = 3.25;
                break;
            }
            case 6: {
                result = 6.75;
            }
        }
        result *= currentPageScale;
        switch (type) {
            case 16: 
            case 18: {
                result *= 2.0;
                break;
            }
            case 17: {
                result *= 1.65;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 21: 
            case 22: {
                result *= 3.0;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                result *= 1.2;
                break;
            }
            case 9: 
            case 19: 
            case 20: {
                result *= 1.5;
            }
        }
        if (lineWidth > 0.0) {
            result += 2.0 * lineWidth;
        }
        return result;
    }

    public static boolean isLineRow(String rowType) {
        return "RelLineTo".equals(rowType) || "PolylineTo".equals(rowType) || "LineTo".equals(rowType);
    }

    public static boolean isMoveToRow(String rowType) {
        return "RelMoveTo".equals(rowType) || "MoveTo".equals(rowType);
    }

    public static boolean isRelRow(String rowType) {
        return "RelLineTo".equals(rowType) || "RelMoveTo".equals(rowType) || "RelEllipticalArcTo".equals(rowType) || "RelQuadBezTo".equals(rowType) || "RelCubBezTo".equals(rowType);
    }

    public static boolean isRelMoveToRow(String rowType) {
        return "RelMoveTo".equals(rowType);
    }

    public static boolean isRelLineRow(String rowType) {
        return "RelLineTo".equals(rowType);
    }

    public static boolean isNURBSToRow(String rowType) {
        return "NURBSTo".equals(rowType);
    }

    public static boolean isArcRow(String rowType) {
        return "ArcTo".equals(rowType) || "EllipticalArcTo".equals(rowType) || "RelEllipticalArcTo".equals(rowType);
    }

    public static boolean isEllipticalArcRow(String rowType) {
        return "EllipticalArcTo".equals(rowType) || "RelEllipticalArcTo".equals(rowType);
    }

    public static boolean isRelQuadBezToRow(String rowType) {
        return "RelQuadBezTo".equals(rowType);
    }

    public static boolean isRelCubBezToRow(String rowType) {
        return "RelCubBezTo".equals(rowType);
    }

    public static boolean isEllipse(String rowType) {
        return "Ellipse".equals(rowType);
    }

    public static boolean isSplineStartRow(String rowType) {
        return "SplineStart".equals(rowType);
    }

    public static boolean isSplineKnotRow(String rowType) {
        return "SplineKnot".equals(rowType);
    }

    public static boolean isInfiniteLine(String rowType) {
        return "InfiniteLine".equals(rowType);
    }

    public static VsdxTransformProps getTransformPropsMM(VsdxShape shape, BaseGraphic.RealPoint sizeMM, BaseGraphic.RealPoint parentSizeMM, boolean isText) {
        double angle;
        VsdxTransformProps props = new VsdxTransformProps();
        BaseGraphic.RealPoint pin = shape.getPinMM();
        BaseGraphic.RealPoint locPin = shape.getLocPinMM();
        props.OrgX = pin.X;
        props.OrgY = -pin.Y;
        if (parentSizeMM != null) {
            props.OrgX += -0.5 * parentSizeMM.X;
            props.OrgY += 0.5 * parentSizeMM.Y;
        }
        props.CenterX = -locPin.X;
        props.CenterY = locPin.Y;
        if (sizeMM != null) {
            props.CenterX += 0.5 * sizeMM.X;
            props.CenterY += -0.5 * sizeMM.Y;
        }
        props.ScaleX = shape.isFlipX() ? -1.0 : 1.0;
        props.ScaleY = shape.isFlipY() ? -1.0 : 1.0;
        props.Angle = SchemeUtils.convertAngle(shape.getAngle());
        if (isText && !SchemeUtils.isEmpty(shape.TxtAngle)) {
            angle = VsdxUtils.convertDouble(shape.TxtAngle, shape);
            if (shape.isFlipX() ^ shape.isFlipY()) {
                angle *= -1.0;
            }
            props.Angle += SchemeUtils.convertAngle(angle);
        }
        angle = shape.getAngle();
        if (isText && !SchemeUtils.isEmpty(shape.TxtAngle)) {
            angle += VsdxUtils.convertDouble(shape.TxtAngle, shape);
        }
        props.Angle = SchemeUtils.convertAngle(angle);
        return props;
    }

    public static boolean calcEllipseRow(VsdxShape shape, VsdxGeometryRow row, EllipseRowInfo info) {
        double delta;
        assert (row != null);
        assert (shape != null);
        assert (info != null);
        if (!VsdxUtils.isEllipse(row.T)) {
            return false;
        }
        double rowX = VsdxUtils.convertDouble(row.X, shape);
        double rowY = VsdxUtils.convertDouble(row.Y, shape);
        double rowA = VsdxUtils.convertDouble(row.A, shape);
        double rowB = VsdxUtils.convertDouble(row.B, shape);
        double rowC = VsdxUtils.convertDouble(row.C, shape);
        double rowD = VsdxUtils.convertDouble(row.D, shape);
        double angle1 = SchemeUtils.calcAngle(rowA - rowX, rowB - rowY);
        double angle2 = SchemeUtils.calcAngle(rowC - rowX, rowD - rowY);
        double angle90 = 1.5707963267948966;
        double angle180 = Math.PI;
        for (delta = angle2 - angle1; delta < 0.0; delta += angle180) {
        }
        while (delta > angle180) {
            delta -= angle180;
        }
        if (!SchemeUtils.isEqual(delta, angle90)) {
            return false;
        }
        double distance1 = SchemeUtils.distance(rowX, rowY, rowA, rowB);
        double distance2 = SchemeUtils.distance(rowX, rowY, rowC, rowD);
        info.radiusX = SchemeUtils.inchToMM(distance1);
        info.radiusY = SchemeUtils.inchToMM(distance2);
        if (!SchemeUtils.isEqual(distance1, distance2)) {
            info.angle = angle1;
        }
        info.offsetX = -VsdxReader.inchToMM(shape.Width, shape) / 2.0 + SchemeUtils.inchToMM(rowX);
        info.offsetY = VsdxReader.inchToMM(shape.Height, shape) / 2.0 - SchemeUtils.inchToMM(rowY);
        return true;
    }

    public static boolean isThemed(String v) {
        return "Themed".equals(v);
    }

    public static String validateFunction(String function) {
        if (function == null) {
            return null;
        }
        return (function = function.trim()).equals("") || function.equalsIgnoreCase("Inh") || function.equalsIgnoreCase("No Formula") ? null : function;
    }

    public static String doubleToDateFormat(double time) {
        long milliseconds = (long)((time - 25569.0) * 8.64E7);
        Date date = new Date(milliseconds);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static PolarPoint convertCartesianToPolar(double x, double y) {
        double angle = VsdxUtils.getPolarAngle(x, y);
        double length = Math.sqrt(x * x + y * y);
        return new PolarPoint(length, angle);
    }

    private static double getPolarAngle(double x, double y) {
        double angle = 0.0;
        if (x > 0.0 && y >= 0.0) {
            angle = Math.atan(y / x);
        } else if (x > 0.0 && y < 0.0) {
            angle = Math.atan(y / x) + Math.PI * 2;
        } else if (x < 0.0) {
            angle = Math.atan(y / x) + Math.PI;
        } else if (x == 0.0 && y > 0.0) {
            angle = 1.5707963267948966;
        } else if (x == 0.0 && y < 0.0) {
            angle = 4.71238898038469;
        }
        return (Math.PI * 2 - angle) % (Math.PI * 2);
    }

    public static class PolarPoint {
        public static final PolarPoint ZERO = new PolarPoint(0.0, 0.0);
        private final double length;
        private final double rad;

        public PolarPoint(double length, double rad) {
            this.length = length;
            this.rad = rad;
        }

        public double getLength() {
            return this.length;
        }

        public double getDegrees() {
            return this.rad * 180.0 / Math.PI;
        }

        public String toString() {
            return "PolarPoint{length=" + this.length + ", angle=" + this.rad + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PolarPoint)) {
                return false;
            }
            PolarPoint that = (PolarPoint)o;
            return Double.compare(this.length, that.length) == 0 && Double.compare(this.rad, that.rad) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.length, this.rad);
        }
    }

    public static class EllipseRowInfo {
        public double offsetX;
        public double offsetY;
        public double radiusX;
        public double radiusY;
        public double angle;
    }

    public static class VsdxTransformProps {
        public double OrgX;
        public double OrgY;
        public double CenterX;
        public double CenterY;
        public double ScaleX;
        public double ScaleY;
        public double Angle;

        public AffineTransform genTransform(boolean calcOrg, boolean calcAngle, boolean calcScale, boolean calcCenter) {
            AffineTransform Transform = new AffineTransform();
            if (calcOrg && this.OrgX != 0.0 || this.OrgY != 0.0) {
                Transform.translate(this.OrgX, this.OrgY);
            }
            double gradToRad = Math.PI / 180;
            if (calcAngle && this.Angle != 0.0) {
                Transform.rotate(this.Angle * gradToRad);
            }
            if (calcScale && this.ScaleX != 1.0 || this.ScaleY != 1.0) {
                Transform.scale(this.ScaleX, this.ScaleY);
            }
            if (calcCenter && this.CenterX != 0.0 || this.CenterY != 0.0) {
                Transform.translate(this.CenterX, this.CenterY);
            }
            return Transform;
        }
    }

    public static class VsdxShapeStyle {
        public String LinePattern;
        public Color pColor;
        public String lWidth;
        public String LineTransp;
        public String FillPattern;
        public String Transp;
        public Color Color;
        public Color BkColor;
    }
}

