/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.evaluator;

import inform.agent.schemes.converters.vsdx.evaluator.AbstractSyntaxTreeNode;
import inform.agent.schemes.converters.vsdx.evaluator.ExpressionTokenizer;
import inform.agent.schemes.converters.vsdx.evaluator.Token;
import inform.agent.schemes.converters.vsdx.evaluator.resolvers.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;

public class ExpressionParser {
    private final ExpressionTokenizer et;
    private Token currentToken;
    VariableResolver resolverForVariables;

    public ExpressionParser(ExpressionTokenizer et, VariableResolver resolver) throws Exception {
        this.et = et;
        this.currentToken = et.nextToken();
        this.resolverForVariables = resolver;
    }

    public AbstractSyntaxTreeNode parseExpression() throws Exception {
        return this.calcExpression();
    }

    private Token skipToken(Token.Type ... types) throws Exception {
        Token current = this.currentToken;
        if (types.length != 0 && !this.isOfType(types)) {
            throw new Exception("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0442\u043e\u043a\u0435\u043d\u0430 (" + current.type.toString() + "), \u043e\u0436\u0438\u0434\u0430\u043b\u0441\u044f: " + types[0].toString());
        }
        this.currentToken = this.et.nextToken();
        return current;
    }

    private boolean isOfType(Token.Type ... types) {
        return Arrays.stream(types).filter(t -> t == this.currentToken.type).findFirst().orElse(null) != null;
    }

    private AbstractSyntaxTreeNode calcExpression() throws Exception {
        return this.calcAddition();
    }

    private AbstractSyntaxTreeNode calcAddition() throws Exception {
        AbstractSyntaxTreeNode left = this.calcMultiplication();
        while (this.isOfType(Token.Type.Addition, Token.Type.Subtraction)) {
            Token op = this.skipToken(Token.Type.Addition, Token.Type.Subtraction);
            AbstractSyntaxTreeNode right = this.calcMultiplication();
            left = new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), left, right);
        }
        return left;
    }

    private AbstractSyntaxTreeNode calcMultiplication() throws Exception {
        AbstractSyntaxTreeNode left = this.basicOperand();
        while (this.isOfType(Token.Type.Multiplication, Token.Type.Division)) {
            Token op = this.skipToken(Token.Type.Multiplication, Token.Type.Division);
            AbstractSyntaxTreeNode right = this.basicOperand();
            left = new AbstractSyntaxTreeNode.AstElementaryOperationNode(op.value.charAt(0), left, right);
        }
        return left;
    }

    private AbstractSyntaxTreeNode basicOperand() throws Exception {
        if (this.isOfType(Token.Type.OpeningBracket)) {
            this.skipToken(Token.Type.OpeningBracket);
            AbstractSyntaxTreeNode expr = this.calcExpression();
            this.skipToken(Token.Type.ClosingBracket);
            return expr;
        }
        if (this.isOfType(Token.Type.Number)) {
            Token num = this.skipToken(Token.Type.Number);
            return new AbstractSyntaxTreeNode.AstNumberNode(Double.parseDouble(num.value));
        }
        if (this.isOfType(Token.Type.Variable)) {
            Token variable = this.skipToken(Token.Type.Variable);
            return new AbstractSyntaxTreeNode.AstVariableNode(variable.value, this.resolverForVariables);
        }
        if (this.isOfType(Token.Type.Function)) {
            Token function = this.skipToken(Token.Type.Function);
            this.skipToken(Token.Type.OpeningBracket);
            ArrayList<AbstractSyntaxTreeNode> functionArguments = new ArrayList<AbstractSyntaxTreeNode>();
            functionArguments.add(this.calcExpression());
            while (this.isOfType(Token.Type.Comma)) {
                this.skipToken(Token.Type.Comma);
                functionArguments.add(this.calcExpression());
            }
            this.skipToken(Token.Type.ClosingBracket);
            return new AbstractSyntaxTreeNode.AstFunctionCallNode(function.value, functionArguments);
        }
        throw new Exception("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
    }
}

