/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.Core;
import inform.agent.db.AbstractConnectionManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class BaseServerSideExecutable
extends ScriptableObject {
    public static final String[] systemJSFunctions = new String[]{"toString", "startTransaction", "commitTransaction", "rollbackTransaction", "save", "sleep", "createDatasource", "createScript", "createSqlStatement", "createCallableStatement", "roundTo", "simpleRoundTo", "Int", "getTickCount", "isNumberEquals", "isNumberZero", "createGuid"};
    private final Collection<ScriptableObject> dynamical = new ArrayList<ScriptableObject>();
    private static final double D_RES = 1.0E-12;

    @Override
    public String getClassName() {
        return "BaseServerSideExecutable";
    }

    public BaseServerSideExecutable() {
        this.defineFunctionProperties(systemJSFunctions, BaseServerSideExecutable.class, 0);
        BaseServerSideExecutable.putConstProperty(this, "TRANSACTION_READ_COMMITTED", AbstractConnectionManager.IsolationLevel.TRANSACTION_READ_COMMITTED.getValue());
        BaseServerSideExecutable.putConstProperty(this, "TRANSACTION_REPEATABLE_READ", AbstractConnectionManager.IsolationLevel.TRANSACTION_REPEATABLE_READ.getValue());
        BaseServerSideExecutable.putConstProperty(this, "TRANSACTION_SERIALIZABLE", AbstractConnectionManager.IsolationLevel.TRANSACTION_SERIALIZABLE.getValue());
    }

    public abstract String toString();

    public double roundTo(double value, int digits) {
        if (digits <= 0) {
            double shift = Math.pow(10.0, -digits);
            double d = Math.rint(value * shift);
            return d / shift;
        }
        double shift = Math.pow(10.0, digits);
        double d = Math.rint(value / shift);
        return d * shift;
    }

    public double Int(double val) {
        if (val > 0.0) {
            return Math.floor(val);
        }
        return Math.ceil(val);
    }

    public long getTickCount() {
        return Core.clock();
    }

    public boolean isNumberEquals(double a, double b, double eps) {
        return BaseServerSideExecutable.sameValue(a, b, eps);
    }

    public boolean isNumberZero(double a, double eps) {
        if (Double.isNaN(eps) || eps == 0.0) {
            eps = 1.0E-12;
        }
        return Math.abs(a) <= eps;
    }

    public double simpleRoundTo(double value, int digits) {
        double vi;
        double shift = Math.pow(10.0, -digits);
        double v = Math.abs(value * shift);
        double frac = v - (vi = Math.floor(v));
        if (frac > 0.49999) {
            vi += 1.0;
        }
        double r = vi / shift;
        return value < 0.0 ? -r : r;
    }

    public String createGuid() {
        return UUID.randomUUID().toString().toUpperCase();
    }

    public static double internalRoundTo(double value, int digits) {
        double vi;
        double shift = Math.pow(10.0, -digits);
        double v = Math.abs(value * shift);
        double frac = v - (vi = Math.floor(v));
        if (frac > 0.49999) {
            vi += 1.0;
        }
        double r = vi / shift;
        return value < 0.0 ? -r : r;
    }

    public static boolean sameValue(double a, double b, double eps) {
        if (Double.isNaN(eps) || eps == 0.0) {
            eps = Math.max(Math.min(Math.abs(a), Math.abs(b)) * 1.0E-12, 1.0E-12);
        }
        if (a > b) {
            return a - b <= eps;
        }
        return b - a <= eps;
    }

    public abstract void startTransaction();

    public abstract void commitTransaction() throws Exception;

    public abstract void rollbackTransaction() throws SQLException;

    public abstract void save() throws Exception;

    public abstract void sleep(int var1) throws InterruptedException;

    public abstract Object createDatasource(double var1, double var3);

    public abstract Object createScript(double var1);

    public abstract Scriptable createSqlStatement(double var1) throws SQLException;

    public abstract Scriptable createCallableStatement(double var1) throws SQLException;
}

