/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.files.BFS;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.UnsupportedTypeField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.sql.SQLException;

public class BlobFileField
extends UnsupportedTypeField {
    private static final String[] availJSPropertiesNames = new String[]{"asBinary", "blobSize"};
    private static final String[] availJSFunctionsNames = new String[]{"loadFromFile", "moveFromFile", "saveToFile"};

    BlobFileField(FieldDescriptor desc, RowsetAccessor ra) {
        super(desc, ra);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, BlobFileField.class, 0);
        }
        this.defineFunctionProperties(availJSFunctionsNames, BlobFileField.class, 0);
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof BinaryObject || value instanceof String;
    }

    public String getBlobPath() throws IOException {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        Object value = this.ra.getCurrentRow().getComplex(this.desc.getIndex());
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof BFS.BlobDigest) {
            BFS.BlobDigest blobDigest = (BFS.BlobDigest)value;
            if (BFS.isStorageContainsHashedBlob(this.ra.getHost(), this.ra.getTableDescriptor(), this.desc, blobDigest.digest)) {
                return BFS.digestToBlobPath(this.ra.getTableDescriptor(), this.desc, blobDigest.digest);
            }
            return BFS.getFullTempPath(this.ra.getTableDescriptor(), this.desc, blobDigest.digest);
        }
        return null;
    }

    private byte[] getAsBytes() throws IOException {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        String blobPath = this.getBlobPath();
        if (blobPath == null) {
            return null;
        }
        return BFS.getFileBytes(this.desc, blobPath);
    }

    @Override
    public BinaryObject getAsBinary() throws Exception {
        byte[] bytes = this.getAsBytes();
        return bytes == null ? null : new BinaryObject(bytes);
    }

    public long getBlobSize() throws IOException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0L;
        }
        String blobPath = this.getBlobPath();
        if (blobPath == null) {
            return 0L;
        }
        return BFS.getFileSize(this.desc, blobPath);
    }

    @Override
    public String getAsString() throws InformException {
        try {
            byte[] bytes = this.getAsBytes();
            return bytes == null ? "" : new String(bytes, TaggedWriter.ANSI);
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
    }

    public InputStream openFileStream() throws IOException {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        String blobPath = this.getBlobPath();
        if (blobPath == null) {
            return null;
        }
        return BFS.getFileStream(this.desc, blobPath);
    }

    public File getBlobFile() throws IOException {
        String blobPath = this.getBlobPath();
        if (blobPath == null) {
            return null;
        }
        return new File(BFS.getResolvedFilePath(this.desc, blobPath));
    }

    public void saveToFile(String pathname) throws IOException, InformException, SQLException {
        File dst = Core.mountfs.resolve(new File(pathname));
        if (!this.ra.isCurrentRowAvailable()) {
            dst.createNewFile();
            return;
        }
        String blobPath = this.getBlobPath();
        if (blobPath == null) {
            return;
        }
        String src = BFS.getResolvedFilePath(this.desc, blobPath);
        BlobFileField.copyFile(new File(src), dst);
    }

    @Override
    public void setAsBinary(BinaryObject value) throws Exception {
        FieldDescriptor field = this.desc;
        if (value == null || value.getSize() == 0) {
            this.ra.getCurrentRow().setNullFlag(field.getIndex());
            this.notifyModified();
        } else {
            TableDescriptor table = this.ra.getTableDescriptor();
            BFS.checkBlobFSField(table, field);
            byte[] digest = BFS.setTempBlob(this.ra.getHost(), table, field, value.getInternalBuffer(), value.getSize());
            this.ra.getCurrentRow().setComplex(this.desc.getIndex(), new BFS.BlobDigest(digest));
            this.notifyModified();
        }
    }

    @Override
    protected void assignNotNullValue(Object value) {
        boolean modified = false;
        if (value instanceof BinaryObject) {
            modified = this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), value);
        } else {
            super.assignNotNullValue(value);
        }
        if (modified) {
            this.notifyModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String filePath) throws IOException {
        FieldDescriptor field = this.desc;
        TableDescriptor table = this.ra.getTableDescriptor();
        BFS.checkBlobFSField(table, field);
        File file = Core.mountfs.resolve(new File(filePath));
        try (RandomAccessFile fileInputStream = new RandomAccessFile(file, "r");){
            byte[] digest = BFS.uploadBlobDigest(this.ra.getHost(), fileInputStream);
            String blobPoint = BFS.uploadHashedBlob(this.ra.getHost(), table, field, digest, fileInputStream);
            if (blobPoint == null) {
                BFS.uploadTempBlob(this.ra.getHost(), table, field, digest, fileInputStream);
                this.ra.getCurrentRow().setComplex(this.desc.getIndex(), new BFS.BlobDigest(digest));
            } else {
                this.ra.getCurrentRow().setComplex(this.desc.getIndex(), new BFS.BlobRef(blobPoint));
            }
            this.notifyModified();
        }
    }

    public void moveFromFile(String filePath) throws IOException {
        FieldDescriptor field = this.desc;
        TableDescriptor table = this.ra.getTableDescriptor();
        BFS.checkBlobFSField(table, field);
        byte[] digest = BFS.moveFile(this.ra.getHost(), table, field, filePath);
        if (digest == null) {
            return;
        }
        this.ra.getCurrentRow().setComplex(this.desc.getIndex(), new BFS.BlobDigest(digest));
        this.notifyModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        try (FileInputStream fin = new FileInputStream(src);
             FileOutputStream fout = new FileOutputStream(dst);){
            FileChannel ci = fin.getChannel();
            FileChannel co = fout.getChannel();
            long size = ci.size();
            for (long position = 0L; position < size; position += co.transferFrom(ci, position, size - position)) {
            }
        }
    }

    @Override
    public Object getValue() throws Exception {
        try {
            return this.getAsBinary();
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    protected void notifyModified() {
        if (this.desc.hasBlobSizeFields()) {
            long size = 0L;
            try {
                size = this.getBlobSize();
            }
            catch (IOException ex) {
                throw InformException.wrap(ex);
            }
            TableDescriptor td = this.ra.getTableDescriptor();
            for (int c : this.desc.getBlobSizeFields()) {
                FieldDescriptor fd = td.getExistingFieldDescriptor(c);
                if (fd == null) continue;
                this.ra.getCurrentRow().setNumeric(fd.getIndex(), size);
            }
        }
        super.notifyModified();
    }
}

