/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.connect.ResultSet;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.SSContext;
import java.io.IOException;
import java.sql.SQLException;

public class BlobReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryObject read(SSContext ssContext, AbstractConnectionManager dbManager, TableDescriptor table, FieldDescriptor field, double recordId) throws IOException, TaggedReaderException, SQLException {
        DatabaseDescriptor db = table.getDatabaseDescriptor();
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(field.getRawName()).append(" from ");
        db.appendTableRawName(table.getRawName(), sql);
        sql.append(" where ").append(table.getRecordIdField().getRawName()).append("=?");
        DatabaseConnection database = dbManager.getConnection(table.getDbId(), "JS:BlobReader");
        try (PreparedStatement statement = database.prepareStatement("BlobReader.loadBLOB", sql.toString());){
            statement.setQueryTimeout();
            statement.setDouble(1, recordId);
            try (ResultSet fetch = statement.executeQuery(ssContext);){
                if (fetch.next()) {
                    BinaryObject binaryObject = new BinaryObject(fetch.getBlobBytes(1));
                    return binaryObject;
                }
            }
        }
        return null;
    }
}

