/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.Task;
import inform.agent.scripts.libs.SdoLibrary;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import org.mozilla.javascript.ScriptableObject;

public class CallableStatement
extends ScriptableObject {
    private final Task task;
    private AbstractConnectionManager dbManager;
    private DatabaseConnection db;
    private inform.agent.db.connect.CallableStatement stmt;
    private final SSContext ssContext;
    private static final String[] availableJSMethods = new String[]{"setInt", "setDouble", "setDate", "setString", "setNString", "setGeometry", "registerOutInt", "registerOutDouble", "registerOutDate", "registerOutString", "registerOutParameter", "execute", "getInt", "getDouble", "getDate", "getString", "getGeometry", "close"};
    private static final String[] availableJSProperties = new String[]{"sql"};

    @Override
    public String getClassName() {
        return "CallableStatement";
    }

    public CallableStatement(Task task, double connectionID) throws SQLException {
        this.task = task;
        this.dbManager = task.getDBManager();
        this.db = this.dbManager.getConnection(connectionID, "JS:CallableStatement");
        ServerSideHost host = task.getHost();
        SSContext parentContext = host instanceof ScriptableHost ? ((ScriptableHost)((Object)host)).getRootContext() : null;
        SSContext sSContext = this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, 2);
        if (this.ssContext != null) {
            this.ssContext.nodeId = connectionID;
        }
        this.defineFunctionProperties(availableJSMethods, this.getClass(), 0);
        for (String propertyName : availableJSProperties) {
            this.defineProperty(propertyName, this.getClass(), 0);
        }
        CallableStatement.putConstProperty(this, "database", task.getDatabase(connectionID));
    }

    public void setSql(String sql) throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = this.db.prepareCall(sql);
        this.stmt.setLogDangerSQL();
        this.stmt.setQueryTimeout();
    }

    public void setInt(int index, Object objValue) throws SQLException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.INTEGER);
            } else {
                int value = ValueCaster.toInt(objValue);
                this.stmt.setInt(index, value);
            }
        }
    }

    public void setDouble(int index, Object objValue) throws SQLException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.DOUBLE);
            } else {
                double value = ValueCaster.toDouble(objValue);
                this.stmt.setDouble(index, value);
            }
        }
    }

    public void setDate(int index, Object objValue) throws SQLException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.TIMESTAMP);
            } else {
                double value = ValueCaster.toDouble(objValue);
                this.stmt.setDateTime(index, value);
            }
        }
    }

    public void setString(int index, Object objValue) throws SQLException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.STRING);
            } else {
                String value = ValueCaster.toString(objValue);
                this.stmt.setString(index, value);
            }
        }
    }

    public void setNString(int index, Object objValue) throws SQLException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.STRING);
            } else {
                String value = ValueCaster.toString(objValue);
                this.stmt.setNString(index, value);
            }
        }
    }

    public void setGeometry(int index, Object objValue) throws SQLException, IOException {
        if (this.stmt != null) {
            if (objValue == null) {
                this.stmt.setNull(index, SqlDataType.GEOMETRY);
            } else {
                this.stmt.setGeometry(index, ((SdoLibrary.GeoObject)objValue).toGeometry());
            }
        }
    }

    public void registerOutInt(int index) throws SQLException {
        if (this.stmt != null) {
            this.stmt.registerOutParameter(index, 4);
        }
    }

    public void registerOutDouble(int index) throws SQLException {
        if (this.stmt != null) {
            this.stmt.registerOutParameter(index, 8);
        }
    }

    public void registerOutDate(int index) throws SQLException {
        if (this.stmt != null) {
            this.stmt.registerOutParameter(index, 91);
        }
    }

    public void registerOutString(int index) throws SQLException {
        if (this.stmt != null) {
            this.stmt.registerOutParameter(index, 12);
        }
    }

    public void registerOutParameter(int index, int type) throws SQLException {
        if (this.stmt != null) {
            this.stmt.registerOutParameter(index, type);
        }
    }

    public int getInt(int index) throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getInt(index);
        }
        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c %d", index));
    }

    public double getDouble(int index) throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getDouble(index);
        }
        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c %d", index));
    }

    public Date getDate(int index) throws SQLException {
        if (this.stmt != null) {
            return new Date(this.stmt.getTimestamp(index).getTime());
        }
        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c %d", index));
    }

    public String getString(int index) throws SQLException {
        if (this.stmt != null) {
            return this.stmt.getString(index);
        }
        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c %d", index));
    }

    public Object getGeometry(int index) throws SQLException, IOException {
        if (this.stmt != null) {
            return SdoLibrary.createGeometryObject(this.stmt.getGeometry(index));
        }
        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441 \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u043c %d", index));
    }

    public void close() throws SQLException {
        this.internalClose();
        this.task.detach(this);
    }

    void internalClose() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = null;
    }

    public void execute() throws SQLException {
        if (this.stmt != null) {
            this.stmt.execute(this.ssContext);
        }
    }
}

