/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.Node;
import java.io.IOException;
import java.lang.ref.SoftReference;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;

public class CompiledScriptsCache {
    private static final int TAG_SS_SCRIPT = 1;
    private static final DoubleHash<CompiledScript> CACHE = new DoubleHash();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script get(BasicNode node) throws IOException {
        Script result;
        CompiledScript cs;
        long mct = node.getModificationContentTime();
        String source = null;
        DoubleHash<CompiledScript> doubleHash = CACHE;
        synchronized (doubleHash) {
            cs = CACHE.get(node.getId());
        }
        if (cs != null && (result = (Script)cs.get()) != null) {
            if (cs.modContentTime == mct) {
                return result;
            }
            source = CompiledScriptsCache.getScriptSource(node);
            if (source.equals(cs.source)) {
                return result;
            }
        }
        if (source == null) {
            source = CompiledScriptsCache.getScriptSource(node);
        }
        result = CompiledScriptsCache.compileScript(source, node);
        cs = new CompiledScript(result, node.getId(), mct, source);
        DoubleHash<CompiledScript> doubleHash2 = CACHE;
        synchronized (doubleHash2) {
            CACHE.add(cs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Script compileScript(String source, Node node) {
        Context cx = Core.asmoJsContextFactory.enterContext();
        try {
            Script script = cx.compileString(source, node == null ? "" : node.toLogString(), 1, null);
            return script;
        }
        finally {
            Context.exit();
        }
    }

    private static String getScriptSource(BasicNode node) throws IOException {
        byte[] content = node.getContent();
        switch (node.getType()) {
            case 14: {
                return new String(content, TaggedWriter.ANSI);
            }
            case 47: 
            case 48: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("getScriptSource:" + node.getType());
            }
        }
        TaggedReader reader = new TaggedReader(content);
        while (reader.next()) {
            if (reader.getCurrentTag() != 1) continue;
            return reader.getAnsi();
        }
        return "";
    }

    private static class CompiledScript
    extends SoftReference<Script>
    implements DoubleHash.Entry {
        final double nodeId;
        final long modContentTime;
        final String source;

        CompiledScript(Script script, double nodeId, long modContentTime, String source) {
            super(script);
            this.nodeId = nodeId;
            this.modContentTime = modContentTime;
            this.source = source;
        }

        @Override
        public double key() {
            return this.nodeId;
        }
    }
}

