/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.agent.ServerSideHost;
import inform.agent.scripts.BaseServerSideExecutable;
import inform.agent.scripts.CallableStatement;
import inform.agent.scripts.Closeables;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Script;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.Task;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.ScriptableObject;

public abstract class GenericServerSideExecutable
extends BaseServerSideExecutable
implements Task {
    public static final long HEAP_MAX = Runtime.getRuntime().maxMemory();
    public static final long HEAP_LIM = Math.max(HEAP_MAX * 7L / 10L, HEAP_MAX - 0x40000000L);
    private static final int TAG_DATAMODEL = 152;
    private static final int TAG_SS_SCRIPT = 1;
    private static final int TAG_SS_MEM_LIMIT = 13;
    protected final double nodeID;
    protected final ServerSideHost ssHost;
    protected final Task parent;
    protected final Collection<ScriptableObject> dynamical = new ArrayList<ScriptableObject>();
    public final SSContext.Component ssContext;
    private final AtomicInteger idGenerator = new AtomicInteger();
    private Closeables closeables = null;

    public GenericServerSideExecutable(SSContext parentContext, int componentType, double nodeID, ServerSideHost ssHost, Task parent) {
        this.nodeID = nodeID;
        this.ssHost = ssHost;
        this.parent = parent;
        this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, componentType);
    }

    @Override
    public String getClassName() {
        return "GenericServerSideExecutable";
    }

    @Override
    public double nodeId() {
        return this.nodeID;
    }

    @Override
    public Task parentTask() {
        return this.parent;
    }

    @Override
    public ServerSideHost getHost() {
        return this.ssHost;
    }

    double getUserId() {
        return this.ssHost.getUserID();
    }

    @Override
    public String toString() {
        return this.getClassName() + "(" + NumberConverter.doubleToString(this.nodeID) + ")";
    }

    @Override
    public void sleep(int n) throws InterruptedException {
        int sleep;
        do {
            this.ssHost.idle();
            sleep = Math.min(100, n);
            Thread.sleep(sleep);
        } while ((n -= sleep) > 0);
        this.ssHost.idle();
    }

    @Override
    public Object createScript(double nodeId) {
        try {
            Script s = new Script(this.ssContext, this, nodeId);
            this.dynamical.add(s);
            s.setParentScope(this);
            return s;
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    public void detach(Object o) {
        if (o instanceof ScriptableObject) {
            this.dynamical.remove((ScriptableObject)o);
        }
    }

    @Override
    public Collection<ScriptableObject> getDynamical() {
        return this.dynamical;
    }

    public void close() {
        Iterator<ScriptableObject> i = this.dynamical.iterator();
        while (i.hasNext()) {
            ScriptableObject o = i.next();
            if (o instanceof Datasource) {
                ((Datasource)o).internalClose();
            } else if (o instanceof Script) {
                ((Script)o).internalClose();
            } else {
                try {
                    if (o instanceof SqlStatement) {
                        ((SqlStatement)o).internalClose();
                    } else if (o instanceof CallableStatement) {
                        ((CallableStatement)o).internalClose();
                    }
                }
                catch (SQLException e) {
                    throw InformException.wrap(e);
                }
            }
            i.remove();
        }
        if (this.closeables != null) {
            this.closeables.closeAll();
        }
    }

    @Override
    public int generateId() {
        return this.idGenerator.incrementAndGet();
    }

    @Override
    public void updateId(int id) {
        int current = this.idGenerator.get();
        if (current < id) {
            this.idGenerator.compareAndSet(current, id);
        }
    }

    @Override
    public void registerCloseable(Closeable closeable) {
        if (this.closeables == null) {
            this.closeables = new Closeables();
        }
        this.closeables.register(closeable);
    }

    @Override
    public void detachCloseable(Closeable closeable) {
        if (this.closeables != null) {
            this.closeables.detach(closeable);
        }
    }
}

