/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.scripts.MailAttachment;
import inform.agent.scripts.MailMessage;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class SMTPConnection
extends ScriptableObject {
    private static final int KNOWN_SSL_PORT = 465;
    private static final String[] availJSFunctionsNames = new String[]{"connect", "send", "close"};
    private static final String[] jsProperties = new String[]{"authMechanizm", "username", "password", "host", "timeout"};
    private static final String HEADER_ERROR = "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 '%s' \u0447\u0435\u0440\u0435\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 headers. \u0414\u043b\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u044d\u0442\u043e\u0433\u043e \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0435 js-\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f.";
    private Session session = null;
    private Transport tr = null;
    private Properties props = null;
    private String authMechanizm = "";
    private String host = "";
    private String username;
    private String password;
    private Integer timeout = 6000000;
    private static final Integer connectionTimeout = 10000;
    private static CharsetEncoder usAscIIEncoder = null;

    SMTPConnection() {
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, this.getClass(), 0);
        }
        this.authMechanizm = "DIGEST-MD5 LOGIN PLAIN NTLM";
    }

    @Override
    public String getClassName() {
        return "SMTPConnection";
    }

    public String getAuthMechanizm() throws InformException {
        return this.authMechanizm;
    }

    public void setAuthMechanizm(String authMechanizm) {
        this.authMechanizm = authMechanizm;
    }

    public String getHost() throws InformException {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() throws InformException {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = Strings.isVoid(password) ? null : password;
    }

    public String getUsername() throws InformException {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = Strings.isVoid(username) ? null : username;
    }

    public Integer getTimeout() throws InformException {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public static void connect(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws NoSuchProviderException, MessagingException, Exception {
        boolean debug = !Strings.isVoid(Ini.DebugMail);
        SMTPConnection self = (SMTPConnection)thisObj;
        try {
            if (debug) {
                Core.logger.info("DEBUG: getting system properties");
            }
            self.props = new Properties(System.getProperties());
            if (debug) {
                self.props.put("mail.debug", "true");
                if (Ini.DebugMail.contains("auth")) {
                    self.props.put("mail.debug.auth", "true");
                }
            }
            self.props.put("mail.smtp.auth.mechanisms", self.authMechanizm);
            self.props.put("mail.smtp.connectiontimeout", connectionTimeout);
            self.props.put("mail.smtp.timeout", self.timeout);
            self.props.put("mail.smtp.starttls.enable", "true");
            self.props.put("mail.smtp.ssl.checkserveridentity", "false");
            self.props.put("mail.smtp.ssl.trust", "*");
            String host = self.host;
            int port = -1;
            int pidx = host.indexOf(58);
            if (pidx != -1) {
                port = Integer.parseInt(host.substring(pidx + 1));
                host = host.substring(0, pidx);
                if (port == 465) {
                    self.props.put("mail.smtp.ssl.enable", "true");
                }
            }
            if (debug) {
                Core.logger.info("DEBUG: obtaining session instance");
            }
            self.session = Session.getInstance(self.props, null);
            self.props = self.session.getProperties();
            if (debug) {
                Core.logger.info("DEBUG: configure mail-debugger");
                self.session.setDebug(true);
                self.session.setDebugOut(new PrintStream(new OutputStream(){
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();

                    @Override
                    public void write(int b) throws IOException {
                        if (b == 10 || b == 13) {
                            this.flush();
                            return;
                        }
                        this.buffer.write(b);
                    }

                    @Override
                    public void flush() throws IOException {
                        if (this.buffer.size() == 0) {
                            return;
                        }
                        Core.logger.info(new String(this.buffer.internalBuffer(), 0, this.buffer.size(), TaggedWriter.ANSI));
                        this.buffer.reset();
                    }
                }, true, "CP1251"));
            }
            Core.logger.info("DEBUG: obtaining transport");
            self.tr = self.session.getTransport("smtp");
            Core.logger.info("DEBUG: transport connecting");
            String password = Strings.isVoid(self.username) ? null : self.password;
            self.tr.connect(host, port, self.username, password);
        }
        catch (Exception e) {
            Core.logger.info("DEBUG: catched \"" + e + "\", closing connection");
            self.tr.close();
            throw InformException.wrap(e, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 SMPT \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (host: %s, username: %s)", self.host, self.username));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws NoSuchProviderException, MessagingException, Exception {
        String[] DEFAULT_HEADERS_LOWER_CASE = new String[]{"subject", "from", "to", "cc", "bcc"};
        SMTPConnection self = (SMTPConnection)thisObj;
        if (args.length > 0 && args[0] instanceof MailMessage) {
            MailMessage postMsg = (MailMessage)args[0];
            MimeMessage msg = new MimeMessage(self.session);
            if (!postMsg.turnInMessage()) {
                postMsg.initHeaders(msg);
            }
            try {
                String fromAddress = postMsg.getFromAddress();
                if (fromAddress != null && fromAddress.length() > 0) {
                    try {
                        msg.setFrom(SMTPConnection.encodeAddress(fromAddress));
                    }
                    catch (AddressException e) {
                        throw InformException.wrap(e, String.format("\u0410\u0434\u0440\u0435\u0441 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f \u0437\u0430\u0434\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e: \"%s\"", fromAddress));
                    }
                }
                if (postMsg.getToAddress().isEmpty()) {
                    throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u0434\u0440\u0435\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f!");
                }
                try {
                    msg.setRecipients(Message.RecipientType.TO, SMTPConnection.encodeAddress(postMsg.getToAddress()));
                    if (!postMsg.getCcAddress().isEmpty()) {
                        msg.addRecipients(Message.RecipientType.CC, SMTPConnection.encodeAddress(postMsg.getCcAddress()));
                    }
                    if (!postMsg.getBccAddress().isEmpty()) {
                        msg.addRecipients(Message.RecipientType.BCC, SMTPConnection.encodeAddress(postMsg.getBccAddress()));
                    }
                }
                catch (AddressException e) {
                    throw InformException.wrap(e, String.format("\u0410\u0434\u0440\u0435\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u0434\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u043e: \"%s\"", postMsg.getToAddress()));
                }
                msg.setSubject(postMsg.getSubject());
                if (postMsg._isEmpty()) {
                    throw new InformException("\u041f\u0443\u0441\u0442\u043e\u0439 \u043a\u043e\u043d\u0442\u0435\u043d\u0442 \u043f\u0438\u0441\u044c\u043c\u0430");
                }
                if (postMsg.getAttachments().getAttc().isEmpty() && !postMsg.isTextAndHtmlPresent()) {
                    if (postMsg.isTextHtmlPresent()) {
                        msg.setText(postMsg.getTextHtml(), "windows-1251", "html");
                    } else if (postMsg.isTextPresent()) {
                        msg.setText(postMsg.getText(), "windows-1251");
                    }
                } else {
                    MimeBodyPart text;
                    Object[] mp = new MimeMultipart(postMsg.isTextAndHtmlPresent() ? "alternative" : "mixed");
                    if (postMsg.isTextPresent()) {
                        text = new MimeBodyPart();
                        text.setText(postMsg.getText(), "windows-1251");
                        mp.addBodyPart(text);
                    }
                    if (postMsg.isTextHtmlPresent()) {
                        text = new MimeBodyPart();
                        text.setText(postMsg.getTextHtml(), "windows-1251", "html");
                        mp.addBodyPart(text);
                    }
                    ArrayList<MailAttachment> atts = postMsg.getAttachments().getAttc();
                    for (int i = 0; i < atts.size(); ++i) {
                        if (atts.get(i).getContent() == null) continue;
                        String rawFileName = atts.get(i).getFileName();
                        atts.get(i).encodeFileName();
                        try {
                            mp.addBodyPart(atts.get(i).getContent());
                            continue;
                        }
                        finally {
                            atts.get(i).setFileName(rawFileName);
                        }
                    }
                    msg.setContent((Multipart)mp);
                }
                msg.setSentDate(new Date());
                for (Object name : postMsg.getHeaders().getIds()) {
                    String valueStr;
                    Object v;
                    String nameStr;
                    if (name == null || name.toString() == null || (nameStr = name.toString()).isEmpty() || !((v = postMsg.getHeaders().get(name)) instanceof String) && !(v instanceof ConsString) || (valueStr = v.toString()) == null || valueStr.isEmpty()) continue;
                    String nameStrLCase = nameStr.toLowerCase();
                    for (String s : DEFAULT_HEADERS_LOWER_CASE) {
                        if (!Strings.equals(nameStrLCase, s)) continue;
                        throw new InformException(String.format(HEADER_ERROR, s));
                    }
                    msg.setHeader(nameStr, valueStr);
                }
                msg.saveChanges();
                String msgId = postMsg.getAssignedMessageID();
                if (msgId != null) {
                    msg.setHeader("Message-ID", msgId);
                }
                self.tr.sendMessage(msg, msg.getAllRecipients());
                msgId = msg.getMessageID();
                postMsg.setMessageID(msgId);
            }
            catch (InformException e) {
                self.tr.close();
                throw e;
            }
            catch (Exception e) {
                self.tr.close();
                throw InformException.wrap(e, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f (\u0430\u0434\u0440\u0435\u0441 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044f: %s, \u0430\u0434\u0440\u0435\u0441 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044f: %s)", postMsg.getToAddress(), postMsg.getFromAddress() == null ? "" : postMsg.getFromAddress()));
            }
        }
    }

    public static void close(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws NoSuchProviderException, MessagingException, Exception {
        SMTPConnection self = (SMTPConnection)thisObj;
        try {
            if (self.tr != null) {
                self.tr.close();
            }
        }
        catch (Exception e) {
            throw InformException.wrap(e, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 SMTP \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
        }
    }

    private static boolean isUSASCII(String v) {
        if (usAscIIEncoder == null) {
            usAscIIEncoder = Charset.forName("US-ASCII").newEncoder();
        }
        return usAscIIEncoder.canEncode(v);
    }

    private static String encodeAddress(String str) throws UnsupportedEncodingException, AddressException {
        if (SMTPConnection.isUSASCII(str)) {
            return str;
        }
        InternetAddress[] address = InternetAddress.parse(str);
        if (address == null) {
            return str;
        }
        Address[] inetAddress = new InternetAddress[address.length];
        for (int i = 0; i < address.length; ++i) {
            if (address[i] == null || ((Address)address[i]).toString() == null) {
                inetAddress[i] = new InternetAddress("");
                continue;
            }
            InternetAddress ia = new InternetAddress(((Address)address[i]).toString());
            String personal = ia.getPersonal();
            if (personal != null) {
                ia.setPersonal(personal, "windows-1251");
            }
            inetAddress[i] = ia;
        }
        return InternetAddress.toString(inetAddress);
    }
}

