/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.FileSystemLibrary;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.io.OutputStream;

public class ScriptableBinaryFileWriter
extends SmartScriptableObject {
    private final OutputStream output;

    ScriptableBinaryFileWriter(OutputStream output) {
        this.output = output;
    }

    @Override
    public String getClassName() {
        return "BinaryFileWriter";
    }

    @SmartScriptableObject.FunctionTag
    public void write(Object obj) throws IOException {
        if (obj instanceof BinaryObject) {
            BinaryObject bobj = (BinaryObject)obj;
            this.output.write(bobj.getInternalBuffer(), 0, bobj.getSize());
        } else if (obj instanceof FileSystemLibrary.BinaryReader) {
            int l;
            FileSystemLibrary.BinaryReader br = (FileSystemLibrary.BinaryReader)obj;
            byte[] buffer = new byte[4096];
            while ((l = br.read(buffer, 0, buffer.length)) >= 0) {
                this.output.write(buffer, 0, l);
            }
        }
    }

    @SmartScriptableObject.FunctionTag
    public void flush() throws IOException {
        this.output.flush();
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.output.close();
    }
}

