/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.am.Telemeter;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.replication.ScriptReplicationsPack;
import inform.agent.scripts.AlignsLibrary;
import inform.agent.scripts.BordersLibrary;
import inform.agent.scripts.ColorsLibrary;
import inform.agent.scripts.Constants;
import inform.agent.scripts.CryptoLibrary;
import inform.agent.scripts.DataTypesLibrary;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.DateLibrary;
import inform.agent.scripts.DebugLibrary;
import inform.agent.scripts.Decimal;
import inform.agent.scripts.DocumentsLibrary;
import inform.agent.scripts.ExcelLibrary;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.scripts.FontsLibrary;
import inform.agent.scripts.FormatLibrary;
import inform.agent.scripts.LogLibrary;
import inform.agent.scripts.MailLibrary;
import inform.agent.scripts.NetLibrary;
import inform.agent.scripts.PageFormatLibrary;
import inform.agent.scripts.PdfLibrary;
import inform.agent.scripts.RequestStateDialog;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Script;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.SpreadsheetsLibrary;
import inform.agent.scripts.StringsLibrary;
import inform.agent.scripts.SysLogLibrary;
import inform.agent.scripts.TaggedIOLibrary;
import inform.agent.scripts.Task;
import inform.agent.scripts.TextDocumentsLibrary;
import inform.agent.scripts.TextLibrary;
import inform.agent.scripts.WebCanvasLibrary;
import inform.agent.scripts.libs.ExtFilesLibrary;
import inform.agent.scripts.libs.GeoLibrary;
import inform.agent.scripts.libs.SchemesLibrary;
import inform.agent.scripts.libs.SdoLibrary;
import inform.agent.scripts.libs.SoapLibrary;
import inform.agent.scripts.libs.SystemLibrary;
import inform.agent.scripts.libs.TestInternalsLibrary;
import inform.agent.scripts.libs.XmlLibrary;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.Permissions;
import inform.agent.scripts.notify.NotifyLib;
import inform.agent.scripts.server.ServerLib;
import inform.agent.scripts.server.SessionLib;
import inform.agent.scripts.sql.DatabaseTypesLibrary;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class ScriptableRequest
extends Request
implements ScriptableHost {
    private static final int MEMORY_CHECK_INTERVAL = 20000;
    protected ScriptableObject topLevelScope;
    private Constants constants = null;
    private long lastMemoryCheck = -20000L;
    private ServerSideExecutable objectSizerRef;

    public ScriptableRequest(RequestHeader rq) {
        super(rq, RequestDuration.COMPLEX);
    }

    @Override
    public SSContext getRootContext() {
        return this.ssContext;
    }

    @Override
    public Scriptable getTopLevelScope() {
        return this.topLevelScope;
    }

    @Override
    public void setTopLevelScope(Scriptable topLevelScope) {
    }

    public static ScriptableObject createTopLevelScope(Context cx, Task task, ServerSideHost ssHost, AbstractConnectionManager databaseManager) {
        TopLevelScope scope = new TopLevelScope(task, ssHost, databaseManager);
        cx.initStandardObjects(scope);
        return scope;
    }

    public static ScriptableObject createTopLevelScopeForDsl(Context cx, Task task, ServerSideHost ssHost) {
        TopLevelScopeForDsl scope = new TopLevelScopeForDsl(task, ssHost);
        cx.initStandardObjects(scope);
        return scope;
    }

    @Override
    public Constants getConstants() {
        return this.constants;
    }

    @Override
    public void setConstants(Constants constants) {
        this.constants = constants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void idle() {
        super.idle();
        if (Ini.JMemLimitDisable || this.objectSizerRef == null || !Core.gcOverheated) {
            return;
        }
        long tick = Core.clock();
        if (tick - this.lastMemoryCheck < 20000L) {
            return;
        }
        this.lastMemoryCheck = tick;
        boolean blowedDown = Core.ballonTryBlowDown();
        try {
            Top top = new Top(10);
            top.scan(this.objectSizerRef, false);
            top.push(this, false, this, "\u043f\u0440\u043e\u0447\u0435\u0435");
            long size = top.scan(this.objectSizerRef, true);
            long limit = this.objectSizerRef.getMemoryLimit();
            limit = Math.max(ServerSideExecutable.HEAP_MAX / 5L, Math.min(limit, ServerSideExecutable.HEAP_LIM));
            long tick2 = Core.clock();
            Core.logger.warn("memory usage for {} = {} (calculated in {}ms)", this.objectSizerRef, DebugLibrary.formatSize(size += top.push(this, true, this, "\u043f\u0440\u043e\u0447\u0435\u0435")), tick2 - tick);
            this.lastMemoryCheck = tick2;
            if (size > limit) {
                Object ho;
                int count = top.sizes.length;
                long sizeTreshold = 524288 / count;
                StringBuilder buff = new StringBuilder();
                buff.append("\u043e\u0431\u044a\u0435\u043a\u0442\u044b, \u0437\u0430\u043d\u0438\u043c\u0430\u044e\u0449\u0438\u0435 \u043d\u0430\u0438\u0431\u043e\u043b\u044c\u0448\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e \u043f\u0430\u043c\u044f\u0442\u0438:");
                for (int i = 0; i < count && top.sizes[i] >= sizeTreshold && (ho = top.hinto[i]) != null; ++i) {
                    Datasource ds;
                    buff.append('\n').append(DebugLibrary.formatSize(top.sizes[i])).append(" - ").append(ho).append(" {").append(top.hints[i]);
                    if (ho instanceof Datasource && (ds = (Datasource)ho).isLoaded()) {
                        buff.append(", ").append(ds.getRecordCount()).append(" row(s)");
                    }
                    buff.append('}');
                }
                buff.append("\n \u0412\u044b\u043f\u043e\u043b\u043d\u044f\u043c\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438:\n").append(Telemeter.getRunningTaskLog());
                InformException exception = new InformException("\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0430\u043c\u044f\u0442\u0438: " + DebugLibrary.formatSize(size) + " > " + DebugLibrary.formatSize(limit));
                if (buff.length() != 0) {
                    exception = exception.detail(buff.toString());
                }
                throw exception;
            }
        }
        finally {
            if (blowedDown) {
                Core.ballonBlowUp();
            }
        }
    }

    protected void setServerSideExecutable(ServerSideExecutable exec) {
        this.objectSizerRef = exec;
    }

    private static class Top
    extends ObjectSizer.Objects {
        final long[] sizes;
        final Object[] hinto;
        final String[] hints;

        Top(int limit) {
            this.sizes = new long[limit];
            this.hinto = new Object[limit];
            this.hints = new String[limit];
        }

        long scan(ServerSideExecutable exec, boolean calculate) {
            long result = 0L;
            result += this.push(exec.dbManager.getModifiedRows(), calculate, exec, "\u0438\u0437\u043c\u0435\u043d\u0451\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438");
            result += this.push(exec.dbManager, calculate, exec, "\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0434");
            for (ServerSideComponent c : exec.getComponents()) {
                Scriptable s;
                if (c instanceof Datasource) {
                    result += this.push(c, calculate, c, "\u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445");
                    continue;
                }
                if (!(c instanceof Script) || !((s = ((Script)c).scriptableOrNull()) instanceof ServerSideExecutable)) continue;
                result += this.scan((ServerSideExecutable)s, calculate);
            }
            for (Object k : exec.getAllIds()) {
                result += this.push(exec.get(k), calculate, exec, String.valueOf(k));
            }
            return result += this.push(exec, calculate, exec, "\u043f\u0440\u043e\u0447\u0435\u0435");
        }

        long push(Object object, boolean calculate, Object hintobj, String hintstr) {
            if (!calculate) {
                this.add(object);
                return 0L;
            }
            long objsize = ObjectSizer.calculateObjectSize(object, this, true);
            int length = this.sizes.length;
            int r0 = 0;
            int r1 = length;
            while (r0 < r1) {
                int m = (r0 + r1) / 2;
                long s = this.sizes[m];
                if (objsize < s) {
                    r0 = m + 1;
                    continue;
                }
                r1 = m;
            }
            if (r0 < length) {
                int p = r0;
                if (p < length - 1) {
                    System.arraycopy(this.sizes, p, this.sizes, p + 1, length - p - 1);
                    System.arraycopy(this.hinto, p, this.hinto, p + 1, length - p - 1);
                    System.arraycopy(this.hints, p, this.hints, p + 1, length - p - 1);
                }
                this.sizes[p] = objsize;
                this.hinto[p] = hintobj;
                this.hints[p] = hintstr;
            }
            return objsize;
        }
    }

    static class TopLevelScopeForDsl
    extends ScriptableObject {
        static final HashMap<String, PackageSupplierForDsl> pkgFactory = TopLevelScopeForDsl.createPkgFactory();
        final Task task;
        final ServerSideHost ssHost;
        boolean creatingPackage;

        TopLevelScopeForDsl(Task task, ServerSideHost ssHost) {
            this.task = task;
            this.ssHost = ssHost;
        }

        @Override
        public Object get(String name, Scriptable start) {
            PackageSupplierForDsl supplier;
            Object result = super.get(name, start);
            if (result == Scriptable.NOT_FOUND && !this.creatingPackage && (supplier = pkgFactory.get(name)) != null) {
                this.creatingPackage = true;
                try {
                    result = supplier.create(this);
                    if (result != null) {
                        this.putConst(name, start, result);
                    } else {
                        result = super.get(name, start);
                    }
                }
                catch (Exception ex) {
                    throw InformException.wrap(ex, "Create package " + name);
                }
                finally {
                    this.creatingPackage = false;
                }
            }
            return result;
        }

        static HashMap<String, PackageSupplierForDsl> createPkgFactory() {
            boolean index = false;
            HashMap<String, PackageSupplierForDsl> r = new HashMap<String, PackageSupplierForDsl>(128);
            r.put("requestState", scope -> new RequestStateDialog(scope.ssHost));
            r.put("Dates", scope -> new DateLibrary(scope));
            r.put("Log", scope -> new LogLibrary((Scriptable)scope, scope.ssHost));
            r.put("Strings", scope -> new StringsLibrary(scope));
            r.put("SysLog", scope -> new SysLogLibrary((Scriptable)scope, scope.ssHost));
            r.put("TaggedIO", scope -> new TaggedIOLibrary(scope));
            r.put("Metadata", scope -> new MetadataLibrary(scope, scope.ssHost, null));
            r.put("DataTypes", scope -> new DataTypesLibrary((Scriptable)scope, scope.ssHost));
            r.put("Permissions", scope -> new Permissions(scope));
            r.put("Notifications", scope -> new NotifyLib(scope));
            r.put("Server", scope -> new ServerLib(scope.task, (Scriptable)scope));
            r.put("Session", scope -> new SessionLib((Scriptable)scope, scope.ssHost));
            r.put("Text", scope -> new TextLibrary(scope));
            r.put("FileSystem", scope -> new FileSystemLibrary(scope));
            r.put("Debug", scope -> new DebugLibrary(scope, scope.ssHost, scope.task));
            r.put("Formats", scope -> new FormatLibrary((Scriptable)scope, scope.ssHost));
            r.put("Colors", scope -> new ColorsLibrary((Scriptable)scope, scope.ssHost));
            r.put("Fonts", scope -> new FontsLibrary((Scriptable)scope, scope.ssHost));
            r.put("Borders", scope -> new BordersLibrary((Scriptable)scope, scope.ssHost));
            r.put("Aligns", scope -> new AlignsLibrary((Scriptable)scope, scope.ssHost));
            r.put("Xml", scope -> new XmlLibrary(scope.task));
            r.put("DatabaseTypes", scope -> new DatabaseTypesLibrary((Scriptable)scope, null));
            r.put("Excel", scope -> new ExcelLibrary(scope));
            r.put("TextDocuments", scope -> new TextDocumentsLibrary(scope));
            r.put("Pdf", scope -> new PdfLibrary(scope));
            r.put("Decimal", scope -> {
                ScriptableObject.defineClass(scope, Decimal.class);
                return null;
            });
            r.put("System", scope -> new SystemLibrary(scope, scope.ssHost, scope.task));
            return r;
        }

        @Override
        public String getClassName() {
            return "TopLevelScopeForDsl";
        }
    }

    @FunctionalInterface
    static interface PackageSupplierForDsl {
        public Scriptable create(TopLevelScopeForDsl var1) throws Exception;
    }

    static class TopLevelScope
    extends ScriptableObject {
        static final HashMap<String, PackageSupplier> pkgFactory = TopLevelScope.createPkgFactory();
        final Task task;
        final ServerSideHost ssHost;
        final AbstractConnectionManager databaseManager;
        boolean creatingPackage;

        TopLevelScope(Task task, ServerSideHost ssHost, AbstractConnectionManager databaseManager) {
            this.task = task;
            this.ssHost = ssHost;
            this.databaseManager = databaseManager;
        }

        @Override
        public Object get(String name, Scriptable start) {
            PackageSupplier supplier;
            Object result = super.get(name, start);
            if (result == Scriptable.NOT_FOUND && !this.creatingPackage && (supplier = pkgFactory.get(name)) != null) {
                this.creatingPackage = true;
                try {
                    result = supplier.create(this);
                    if (result != null) {
                        this.putConst(name, start, result);
                    } else {
                        result = super.get(name, start);
                    }
                }
                catch (Exception ex) {
                    throw InformException.wrap(ex, "Create package " + name);
                }
                finally {
                    this.creatingPackage = false;
                }
            }
            return result;
        }

        static HashMap<String, PackageSupplier> createPkgFactory() {
            boolean index = false;
            HashMap<String, PackageSupplier> r = new HashMap<String, PackageSupplier>(128);
            r.put("requestState", scope -> new RequestStateDialog(scope.ssHost));
            r.put("Dates", scope -> new DateLibrary(scope));
            r.put("Log", scope -> new LogLibrary((Scriptable)scope, scope.ssHost));
            r.put("Strings", scope -> new StringsLibrary(scope));
            r.put("SysLog", scope -> new SysLogLibrary((Scriptable)scope, scope.ssHost));
            r.put("TaggedIO", scope -> new TaggedIOLibrary(scope));
            r.put("Metadata", scope -> new MetadataLibrary(scope, scope.ssHost, scope.databaseManager));
            r.put("DataTypes", scope -> new DataTypesLibrary((Scriptable)scope, scope.ssHost));
            r.put("Permissions", scope -> new Permissions(scope));
            r.put("Mail", scope -> new MailLibrary((Scriptable)scope, scope.ssHost));
            r.put("Notifications", scope -> new NotifyLib(scope));
            r.put("Server", scope -> new ServerLib(scope.task, (Scriptable)scope));
            r.put("Session", scope -> new SessionLib((Scriptable)scope, scope.ssHost));
            r.put("Net", scope -> new NetLibrary((Scriptable)scope, scope.task));
            r.put("Text", scope -> new TextLibrary(scope));
            r.put("FileSystem", scope -> new FileSystemLibrary(scope));
            r.put("Debug", scope -> new DebugLibrary(scope, scope.ssHost, scope.task));
            r.put("Replications", scope -> new ScriptReplicationsPack((Scriptable)scope, scope.ssHost));
            r.put("Formats", scope -> new FormatLibrary((Scriptable)scope, scope.ssHost));
            r.put("Colors", scope -> new ColorsLibrary((Scriptable)scope, scope.ssHost));
            r.put("Fonts", scope -> new FontsLibrary((Scriptable)scope, scope.ssHost));
            r.put("Borders", scope -> new BordersLibrary((Scriptable)scope, scope.ssHost));
            r.put("Aligns", scope -> new AlignsLibrary((Scriptable)scope, scope.ssHost));
            r.put("ExtFiles", scope -> new ExtFilesLibrary(scope));
            r.put("SDO", scope -> new SdoLibrary(scope));
            r.put("Geo", scope -> new GeoLibrary(scope));
            r.put("Graphics", scope -> new WebCanvasLibrary(scope));
            r.put("Documents", scope -> new DocumentsLibrary(scope));
            r.put("PageFormat", scope -> new PageFormatLibrary(scope));
            r.put("Schemes", scope -> new SchemesLibrary((Scriptable)scope, scope.ssHost));
            r.put("Xml", scope -> new XmlLibrary(scope.task));
            r.put("Soap", scope -> new SoapLibrary(scope.task));
            r.put("TestInternals", scope -> new TestInternalsLibrary(scope.ssHost));
            r.put("DatabaseTypes", scope -> new DatabaseTypesLibrary((Scriptable)scope, null));
            r.put("Excel", scope -> new ExcelLibrary(scope));
            r.put("TextDocuments", scope -> new TextDocumentsLibrary(scope));
            r.put("Crypto", scope -> new CryptoLibrary(scope));
            r.put("Pdf", scope -> new PdfLibrary(scope));
            r.put("Decimal", scope -> {
                ScriptableObject.defineClass(scope, Decimal.class);
                return null;
            });
            r.put("System", scope -> new SystemLibrary(scope, scope.ssHost, scope.task));
            r.put("Spreadsheets", scope -> new SpreadsheetsLibrary(scope));
            return r;
        }

        @Override
        public String getClassName() {
            return "TopLevelScope";
        }
    }

    @FunctionalInterface
    static interface PackageSupplier {
        public Scriptable create(TopLevelScope var1) throws Exception;
    }
}

