/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.scripts.FileSystemLibrary;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.mozilla.javascript.Scriptable;

public class ScriptableTextFileReader
extends SmartScriptableObject
implements FileSystemLibrary.TextReader {
    protected LineNumberReader reader;
    protected boolean eof = false;

    public ScriptableTextFileReader(Scriptable scope, Reader reader) {
        this.setParentScope(scope);
        this.reader = new LineNumberReader(reader);
    }

    @Override
    public String getClassName() {
        return "TextFileReader";
    }

    @SmartScriptableObject.PropertyTag
    public boolean getEof() {
        return this.eof;
    }

    @SmartScriptableObject.FunctionTag
    public Object readLine() throws IOException {
        String result = this.reader.readLine();
        this.eof = result == null;
        return result;
    }

    @SmartScriptableObject.FunctionTag
    public Object readToEnd() throws IOException {
        int cnt;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[1024];
        while ((cnt = this.reader.read(buffer, 0, buffer.length)) > 0) {
            result.append(buffer, 0, cnt);
        }
        this.eof = true;
        return result.toString();
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        return this.reader.read(buffer, offset, length);
    }
}

