/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.Cache;
import inform.adt.InformException;
import inform.adt.TimeZoneHost;
import inform.adt.collections.DoubleHash;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DirectoryRowset;
import inform.agent.db.utils.DirectoryRowsetCacheKey;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.scripts.CallableStatement;
import inform.agent.scripts.Closeables;
import inform.agent.scripts.CompiledScriptsCache;
import inform.agent.scripts.ComponentList;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.Constants;
import inform.agent.scripts.Database;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.GenericServerSideExecutable;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Script;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.Task;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.stat.DirectoryProfile;
import inform.agent.scripts.stat.Profile;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ServerSideExecutable
extends GenericServerSideExecutable {
    private static final int TAG_DATAMODEL = 152;
    private static final int TAG_SS_SCRIPT = 1;
    private static final int TAG_SS_MEM_LIMIT = 13;
    private final ComponentList components = new ComponentList();
    private Constants constants;
    private byte[] constantsContent = null;
    protected ParametersList parameters = new ParametersList();
    private String scriptSource;
    private org.mozilla.javascript.Script compiledScript;
    private boolean loadedFromNode;
    protected AbstractConnectionManager dbManager;
    private DoubleHash<Database> databases = new DoubleHash();
    private Cache<DirectoryRowsetCacheKey, DirectoryRowset> directoryRowsetCache = new Cache();
    private Profile datasourceProfile = null;
    private long memoryLimit;
    private final AtomicInteger idGenerator = new AtomicInteger();
    private Closeables closeables = null;

    public ServerSideExecutable(SSContext parentContext, int componentType, double nodeID, ServerSideHost ssHost, AbstractConnectionManager dbManager, Task parent) {
        super(parentContext, componentType, nodeID, ssHost, parent);
        this.dbManager = dbManager;
        this.dbManager.rootConnectionMode(true);
        this.constants = new Constants(ssHost.getUserID());
        this.parameters.setParentScope(this);
        ServerSideExecutable.putConstProperty(this, "parameters", this.parameters);
        ServerSideExecutable.putConstProperty(this, "module", this);
        ServerSideExecutable.putConstProperty(this, "METADATA_DB", 2.0);
    }

    @Override
    public String getClassName() {
        return "ServerSideExecutable";
    }

    public void setIsolated() {
    }

    protected void loadTag(int tag, TaggedReader reader) throws IOException {
    }

    public final void load() throws IOException {
        this.load(new TaggedReader(MtdEngine.getNodeContent(this.nodeID)));
        this.loadedFromNode = true;
    }

    public void load(TaggedReader reader) throws IOException {
        int tag;
        this.compiledScript = null;
        this.loadedFromNode = false;
        block6: do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    this.scriptSource = reader.getAnsi();
                    break;
                }
                case 2: {
                    ServerSideComponent c = ComponentsFactory.readAndCreateComponent(this.ssContext, this, this, reader);
                    if (c == null) continue block6;
                    c.setParentScope(this);
                    this.components.add(c);
                    ServerSideExecutable.putConstProperty(this, c.getName(), c);
                    break;
                }
                case 152: {
                    this.loadDatamodel(new TaggedReader(reader.getSubStream()));
                    break;
                }
                case 13: {
                    this.memoryLimit = reader.getUnsignedInt() * 1024L * 1024L;
                    break;
                }
                default: {
                    this.loadTag(tag, reader);
                }
            }
        } while (tag != 0);
        this.components.afterLoad();
    }

    private void loadDatamodel(TaggedReader reader) throws IOException, TaggedReaderException {
        int tag;
        do {
            tag = reader.getNextTag();
            switch (tag) {
                case 153: {
                    this.parameters.load(this.constants, new TaggedReader(reader.getSubStream()), Core.serverTimeZoneHost);
                }
            }
        } while (tag != 0);
    }

    @Override
    public DirectoryRowset getDirectoryRowset(DirectoryRowsetCacheKey cacheKey) {
        DirectoryRowset result = this.directoryRowsetCache.get(cacheKey);
        if (result == null) {
            result = new DirectoryRowset(cacheKey);
            this.directoryRowsetCache.put(cacheKey, result);
        }
        return result;
    }

    @Override
    public ParametersList getParameters() {
        return this.parameters;
    }

    @Override
    public Constants getConstants() {
        return this.constants;
    }

    @Override
    public byte[] getConstantsContent() {
        return this.constantsContent;
    }

    public void setConstantsContent(byte[] constantsContent) throws IOException, TaggedReaderException {
        this.constantsContent = constantsContent;
        this.constants.load(constantsContent, (TimeZoneHost)this.ssHost);
    }

    public Object executeScript(Context cx) throws IOException {
        if (this.compiledScript == null) {
            this.compiledScript = this.loadedFromNode ? CompiledScriptsCache.get((BasicNode)MtdEngine.getValidNode(this.nodeID)) : CompiledScriptsCache.compileScript(this.scriptSource, this.nodeID == 0.0 ? null : MtdEngine.getNode(this.nodeID));
        }
        return this.compiledScript.exec(cx, this);
    }

    @Override
    public ComponentList getComponents() {
        return this.components;
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.dbManager;
    }

    @Override
    public Database getDatabase(double dbId) {
        Database db = this.databases.get(dbId);
        if (db == null) {
            db = new Database(this, dbId);
            this.databases.add(db);
        }
        return db;
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public void commitTransaction() throws Exception {
        if (Ini.ReadonlyMode) {
            return;
        }
        this.ssHost.idle();
        this.dbManager.save(this.ssContext);
        this.dbManager.commit();
    }

    @Override
    public void rollbackTransaction() throws SQLException {
        this.ssHost.idle();
        this.dbManager.rollback();
    }

    @Override
    public void save() throws Exception {
        if (Ini.ReadonlyMode) {
            return;
        }
        this.ssHost.idle();
        this.dbManager.save(this.ssContext);
        this.ssHost.idle();
    }

    @Override
    public Object createDatasource(double tableId, double searchId) {
        if (Double.isNaN(tableId) || Double.isNaN(searchId)) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d ID \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0438\u043b\u0438 ID \u043f\u043e\u0438\u0441\u043a\u0430");
        }
        try {
            Datasource ds = new Datasource(this.ssContext, this, tableId, searchId);
            this.dynamical.add(ds);
            ds.setParentScope(this);
            return ds;
        }
        catch (IOException ex) {
            throw InformException.wrap(ex);
        }
    }

    @Override
    public Scriptable createSqlStatement(double connectionID) throws SQLException {
        SqlStatement s = new SqlStatement(this, connectionID);
        this.dynamical.add(s);
        return s;
    }

    @Override
    public Scriptable createCallableStatement(double connectionID) throws SQLException {
        CallableStatement s = new CallableStatement(this, connectionID);
        this.dynamical.add(s);
        return s;
    }

    @Override
    public void close() {
        for (ServerSideComponent c : this.components) {
            if (c instanceof Datasource) {
                ((Datasource)c).close();
                continue;
            }
            if (!(c instanceof Script)) continue;
            ((Script)c).close();
        }
        super.close();
    }

    @Override
    public void setDatasourceProfile() {
        if (this.parent == null) {
            this.datasourceProfile = new Profile(this.nodeId());
        }
    }

    @Override
    public boolean isDatasourceProfile() {
        if (this.parent != null) {
            return this.parent.isDatasourceProfile();
        }
        return this.datasourceProfile != null;
    }

    @Override
    public DatasourceProfile addDatasourceProfile(int uid, double nodeId, double filterId, double moduleId) {
        if (this.parent != null) {
            return this.parent.addDatasourceProfile(uid, nodeId, filterId, moduleId);
        }
        if (this.datasourceProfile == null) {
            return null;
        }
        return this.datasourceProfile.addDatasource(uid, nodeId, filterId, moduleId);
    }

    @Override
    public DirectoryProfile addDirectory(double nodeId, double moduleId) {
        if (this.parent != null) {
            return this.parent.addDirectory(nodeId, moduleId);
        }
        if (this.datasourceProfile == null) {
            return null;
        }
        return this.datasourceProfile.addDirectory(nodeId, moduleId);
    }

    @Override
    public String getProfile() {
        if (this.parent != null) {
            return this.parent.getProfile();
        }
        if (this.datasourceProfile == null) {
            return null;
        }
        return this.datasourceProfile.getProfile();
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }
}

