/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Datasource;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.ITableDataResult;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerSideRecord;
import inform.agent.scripts.ServerSideTable;
import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ServerSideTableRecord
extends ServerSideRecord {
    private static final String[] scriptFunctions = new String[]{"append", "markDelete", "send", "assignFields", "assignNotNullFields", "transferDatasource", "sort", "setSortColumns"};
    private static final String[] jsProperties = new String[]{"recordID", "fetchLimit"};
    int fetchLimit = -1;
    boolean chunkSend = false;
    boolean hasDeleting = false;

    public ServerSideTableRecord(ServerSideExecutable task, int nullSortKind) {
        super(task, nullSortKind);
        this.defineFunctionProperties(scriptFunctions, ServerSideTableRecord.class, 0);
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, this.getClass(), 1);
        }
    }

    @Override
    public void setTable(double tableId) throws IOException, InformException {
        super.setTable(tableId);
        ServerSideTableRecord.putConstProperty(this, "fields", this.fields.values().toArray());
    }

    @Override
    public String getClassName() {
        return "ServerSideTableRecord";
    }

    public double getRecordID() throws InformException {
        if (this.rowset == null) {
            return 0.0;
        }
        Row curRow = this.rowset.getCurrentRow();
        return curRow != null ? curRow.getId() : 0.0;
    }

    public Object getFetchLimit() {
        return this.fetchLimit == -1 ? Undefined.instance : Integer.valueOf(this.fetchLimit);
    }

    @Override
    protected void compact() {
        if (this.hasDeleting) {
            this.rowset.compact();
            this.hasDeleting = false;
        }
    }

    private void checkFlush(ITableDataResult result, boolean force, boolean alreadyFiltered) throws Exception {
        if (result == null) {
            return;
        }
        this.compact();
        if (this.chunkSend && (force || this.rowset.getRecordCount() >= 1000)) {
            result.sendTableData(this.rowset, false, alreadyFiltered);
        }
    }

    private void checkFlush(boolean force) throws Exception {
        if (this.chunkSend && (force || this.rowset.getRecordCount() >= 1000)) {
            this.checkFlush((ITableDataResult)((Object)this.task.getHost()), force, false);
        }
    }

    public static double append(Context context, Scriptable objectThis, Object[] args, Function objectFunction) throws Exception {
        ServerSideTableRecord self = (ServerSideTableRecord)objectThis;
        if (objectThis == null || !(objectThis instanceof ServerSideTableRecord)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439");
        }
        self.checkFlush(false);
        double rowId = args.length == 1 ? ValueCaster.toDouble(args[0]) : Core.generateId();
        self.rowset.appendRow(rowId);
        return rowId;
    }

    public void markDelete() {
        this.hasDeleting = true;
        this.getCurrentRow().markDelete();
    }

    public void assignFields(Object datasource) throws Exception {
        Datasource ds = this.checkDatasourceWithSameTable(datasource);
        for (DatasourceField f : this.fields.values()) {
            f.assignField(ds.findfieldById(f.desc.getId()));
        }
    }

    public void assignNotNullFields(Object datasource) throws Exception {
        Datasource ds = this.checkDatasourceWithSameTable(datasource);
        for (DatasourceField f : this.fields.values()) {
            DatasourceField srcField = ds.findfieldById(f.desc.getId());
            boolean isNull = srcField.getIsNull();
            if (isNull) continue;
            f.assignField(srcField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferDatasource(Object datasource) throws Exception {
        Datasource ds = this.checkDatasourceWithSameTable(datasource);
        if (ds.isLoaded()) {
            throw new InformException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        }
        ITableDataResult result = (ITableDataResult)((Object)this.task.getHost());
        if (result == null) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043e\u0441\u043b\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430");
        }
        this.compact();
        result.sendTableData(this.rowset, false, false);
        ds.execute();
        try {
            while (ds.next()) {
                Row row = ds.getCurrentRow();
                if (this.chunkSend) {
                    try {
                        this.tempCurrentRow = row;
                        if (!result.isCurrentRowFiltered()) {
                            continue;
                        }
                    }
                    finally {
                        this.tempCurrentRow = null;
                        continue;
                    }
                }
                this.rowset.add(row);
                row.internalTransferTo(this.rowset);
            }
            result.sendTableData(this.rowset, false, this.chunkSend);
        }
        finally {
            ds.close();
        }
    }

    private Datasource checkDatasourceWithSameTable(Object ds) {
        if (!(ds instanceof Datasource)) {
            throw new InformException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        Datasource datasource = (Datasource)ds;
        if (datasource.getTableDescriptor().getNodeId() != this.metadata.getNodeId()) {
            throw new InformException("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        return datasource;
    }

    public static void send(Context context, Scriptable objectThis, Object[] args, Function objectFunction) throws Exception {
        if (!(objectThis instanceof ServerSideTableRecord)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439");
        }
        ServerSideTableRecord self = (ServerSideTableRecord)objectThis;
        if (self.rowset == null) {
            throw new InformException("\u041d\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439");
        }
        ITableDataResult result = (ITableDataResult)((Object)self.task.getHost());
        if (result == null) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043e\u0441\u043b\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430");
        }
        self.compact();
        result.sendTableData(self.rowset, false, false);
    }

    public static void sort(Context context, Scriptable objectThis, Object[] args, Function objectFunction) throws Exception {
        ServerSideTableRecord self = (ServerSideTableRecord)objectThis;
        if (objectThis == null || !(objectThis instanceof ServerSideTableRecord)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439");
        }
        if (args.length % 2 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c [field, bool, field, bool, ...]");
        }
        ArrayList<SortingField> sorting = new ArrayList<SortingField>();
        if (args.length > 0) {
            for (DatasourceField f : self.fields.values()) {
                f.sorting = false;
            }
            for (int i = 0; i < args.length; i += 2) {
                DatasourceField f;
                f = (DatasourceField)args[i];
                if (f.getRowsetAccessor() != self) {
                    throw new InformException("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u0436\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
                }
                f.sorting = true;
                sorting.add(new SortingField(f.getDescriptor(), (Boolean)args[i + 1] != false ? SortDirection.ASCENDING : SortDirection.DESCENDING, self.metadata.getDatabaseDescriptor().getDatabaseType().caps(), self.getNullSortKind()));
            }
        }
        if (sorting.isEmpty()) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438");
        }
        self.rowset.sort(sorting);
    }

    public static void setSortColumns(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof ServerSideTableRecord)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439");
        }
        DatasourceField[] fields = new DatasourceField[args.length];
        DatasourceField field = null;
        int i = 0;
        for (Object arg : args) {
            if (arg instanceof DatasourceField) {
                field = (DatasourceField)arg;
                field.sortDirection = SortDirection.ASCENDING;
                fields[i] = field;
                ++i;
                continue;
            }
            if (field == null || !(arg instanceof Boolean)) continue;
            boolean isAscending = (Boolean)arg;
            if (!isAscending) {
                field.sortDirection = SortDirection.DESCENDING;
            }
            field = null;
        }
        ServerSideTableRecord table = (ServerSideTableRecord)thisObj;
        table.doSetSortColumns(fields);
    }

    private void doSetSortColumns(DatasourceField ... args) throws InformException {
        if (this.task == null) {
            return;
        }
        ServerSideTable ssTable = (ServerSideTable)this.task;
        ssTable.getSorting().clear();
        for (DatasourceField f : this.fields.values()) {
            f.sorting = false;
        }
        for (DatasourceField f : args) {
            if (f == null) continue;
            SortingField sf = null;
            if (f.getParentScope() instanceof DirectoryField) {
                int[] fieldPath = null;
                ArrayList<Integer> fieldPathList = new ArrayList<Integer>();
                DatasourceField ref = f;
                while (ref.getParentScope() instanceof DirectoryField) {
                    fieldPathList.add(ref.getDescriptor().getId());
                    ref = (DatasourceField)ref.getParentScope();
                }
                fieldPathList.add(ref.getDescriptor().getId());
                fieldPath = new int[fieldPathList.size()];
                int i = fieldPathList.size() - 1;
                for (Integer n : fieldPathList) {
                    fieldPath[i--] = n;
                }
                if (fieldPath != null && fieldPath.length > 0) {
                    FieldDescriptor fieldToSort = this.metadata.getFieldDescriptor(fieldPath[0]);
                    if (fieldToSort == null) continue;
                    sf = new SortingField(this.metadata, this.getNullSortKind(), fieldToSort, f.sortDirection, fieldPath);
                }
            } else {
                sf = new SortingField(f.getDescriptor(), f.sortDirection, this.metadata.getDatabaseDescriptor().getDatabaseType().caps(), this.getNullSortKind());
            }
            if (sf == null) continue;
            ssTable.getSorting().add(sf);
            f.sorting = true;
        }
    }
}

