/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.Core;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.NumericField;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TCRC32
extends ScriptableObject {
    private static final String[] availJSPropertiesNames = new String[]{"value"};
    private static final String[] availJSFunctionsNames = new String[]{"reset", "update"};
    CRC32 crc;

    public TCRC32(Scriptable scope) {
        this.setParentScope(scope);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, TCRC32.class, 0);
        }
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        this.crc = new CRC32();
    }

    @Override
    public String getClassName() {
        return "TCRC32";
    }

    public void reset() {
        this.crc.reset();
    }

    public static void update(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception, UnsupportedEncodingException {
        block15: {
            double nval;
            TCRC32 self = (TCRC32)thisObj;
            if (args.length != 1) {
                throw new Exception("\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 -- \u0447\u0438\u0441\u043b\u043e \u0438\u043b\u0438 \u043f\u043e\u043b\u0435");
            }
            boolean isField = args[0] == null || args[0] instanceof DatasourceField;
            DatasourceField fval = isField ? (DatasourceField)args[0] : null;
            double d = nval = isField ? 0.0 : ValueCaster.toDouble(args[0]);
            if (isField) {
                if (fval != null) {
                    try {
                        if (fval.getIsNull()) {
                            self.crc.update(0);
                            break block15;
                        }
                        switch (fval.getDataType()) {
                            case BOOLEAN: 
                            case FLOAT: 
                            case METATREE_NODE: 
                            case PRIMARY_KEY: 
                            case INTERVAL: 
                            case INTEGER: {
                                NumericField nfield = (NumericField)fval;
                                double nf = nfield.getAsNumber();
                                self.crc.update(String.format("%15.8f", nf).getBytes("UTF-8"));
                                break;
                            }
                            case FILE: {
                                break;
                            }
                            case BIG_NUMBER: 
                            case STRING: 
                            case UNICODE: 
                            case DATE_TIME: 
                            case DIRECTORY: 
                            case GEOMETRY: 
                            case BLOB: {
                                String sf = fval.getAsString();
                                if (sf != null) {
                                    self.crc.update(sf.getBytes("UTF-8"));
                                }
                                break;
                            }
                            default: {
                                String S = fval.getAsString();
                                if (S == null) break;
                                self.crc.update(S.getBytes("UTF-8"));
                            }
                        }
                    }
                    catch (Exception ignore) {
                        Core.logger.error(null, ignore);
                    }
                }
            } else {
                self.crc.update(String.format("%18.8f", nval).getBytes("UTF-8"));
            }
        }
    }

    public long getValue() {
        return this.crc.getValue();
    }
}

