/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoPublicKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.mozilla.javascript.Scriptable;

public class CryptoCertificate
extends SmartScriptableObject {
    private final Certificate certificate;
    private static final String szOID_COMMON_NAME = "2.5.4.3";
    private static final String szOID_SUR_NAME = "2.5.4.4";
    private static final String szOID_LOCALITY_NAME = "2.5.4.7";
    private static final String szOID_ORGANIZATION_NAME = "2.5.4.10";
    private static final String szOID_ORGANIZATIONAL_UNIT_NAME = "2.5.4.11";
    private static final String szOID_RSA_emailAddr = "1.2.840.113549.1.9.1";
    private static final String szOID_COUNTRY_NAME = "2.5.4.6";
    private static final String szOID_STATE_OR_PROVINCE_NAME = "2.5.4.8";
    private static final String szOID_STREET_ADDRESS = "2.5.4.9";
    private static final String szOID_TITLE = "2.5.4.12";
    private static final String szOID_GIVEN_NAME = "2.5.4.42";
    private static final String szOID_INITIALS = "2.5.4.43";
    private static final String szOID_DOMAIN_COMPONENT = "0.9.2342.19200300.100.1.25";
    private static final String szOID_OGRN = "1.2.643.100.1";
    private static final String szOID_OGRNIP = "1.2.643.100.5";
    private static final String szOID_SNILS = "1.2.643.100.3";
    private static final String szOID_INNLE = "1.2.643.100.4";
    private static final String szOID_INN = "1.2.643.3.131.1.1";

    public CryptoCertificate(Scriptable scope, Certificate certificate) {
        this.setParentScope(scope);
        this.certificate = certificate;
    }

    @Override
    public String getClassName() {
        return "Certificate";
    }

    @SmartScriptableObject.PropertyTag
    public String getInfo() {
        return this.certificate.toString();
    }

    @SmartScriptableObject.PropertyTag
    public String getType() {
        return this.certificate.getType();
    }

    @SmartScriptableObject.PropertyTag
    public int getVersion() {
        return ((X509Certificate)this.certificate).getVersion();
    }

    @SmartScriptableObject.PropertyTag
    public String getSerialNumber() {
        BigInteger sn = ((X509Certificate)this.certificate).getSerialNumber();
        String hex = CryptoUtils.bytesToHex(sn.toByteArray());
        return hex;
    }

    @SmartScriptableObject.PropertyTag
    public CertificateNames getIssuer() throws Exception {
        return new CertificateNames((Scriptable)this, new JcaX509CertificateHolder((X509Certificate)this.certificate).getIssuer());
    }

    @SmartScriptableObject.PropertyTag
    public CertificateNames getSubject() throws Exception {
        return new CertificateNames((Scriptable)this, new JcaX509CertificateHolder((X509Certificate)this.certificate).getSubject());
    }

    @SmartScriptableObject.PropertyTag
    public Date getValidAfter() {
        return ((X509Certificate)this.certificate).getNotBefore();
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getSha1() throws Exception {
        MessageDigest sha1 = MessageDigest.getInstance("SHA1");
        sha1.update(this.certificate.getEncoded());
        return new BinaryObject(sha1.digest());
    }

    @SmartScriptableObject.PropertyTag
    public Date getValidBefore() {
        return ((X509Certificate)this.certificate).getNotAfter();
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getAsBinary() throws CertificateEncodingException {
        byte[] encoded = this.certificate.getEncoded();
        if (encoded == null) {
            return null;
        }
        return new BinaryObject(encoded);
    }

    @SmartScriptableObject.PropertyTag
    public String getAsHexString() throws CertificateEncodingException {
        byte[] encoded = this.certificate.getEncoded();
        if (encoded == null) {
            return null;
        }
        return CryptoUtils.bytesToHex(encoded, ',');
    }

    @SmartScriptableObject.PropertyTag
    public String getAsBase64() throws CertificateEncodingException {
        byte[] encoded = this.certificate.getEncoded();
        if (encoded == null) {
            return null;
        }
        return Base64BinString.Encode(encoded);
    }

    @SmartScriptableObject.PropertyTag
    public CryptoPublicKey getPublicKey() {
        PublicKey publicKey = this.certificate.getPublicKey();
        return publicKey == null ? null : new CryptoPublicKey((Scriptable)this, publicKey);
    }

    Certificate certificate() {
        return this.certificate;
    }

    private static class CertificateNames
    extends SmartScriptableObject {
        private final X500Name name;

        CertificateNames(Scriptable scope, X500Name name) {
            this.setParentScope(scope);
            this.name = name;
            this.defineProperty("CN", (Object)this.getName(CryptoCertificate.szOID_COMMON_NAME), 1);
            this.defineProperty("SN", (Object)this.getName(CryptoCertificate.szOID_SUR_NAME), 1);
            this.defineProperty("L", (Object)this.getName(CryptoCertificate.szOID_LOCALITY_NAME), 1);
            this.defineProperty("O", (Object)this.getName(CryptoCertificate.szOID_ORGANIZATION_NAME), 1);
            this.defineProperty("OU", (Object)this.getName(CryptoCertificate.szOID_ORGANIZATIONAL_UNIT_NAME), 1);
            this.defineProperty("E", (Object)this.getName(CryptoCertificate.szOID_RSA_emailAddr), 1);
            this.defineProperty("C", (Object)this.getName(CryptoCertificate.szOID_COUNTRY_NAME), 1);
            this.defineProperty("S", (Object)this.getName(CryptoCertificate.szOID_STATE_OR_PROVINCE_NAME), 1);
            this.defineProperty("STREET", (Object)this.getName(CryptoCertificate.szOID_STREET_ADDRESS), 1);
            this.defineProperty("T", (Object)this.getName(CryptoCertificate.szOID_TITLE), 1);
            this.defineProperty("G", (Object)this.getName(CryptoCertificate.szOID_GIVEN_NAME), 1);
            this.defineProperty("I", (Object)this.getName(CryptoCertificate.szOID_INITIALS), 1);
            this.defineProperty("DC", (Object)this.getName(CryptoCertificate.szOID_DOMAIN_COMPONENT), 1);
            this.defineProperty("OGRN", (Object)this.getName(CryptoCertificate.szOID_OGRN), 1);
            this.defineProperty("OGRNIP", (Object)this.getName(CryptoCertificate.szOID_OGRNIP), 1);
            this.defineProperty("SNILS", (Object)this.getName(CryptoCertificate.szOID_SNILS), 1);
            this.defineProperty("INNLE", (Object)this.getName(CryptoCertificate.szOID_INNLE), 1);
            this.defineProperty("INN", (Object)this.getName(CryptoCertificate.szOID_INN), 1);
        }

        @Override
        public String getClassName() {
            return this.name.toString();
        }

        private String getName(String oid) {
            if (oid == null || oid.isEmpty()) {
                return "";
            }
            RDN[] rdns = this.name.getRDNs(new ASN1ObjectIdentifier(oid));
            if (rdns == null || rdns.length == 0) {
                return "";
            }
            AttributeTypeAndValue first = rdns[0].getFirst();
            if (first == null) {
                return "";
            }
            return IETFUtils.valueToString((ASN1Encodable)first.getValue());
        }
    }
}

