/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.SmartScriptableObject;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.CryptoPro.JCP.params.CryptParamsSpec;
import ru.CryptoPro.JCPxml.xmldsig.JCPXMLDSigInit;

public class CryptoXmlCipher
extends SmartScriptableObject {
    private final CryptoCertificate certificate;
    protected final CryptoPrivateKey privateKey;
    private final String algorithmName;
    private CryptParamsSpec spec = null;
    private SecretKey sessionKey = null;

    public CryptoXmlCipher(Scriptable scope, CryptoPrivateKey privateKey, CryptoCertificate certificate, String exchKeyAlgName, String algorithmName) {
        this.setParentScope(scope);
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.algorithmName = algorithmName;
        if (exchKeyAlgName.equals("GOST3410_2012_256") || exchKeyAlgName.equals("GOST3410DH_2012_256") || exchKeyAlgName.equals("GOST3410EPH_2012_256") || exchKeyAlgName.equals("GOST3410DHEPH_2012_256") || exchKeyAlgName.equals("GOST3410_2012_512") || exchKeyAlgName.equals("GOST3410DH_2012_512") || exchKeyAlgName.equals("GOST3410EPH_2012_512") || exchKeyAlgName.equals("GOST3410DHEPH_2012_512")) {
            this.spec = CryptParamsSpec.getInstance((int)14);
        }
    }

    @Override
    public String getClassName() {
        return "XmlCipher";
    }

    protected Document doEncrypt(String transportName, String cipherName, Object data, Object codepage, boolean content) throws Exception {
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        return this.doEncrypt(transportName, cipherName, doc, content);
    }

    protected Document doEncrypt(String transportName, String cipherName, Document doc, boolean content) throws Exception {
        if (this.certificate == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430");
        }
        Certificate cert = this.certificate.certificate();
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0443 X.509");
        }
        if (this.sessionKey == null) {
            KeyGenerator kg = KeyGenerator.getInstance(this.algorithmName);
            if (this.spec != null) {
                kg.init((AlgorithmParameterSpec)this.spec);
            }
            this.sessionKey = kg.generateKey();
        }
        EncryptedKey encryptedKey = CryptoXmlCipher.wrapKey(doc, this.sessionKey, (X509Certificate)cert, transportName);
        return CryptoXmlCipher.encryptDocument(doc, content, this.sessionKey, encryptedKey, cipherName);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject encrypt(String transportName, String cipherName, boolean contentOnly, Object data, Object codepage) throws Exception {
        Document encryptedDoc = this.doEncrypt(transportName, cipherName, data, codepage, contentOnly);
        return new BinaryObject(CryptoUtils.documentAsBytes(encryptedDoc));
    }

    public static EncryptedKey wrapKey(Document doc, SecretKey sessionKey, X509Certificate cert, String transportName) throws Exception {
        XMLCipher keyCipher = XMLCipher.getInstance((String)transportName);
        keyCipher.init(3, (Key)cert.getPublicKey());
        KeyInfo certKeyInfo = new KeyInfo(doc);
        X509Data x509data = new X509Data(doc);
        x509data.addCertificate(cert);
        certKeyInfo.add(x509data);
        EncryptedKey encryptedKey = keyCipher.encryptKey(doc, (Key)sessionKey);
        encryptedKey.setKeyInfo(certKeyInfo);
        return encryptedKey;
    }

    public static Document encryptDocument(Document doc, boolean content, SecretKey sessionKey, EncryptedKey encryptedKey, String algName) throws Exception {
        Element element = doc.getDocumentElement();
        XMLCipher xmlCipher = XMLCipher.getInstance((String)algName);
        xmlCipher.init(1, (Key)sessionKey);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfo);
        xmlCipher.doFinal(doc, element, content);
        return doc;
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject decrypt(Object data) throws Exception {
        if (this.privateKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430");
        }
        byte[] value = CryptoUtils.dataAsBytes(data, null);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        Document decriptedDoc = this.doDecrypt(doc);
        return new BinaryObject(CryptoUtils.documentAsBytes(decriptedDoc));
    }

    protected Document doDecrypt(Document doc) throws Exception {
        PrivateKey key = this.privateKey.privateKey();
        XMLCipher xmlCipher = XMLCipher.getInstance();
        xmlCipher.init(2, null);
        Element encryptedDataElement = (Element)doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData").item(0);
        if (key != null) {
            xmlCipher.setKEK((Key)key);
        }
        xmlCipher.doFinal(doc, encryptedDataElement);
        return doc;
    }

    static {
        if (!JCPXMLDSigInit.isInitialized()) {
            JCPXMLDSigInit.init();
        }
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

