/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoPublicKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.crypto.XmlVerifyResults;
import inform.agent.scripts.crypto.XmlVerifyValue;
import inform.common.SmartScriptableObject;
import java.security.Key;
import java.security.KeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPath2FilterContainer;
import org.apache.xpath.XPathAPI;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.CryptoPro.JCPxml.xmldsig.JCPXMLDSigInit;

public class CryptoXmlSignature
extends SmartScriptableObject {
    private static final String providerName = "ru.CryptoPro.JCPxml.dsig.internal.dom.XMLDSigRI";
    private static final String provider = "JCP";
    protected String signMethod = null;
    protected String digestMethod = null;
    protected CryptoPrivateKey privateKey = null;
    protected CryptoCertificate certificate = null;
    protected String documentId = null;
    protected String documentIdName = null;
    protected String signatureId = null;
    protected String signatureIdName = null;
    protected String actorValue = null;
    protected String actorName = null;

    public CryptoXmlSignature(Scriptable scope) {
        this.setParentScope(scope);
    }

    @Override
    public String getClassName() {
        return "XmlSignature";
    }

    @SmartScriptableObject.FunctionTag
    public void initSign(Object signMethod, Object digestMethod) {
        this.signMethod = (String)(signMethod instanceof String ? signMethod : null);
        this.digestMethod = (String)(digestMethod instanceof String ? digestMethod : null);
    }

    @SmartScriptableObject.FunctionTag
    public void initSigner(CryptoPrivateKey privateKey, CryptoCertificate certificate, Object docIdName, Object docId, Object signIdName, Object signId, Object actorName, Object actorValue) {
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.documentIdName = docIdName instanceof String ? (String)docIdName : null;
        this.documentId = docId instanceof String ? (String)docId : "";
        this.signatureIdName = signIdName instanceof String ? (String)signIdName : null;
        this.signatureId = signId instanceof String ? (String)signId : "";
        this.actorName = actorName instanceof String ? (String)actorName : null;
        String string = this.actorValue = actorValue instanceof String ? (String)actorValue : "";
        if (this.documentIdName == null || this.documentIdName.isEmpty()) {
            this.documentIdName = "id";
        }
        if (this.signatureIdName == null || this.signatureIdName.isEmpty()) {
            this.signatureIdName = "id";
        }
        if (this.actorName == null || this.actorName.isEmpty()) {
            this.actorName = "actor";
        }
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject sign(Object data, Object codepage) throws Exception {
        if (this.signMethod == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
        }
        if (this.digestMethod == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c\u0430 \u043f\u043e\u0434\u0441\u0447\u0435\u0442\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0441\u0443\u043c\u043c\u044b");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430");
        }
        if (this.certificate == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430");
        }
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        final XMLSignatureFactory sigFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        Transforms transformsDoc = new Transforms(doc);
        transformsDoc.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transformsDoc.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        String[][] filters = new String[][]{{"subtract", "//ds:Signature"}};
        transformsDoc.addTransform("http://www.w3.org/2002/06/xmldsig-filter2", XPath2FilterContainer.newInstances((Document)doc, (String[][])filters));
        ArrayList<Transform> transforms = new ArrayList<Transform>(){
            {
                this.add(sigFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
                this.add(sigFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", (XMLStructure)null));
            }
        };
        Object referenceURI = "";
        Node nodeToSign = null;
        Node sigParent = null;
        if (!this.documentId.isEmpty()) {
            Node selNode = XPathAPI.selectSingleNode((Node)doc.getDocumentElement(), (String)String.format("//*[@%s='%s']", this.documentIdName, this.documentId));
            Node node = nodeToSign = selNode == null ? null : ((Element)selNode).getFirstChild();
            if (nodeToSign == null) {
                throw new Exception("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0441 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u043c " + this.documentIdName + ": " + this.documentId);
            }
            sigParent = nodeToSign.getParentNode();
            referenceURI = "#" + this.documentId;
        } else {
            sigParent = doc.getDocumentElement();
        }
        Reference ref = sigFactory.newReference((String)referenceURI, sigFactory.newDigestMethod(this.digestMethod, null), (List<? extends Transform>)transforms, null, null);
        SignedInfo signedInfo = sigFactory.newSignedInfo(sigFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), sigFactory.newSignatureMethod(this.signMethod, null), Collections.singletonList(ref));
        DOMSignContext dsc = new DOMSignContext(this.privateKey.privateKey(), sigParent);
        dsc.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        dsc.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", provider);
        KeyInfoFactory keyInfoFactory = sigFactory.getKeyInfoFactory();
        X509Data x509d = keyInfoFactory.newX509Data(Collections.singletonList(this.certificate.certificate()));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509d));
        XMLSignature signature = sigFactory.newXMLSignature(signedInfo, keyInfo);
        signature.sign(dsc);
        if (!this.signatureId.isEmpty()) {
            Element sigE = (Element)XPathAPI.selectSingleNode((Node)dsc.getParent(), (String)"//*[local-name()='Signature']");
            sigE.setAttribute(this.signatureIdName, this.signatureId);
        }
        return new BinaryObject(CryptoUtils.documentAsBytes(doc));
    }

    @SmartScriptableObject.FunctionTag
    public XmlVerifyResults verify(Object data, Object codepage) throws Exception {
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        }
        Document doc = CryptoUtils.loadDocument(value);
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        XmlVerifyResults results = new XmlVerifyResults(this);
        block0: for (int i = 0; i < nl.getLength(); ++i) {
            Element sigElement = (Element)nl.item(i);
            boolean hasCertificate = sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").getLength() > 0;
            DOMValidateContext valContext = new DOMValidateContext(hasCertificate ? new X509CertificateSelector() : new KeyValueKeySelector(), (Node)sigElement);
            valContext.setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", provider);
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean validity = signature.validate(valContext);
            KeyInfo keyInfo = signature.getKeyInfo();
            List<XMLStructure> list = keyInfo.getContent();
            if (hasCertificate) {
                for (XMLStructure s : list) {
                    if (!(s instanceof X509Data)) continue;
                    X509Certificate cert = (X509Certificate)((X509Data)s).getContent().get(0);
                    results.list.add(new XmlVerifyValue((Scriptable)results, new CryptoCertificate((Scriptable)results, cert), validity));
                    continue block0;
                }
                continue;
            }
            for (XMLStructure s : list) {
                if (!(s instanceof KeyValue)) continue;
                PublicKey pk = ((KeyValue)s).getPublicKey();
                results.list.add(new XmlVerifyValue((Scriptable)results, new CryptoPublicKey((Scriptable)results, pk), validity));
                continue block0;
            }
        }
        return results;
    }

    static boolean algorithmEquals(String algURI, String algName) {
        return true;
    }

    static {
        if (!JCPXMLDSigInit.isInitialized()) {
            JCPXMLDSigInit.init();
        }
        if (!Init.isInitialized()) {
            Init.init();
        }
    }

    public static class X509CertificateSelector
    extends KeySelector {
        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (!(xmlStructure instanceof X509Data)) continue;
                X509Data data = (X509Data)xmlStructure;
                X509Certificate cert = (X509Certificate)data.getContent().get(0);
                PublicKey pk = cert.getPublicKey();
                if (!CryptoXmlSignature.algorithmEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private final PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (!(xmlStructure instanceof KeyValue)) continue;
                PublicKey pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
                if (!CryptoXmlSignature.algorithmEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }
    }
}

