/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.Calendar;

public class IntervalFormat
extends Format {
    public static final int TAG_DF_THOUSAND_SEPARATOR = 51;
    private boolean FThousandSeparator = false;

    @SmartScriptableObject.PropertyTag
    public boolean getThousandSeparator() {
        return this.FThousandSeparator;
    }

    public void setThousandSeparator(boolean value) {
        this.FThousandSeparator = value;
    }

    protected IntervalFormat(int id) {
        super(id);
    }

    protected IntervalFormat(int id, byte[] options) throws IOException {
        this(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    protected void decodeOptions(TaggedReader reader) throws IOException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 51: {
                    this.FThousandSeparator = true;
                }
            }
        }
    }

    @Override
    public final String format(Object value) throws InformException {
        if (null == value) {
            return "";
        }
        return this.formatValue(ValueCaster.toDouble(value));
    }

    private String toStringWithFormat(double value) {
        Calendar cal = DateTime.toCalendar(value);
        int H = cal.get(10);
        int Minutes = cal.get(12);
        int Seconds = cal.get(13);
        int stampDate = (int)value;
        double Hours = (double)stampDate * 24.0 + (double)H;
        switch (this.id) {
            case 501: {
                return String.format("%15.0f:%02d:%02d", Hours, Minutes, Seconds);
            }
            case 502: {
                return String.format("%15.0f:%02d", Hours * 60.0 + (double)Minutes, Seconds);
            }
            case 503: {
                return String.format("%15.0f", Hours * 3600.0 + (double)(Minutes * 60) + (double)Seconds);
            }
            case 504: {
                return String.format("%15.0f:%02d", Hours, Minutes);
            }
            case 505: {
                return String.format("%15.0f", Hours * 60.0 + (double)Minutes);
            }
            case 506: {
                return String.format("%15.0f", Hours);
            }
            case 507: {
                int Days = stampDate % 365;
                int Years = (stampDate - Days) % 365;
                return String.format("%4d:%03d:%02d:%02d:%02d", Years, Days, H, Minutes, Seconds);
            }
            case 508: {
                return String.format("%3d:%02d:%02d:%02d", stampDate, H, Minutes, Seconds);
            }
            case 509: {
                return String.format("%3d:%02d:%02d", stampDate, H, Minutes);
            }
            case 510: {
                return String.format("%3d:%02d", stampDate, H);
            }
        }
        return "";
    }

    protected String formatValue(double value) throws InformException {
        String result = this.toStringWithFormat(value).trim();
        if (!this.FThousandSeparator) {
            return result;
        }
        switch (this.id) {
            case 503: 
            case 505: 
            case 506: {
                return this.setThousandSeparators(result, " ");
            }
        }
        int P2 = result.indexOf(58);
        return this.setThousandSeparators(result.substring(0, P2), " ") + result.substring(P2);
    }

    @Override
    public DataType getDataType() {
        return DataType.INTERVAL;
    }

    @Override
    public FormatAligment getAlignment() {
        return FormatAligment.RIGHT;
    }
}

