/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.Parameter;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.mozilla.javascript.Scriptable;

public class ExtFilesLibrary
extends SmartScriptableObject {
    public static final int TAG_BLOB_FIELD_EXTERNAL_FILE = 2;
    public static final int TAG_BLOB_FIELD_EXTERNAL_FILE_ZIP = 3;

    public ExtFilesLibrary(Scriptable scope) {
        this.setParentScope(scope);
    }

    @SmartScriptableObject.FunctionTag
    public Container load(BinaryObject obj) throws IOException, TaggedReaderException {
        TaggedReader reader = new TaggedReader(BinaryObject.toInputStream(obj), obj.getSize());
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 150: {
                    return new Container(reader);
                }
                case 2: {
                    return new Container(reader.getStreamReader());
                }
                case 3: {
                    return new Container(new TaggedReader(new InflaterInputStream(reader.getStream(), new Inflater(true))));
                }
            }
        }
        throw new InformException("no files");
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject extractExecutableFileContent(BinaryObject obj) throws IOException, TaggedReaderException {
        TaggedReader reader = new TaggedReader(BinaryObject.toInputStream(obj), obj.getSize());
        Container c = null;
        if (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 150: {
                    c = new Container(reader);
                    break;
                }
                case 2: {
                    c = new Container(reader.getStreamReader());
                    break;
                }
                case 3: {
                    c = new Container(new TaggedReader(new InflaterInputStream(reader.getStream(), new Inflater(true))));
                }
            }
        }
        if (c != null) {
            Entry e = c.getExecutable();
            if (!(e instanceof File)) {
                throw new InformException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u043d\u0430\u0439\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u043d\u044f\u0435\u043c\u044b\u0439 \u0444\u0430\u0439\u043b");
            }
            obj = ((File)e).getContent();
        }
        return obj;
    }

    @SmartScriptableObject.FunctionTag
    public Container create() throws IOException, TaggedReaderException {
        return new Container();
    }

    @Override
    public String getClassName() {
        return "ExtFiles";
    }

    public static class Container
    extends Folder {
        private static final int TAG_EXEC_FILE = 1;
        private static final int TAG_FILE_ACTION = 2;
        private static final int TAG_OWNER_EXFILE = 5;
        private static final int TAG_EXTERNAL_FILES = 7;
        private static final int TAG_ROOT_TEXT = 1;
        private static final int TAG_ROOT_ID = 3;
        private static final int TAG_ROOT_DATA_STREAM = 4;
        private String executable;
        private String action = "open";

        public Container() {
            super(null);
        }

        public Container(TaggedReader reader) throws IOException, TaggedReaderException {
            super(null);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        this.executable = reader.getAnsi();
                        break;
                    }
                    case 2: {
                        this.action = reader.getAnsi();
                        break;
                    }
                    case 7: {
                        TaggedReader rdr = reader.getStreamReader();
                        while (rdr.next()) {
                            switch (rdr.getCurrentTag()) {
                                case 4: {
                                    TaggedReader r = rdr.getStreamReader();
                                    while (r.next()) {
                                        switch (r.getCurrentTag()) {
                                            case 2: {
                                                this.entries.put(new File(this, r));
                                                break;
                                            }
                                            case 1: {
                                                this.entries.put(new Folder(this, r));
                                            }
                                        }
                                    }
                                    return;
                                }
                            }
                        }
                        break;
                    }
                }
            }
        }

        @SmartScriptableObject.PropertyTag
        public Entry getExecutable() {
            return Strings.isVoid(this.executable) ? null : this.find(this.executable);
        }

        public void setExecutable(Entry e) {
            this.executable = e.path();
        }

        @Override
        protected void store(TaggedWriter writer) throws IOException {
            writer.putAnsiIf(1, this.executable);
            writer.putAnsiIf(2, this.action);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            TaggedWriter wrt = new TaggedWriter(tmp);
            wrt.putInt32(3, 0);
            ByteArrayOutputStream t = new ByteArrayOutputStream();
            TaggedWriter w = new TaggedWriter(t);
            this.storeChildren(w);
            wrt.putRaw(4, t.internalBuffer(), t.size());
            writer.putRaw(7, tmp.internalBuffer(), tmp.size());
        }

        @SmartScriptableObject.FunctionTag
        public void saveTo(Object o) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TaggedWriter writer = new TaggedWriter(out);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            TaggedWriter wrt = new TaggedWriter(tmp);
            this.store(wrt);
            writer.putRaw(2, tmp.internalBuffer(), tmp.size());
            BinaryObject b = new BinaryObject(out.toByteArray());
            if (o instanceof BlobField) {
                ((BlobField)o).setAsBinary(b);
            } else if (o instanceof Parameter) {
                ((Parameter)o).setAsBinary(b);
            }
        }

        @Override
        public boolean path(StringBuilder out) {
            return false;
        }

        @Override
        public void setName(String n) {
        }

        private Entry find(String path) {
            String[] sp = path.replaceAll("\\\\", "/").split("/");
            Entry f = this;
            for (String p : sp) {
                if (p.isEmpty()) continue;
                if (!(f instanceof Folder)) {
                    throw new InformException("\"" + f.path() + "\" \u044d\u0442\u043e \u043d\u0435 \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
                }
                Object o = ((Folder)f).entries.get(p);
                if (o == null) {
                    throw new InformException("\u0424\u0430\u0439\u043b \"" + f.path() + "/" + p + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                if (!(o instanceof Entry)) {
                    throw new InformException("\"" + f.path() + "/" + p + "\" \u044d\u0442\u043e \u043d\u0435 \u0438\u043d\u043e\u0434");
                }
                f = (Entry)o;
            }
            return f;
        }
    }

    private static class Folder
    extends Entry {
        private static final int TAG_BEGIN = 1;
        private static final int TAG_END = 6;
        protected final Entries entries = new Entries();

        public Folder(Entry parent) {
            super(parent);
            Folder.putConstProperty(this, "files", this.entries);
        }

        public Folder(Entry parent, TaggedReader reader) throws IOException {
            this(parent);
            this.name = reader.getAnsi(1);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        this.entries.put(new Folder(this, reader));
                        break;
                    }
                    case 2: {
                        this.entries.put(new File(this, reader));
                        break;
                    }
                    case 6: {
                        return;
                    }
                }
            }
        }

        @SmartScriptableObject.FunctionTag
        public File addFile(String name) {
            File e = new File(this);
            e.name = name;
            if (name != null) {
                this.entries.put(e);
            }
            return e;
        }

        @SmartScriptableObject.FunctionTag
        public Folder addFolder(String name) {
            Folder e = new Folder(this);
            e.name = name;
            if (name != null) {
                this.entries.put(e);
            }
            return e;
        }

        @Override
        protected void renamed(Entry e, String oldName) {
            if (oldName != null) {
                this.entries.delete(oldName);
            }
            if (this.entries.get(e.name, (Scriptable)this.entries) != null) {
                throw new InformException("\u0424\u0430\u0439\u043b \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            this.entries.put(e);
        }

        protected void storeChildren(TaggedWriter writer) throws IOException {
            for (Object id : this.entries.getIds()) {
                Object o = this.entries.get(id);
                if (!(o instanceof Entry)) continue;
                ((Entry)o).store(writer);
            }
        }

        @Override
        protected void store(TaggedWriter writer) throws IOException {
            writer.putAnsiNull(1, this.name);
            this.storeChildren(writer);
            writer.putEmpty(6);
        }

        private static class Entries
        extends SmartScriptableObject {
            private boolean myput;

            private Entries() {
            }

            private void put(Entry value) {
                this.myput = true;
                try {
                    this.put(value.name, (Scriptable)this, (Object)value);
                }
                finally {
                    this.myput = false;
                }
            }

            @Override
            public void put(String name, Scriptable start, Object value) {
                if (!this.myput) {
                    throw new InformException("Read only");
                }
                super.put(name, start, value);
            }
        }
    }

    private static class File
    extends Entry {
        private static final int TAG_BEGIN = 2;
        private static final int TAG_END = 5;
        private static final int TAG_CONTENT = 7;
        private byte[] content;

        public File(Entry parent) {
            super(parent);
        }

        public File(Entry parent, TaggedReader reader) throws IOException, TaggedReaderException {
            this(parent);
            this.name = reader.getAnsi(2);
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 7: {
                        this.content = reader.getRaw();
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
            }
        }

        @Override
        public byte[] internalGetContent() {
            return this.content;
        }

        @SmartScriptableObject.PropertyTag
        public BinaryObject getContent() {
            return new BinaryObject(this.content);
        }

        public void setContent(BinaryObject o) {
            this.content = o.toByteArray();
        }

        @Override
        protected void store(TaggedWriter writer) throws IOException {
            writer.putAnsi(2, this.name);
            if (this.content != null) {
                writer.putRaw(7, this.content);
            }
            writer.putEmpty(5);
        }
    }

    public static class Entry
    extends SmartScriptableObject {
        private final Entry parent;
        protected String name;

        public Entry(Entry parent) {
            this.parent = parent;
            this.setParentScope(parent);
        }

        public byte[] internalGetContent() {
            return null;
        }

        @SmartScriptableObject.PropertyTag
        public String getName() {
            return this.name;
        }

        public void setName(String n) {
            if (n == null || n.isEmpty()) {
                throw new InformException("\u0418\u043c\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            }
            String old = this.name;
            this.name = n;
            this.parent.renamed(this, old);
        }

        protected boolean path(StringBuilder out) {
            if (this.parent.path(out)) {
                out.append('/');
            }
            out.append(this.name);
            return true;
        }

        public String path() {
            StringBuilder result = new StringBuilder();
            this.path(result);
            return result.toString();
        }

        public String toString() {
            return this.path();
        }

        protected void renamed(Entry e, String oldName) {
        }

        protected void store(TaggedWriter writer) throws IOException {
        }
    }
}

