/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.libs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class Triangulator {
    public static <T> void triangulate(Iterator<T> points, TriangleListener<T> tl, Coordinater<T> cr, double minx, double miny, double maxx, double maxy, final Progress progress) throws InterruptedException {
        PointRemoveListener prl;
        GridIndex<T> index = new GridIndex<T>(minx, miny, maxx, maxy);
        int pcount = 0;
        while (points.hasNext()) {
            T p = points.next();
            index.add(new P<T>(p, cr.x(p), cr.y(p)));
            ++pcount;
        }
        P a = null;
        double mx = Double.MAX_VALUE;
        for (P p : index) {
            if (!(p.x < mx)) continue;
            mx = p.x;
            a = p;
        }
        assert (a != null);
        a.takeE();
        P b = null;
        for (P p : index) {
            if (p == a) continue;
            boolean f = false;
            for (P itm : index) {
                if (itm == p || itm == a || !(Triangulator.sn(a, p, itm) > 0.0)) continue;
                f = true;
                break;
            }
            if (f) continue;
            b = p;
            break;
        }
        assert (b != null);
        b.takeE();
        Edge curr = new Edge(a, b);
        final int pointsCount = pcount;
        PointRemoveListener pointRemoveListener = prl = progress == null ? new PointRemoveListener() : new PointRemoveListener(){
            static final int PROGRESS_INTERVAL = 384;
            int pointsLeft;
            int progressLeft;
            {
                this.pointsLeft = pointsCount;
            }

            @Override
            protected void removed() {
                if (this.progressLeft == 0) {
                    progress.progress(1.0 - (double)this.pointsLeft / (double)pointsCount);
                    this.progressLeft = 384;
                }
                --this.progressLeft;
                --this.pointsLeft;
            }
        };
        while (curr != null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Edge ab = curr;
            P a2 = ab.a;
            P p = ab.b;
            P p2 = Triangulator.nearest(ab, index, prl);
            a2.releaseE();
            p.releaseE();
            if (p2 != null) {
                p2.release();
                Edge e = new Edge(a2, p2);
                Edge ac = Triangulator.re(curr, e);
                if (ac == e) {
                    a2.takeE();
                    p2.takeE();
                    ac.next = curr.next;
                    curr.next = ac;
                } else {
                    a2.releaseE();
                    p2.releaseE();
                }
                Edge e2 = new Edge(p2, p);
                Edge cb = Triangulator.re(curr, e2);
                if (cb == e2) {
                    p.takeE();
                    p2.takeE();
                    cb.next = curr.next;
                    curr.next = cb;
                } else {
                    p.releaseE();
                    p2.releaseE();
                }
                tl.triangle(a2.point, p.point, p2.point);
            }
            curr = curr.next;
        }
    }

    private static <T> Edge<T> re(Edge<T> prev, Edge<T> like) {
        Edge e;
        int h = like.hashCode();
        while ((e = prev.next) != null) {
            if (e.hash == h && e.equals(like)) {
                prev.next = e.next;
                return e;
            }
            prev = e;
        }
        return like;
    }

    private static double sn(P<?> a, P<?> o, P<?> b) {
        double dxA = a.x - o.x;
        double dyA = a.y - o.y;
        double dxB = b.x - o.x;
        double dyB = b.y - o.y;
        return dxA * dyB - dyA * dxB;
    }

    private static double ang(P<?> a, P<?> o, P<?> b) {
        double dxA = a.x - o.x;
        double dyA = a.y - o.y;
        double la = Math.sqrt(dxA * dxA + dyA * dyA);
        double dxB = b.x - o.x;
        double dyB = b.y - o.y;
        double lb = Math.sqrt(dxB * dxB + dyB * dyB);
        double cos = (dxA * dxB + dyA * dyB) / la / lb;
        return -cos;
    }

    private static <T> P<T> nearest(Edge<T> e, GridIndex<T> index, PointRemoveListener prl) {
        double noy;
        double dy;
        double y2;
        double x2;
        double d;
        double x1;
        double y4;
        double y3;
        double y1;
        double x3;
        double rnl;
        double x4;
        double ua;
        double nox;
        double dx;
        P<T> rr;
        index.resetFlags();
        double el = Math.sqrt(e.slen());
        double cx = (e.a.x + e.b.x) / 2.0;
        double cy = (e.a.y + e.b.y) / 2.0;
        double ny = e.b.x - e.a.x;
        double nx = e.a.y - e.b.y;
        double nl = Math.sqrt(nx * nx + ny * ny);
        P<T> r = Triangulator.nearest(e, index, el, el, nx /= nl, ny /= nl, cx, cy, prl);
        if (r == null) {
            return Triangulator.nearest(e, index, 3.4028234663852886E38, el, nx, ny, cx, cy, prl);
        }
        P a = e.a;
        P b = e.b;
        double rcx = (r.x + b.x) / 2.0;
        double rcy = (r.y + b.y) / 2.0;
        double rny = r.x - b.x;
        double rnx = b.y - r.y;
        if ((rr = Triangulator.nearest(e, index, Math.sqrt((dx = r.x - (nox = cx + nx * (ua = (((x4 = rcx + (rnx /= (rnl = Math.sqrt(rny * rny + rnx * rnx)))) - (x3 = rcx)) * ((y1 = cy) - (y3 = rcy)) - ((y4 = rcy + (rny /= rnl)) - y3) * ((x1 = cx) - x3)) / (d = (y4 - y3) * ((x2 = cx + nx) - x1) - (x4 - x3) * ((y2 = cy + ny) - y1))))) * dx + (dy = r.y - (noy = cy + ny * ua)) * dy), el, nx, ny, cx, cy, prl)) != null && Triangulator.ang(a, rr, b) > Triangulator.ang(a, r, b)) {
            r = rr;
        }
        return r;
    }

    private static <T> P<T> nearest(Edge<T> e, GridIndex<T> index, double r, double el, double nx, double ny, double cx, double cy, PointRemoveListener prl) {
        P<T> result = null;
        P a = e.a;
        P b = e.b;
        double ang = -1.7976931348623157E308;
        double l = Math.sqrt(r * r - el * el / 4.0);
        double ox = cx + nx * l;
        double oy = cy + ny * l;
        Iterator<P<T>> i = index.findInRadius(ox, oy, r);
        while (i.hasNext()) {
            double an;
            P<T> c = i.next();
            if (c.usages == 0) {
                i.remove();
                prl.removed();
                continue;
            }
            if (Triangulator.sn(b, a, c) <= 0.0 || !((an = Triangulator.ang(a, c, b)) > ang)) continue;
            ang = an;
            result = c;
        }
        if (result == null && r < index.mr) {
            result = Triangulator.nearest(e, index, r * 2.0, el, nx, ny, cx, cy, prl);
        }
        return result;
    }

    private static class PointRemoveListener {
        private PointRemoveListener() {
        }

        protected void removed() {
        }
    }

    public static interface TriangleListener<T> {
        public void triangle(T var1, T var2, T var3);
    }

    private static class GridIndex<T>
    implements Iterable<P<T>> {
        static final Iterator<?> EMPTY = Collections.emptyList().iterator();
        static final int SZ = 20;
        final double dx;
        final double dy;
        final double sx;
        final double sy;
        final double cr;
        final double mr;
        final Collection<P<T>>[] cells;
        final boolean[] flags = new boolean[400];

        GridIndex(double x0, double y0, double x1, double y1) {
            this.cells = new Collection[400];
            for (int i = 0; i < this.cells.length; ++i) {
                this.cells[i] = new LinkedList<P<T>>();
            }
            this.dx = x0;
            this.dy = y0;
            this.sx = (x1 - x0) / 19.99;
            this.sy = (y1 - y0) / 19.99;
            double r = Math.max(this.sx, this.sy) / 2.0;
            this.cr = Math.sqrt(r * r * 2.0);
            r = Math.max(x1 - x0, y1 - y0);
            this.mr = Math.sqrt(r * r * 2.0);
        }

        void resetFlags() {
            Arrays.fill(this.flags, false);
        }

        void add(P<T> p) {
            int r = (int)((p.y - this.dy) / this.sy);
            int c = (int)((p.x - this.dx) / this.sx);
            this.cells[c + r * 20].add(p);
        }

        Iterator<P<T>> findInRadius(final double x, final double y, double r) {
            final double sr = (r += this.cr) * r;
            return new Iterator<P<T>>(){
                Iterator<P<T>> n = EMPTY;
                int i = 0;

                @Override
                public boolean hasNext() {
                    while (!this.n.hasNext() && this.i < 400) {
                        if (!flags[this.i]) {
                            int r = this.i / 20;
                            int c = this.i % 20;
                            double cx = sx / 2.0 + sx * (double)c + dx;
                            double cy = sy / 2.0 + sy * (double)r + dy;
                            double dx = cx - x;
                            double dy = cy - y;
                            double rr = dx * dx + dy * dy;
                            if (sr > 3.4028234663852886E38 || rr <= sr) {
                                this.n = cells[this.i].iterator();
                                flags[this.i] = true;
                            }
                        }
                        ++this.i;
                    }
                    return this.n.hasNext();
                }

                @Override
                public P<T> next() {
                    return this.n.next();
                }

                @Override
                public void remove() {
                    this.n.remove();
                }
            };
        }

        @Override
        public Iterator<P<T>> iterator() {
            return new Iterator<P<T>>(){
                Iterator<P<T>> n;
                int i;
                {
                    this.n = cells[0].iterator();
                    this.i = 1;
                }

                @Override
                public boolean hasNext() {
                    while (!this.n.hasNext() && this.i < 400) {
                        this.n = cells[this.i++].iterator();
                    }
                    return this.n.hasNext();
                }

                @Override
                public P<T> next() {
                    return this.n.next();
                }

                @Override
                public void remove() {
                    this.n.remove();
                }
            };
        }
    }

    private static class Edge<T> {
        public final P<T> a;
        public final P<T> b;
        final int hash;
        Edge<T> next;

        Edge(P<T> a, P<T> b) {
            this.a = a;
            this.b = b;
            this.hash = a.hashCode() + b.hashCode();
        }

        double slen() {
            double dx = this.b.x - this.a.x;
            double dy = this.b.y - this.a.y;
            return dx * dx + dy * dy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Edge) {
                Edge that = (Edge)obj;
                return this.a.equals(that.a) && this.b.equals(that.b) || this.a.equals(that.b) && this.b.equals(that.a);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class P<T> {
        public final T point;
        public final double x;
        public final double y;
        final int hash;
        int usages = -1;

        P(T p, double x, double y) {
            this.point = p;
            this.x = x;
            this.y = y;
            int h = 5;
            h = 83 * h + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
            this.hash = h = 83 * h + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        }

        void takeE() {
            if (this.usages < 0) {
                this.usages = 0;
            }
            ++this.usages;
        }

        void release() {
            if (this.usages < 0) {
                this.usages = 0;
            }
        }

        void releaseE() {
            if (this.usages <= 0) {
                throw new IllegalStateException();
            }
            --this.usages;
        }

        public boolean equals(Object obj) {
            if (obj instanceof P) {
                P that = (P)obj;
                return that.x == this.x && that.y == this.y;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static interface Progress {
        public void progress(double var1);
    }

    public static interface Coordinater<T> {
        public double x(T var1);

        public double y(T var1);
    }
}

