/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.InformException;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.connect.Connector;
import inform.agent.mtd.MetadataNodeReader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.request.ModifyNode;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptCustomNode;
import inform.common.Empty;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.BitSet;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class ScriptNode
extends ScriptableObject {
    private static final String[] jsMethods = new String[]{"getContent", "save"};
    private static final String[] readonlyJsProperties = new String[]{"id", "name", "scriptName", "type", "parentID", "parent", "ownerID", "owner", "creationTime", "modificationAttributeTime", "modificationContentTime", "modificationUserID", "modificationUser", "isModified", "children"};
    private static final String[] jsProperties = new String[]{"description"};
    protected MetadataLibrary metaLib;
    protected MetadataNodeReader metaNode;
    private int defaultActionId = 0;
    private boolean auditEvents = false;
    private String _desc = "";
    protected Children children = null;
    private BitSet modifiedAttrTags = null;

    public ScriptNode(MetadataLibrary metadataLibrary, MetadataNodeReader metadataNode) {
        this.setParentScope(metadataLibrary);
        this.metaLib = metadataLibrary;
        this.metaNode = metadataNode;
        this.defineFunctionProperties(jsMethods, ScriptNode.class, 0);
        for (String propertyName : readonlyJsProperties) {
            this.defineProperty(propertyName, ScriptNode.class, 1);
        }
        for (String propertyName : jsProperties) {
            this.defineProperty(propertyName, ScriptNode.class, 0);
        }
    }

    public void idle() {
        if (this.metaLib != null) {
            this.metaLib.idle();
        }
    }

    public double getId() {
        this.idle();
        return this.metaNode.id;
    }

    public Object getContent() {
        this.idle();
        if (this.metaNode.content == null) {
            return null;
        }
        this.idle();
        return new BinaryObject(this.metaNode.content);
    }

    public String getName() {
        this.idle();
        return this.metaNode.name;
    }

    public String getScriptName() {
        this.idle();
        return this.metaNode.identName;
    }

    public String getDescription() {
        this.idle();
        return this.metaNode.description;
    }

    public void setDescription(String newDesc) {
        this.idle();
        if (!this._desc.equals(newDesc)) {
            this.setAttrTagModified(12);
        }
        this._desc = newDesc;
    }

    public int getType() {
        this.idle();
        return this.metaNode.type;
    }

    public double getParentID() {
        this.idle();
        return this.metaNode.parentId;
    }

    public ScriptNode getParent() throws IOException, InformException, SQLException {
        this.idle();
        return this.metaLib.getNode(this.getParentID());
    }

    public double getOwnerID() {
        this.idle();
        return this.metaNode.ownerId;
    }

    public ScriptNode getOwner() throws IOException, InformException, SQLException {
        this.idle();
        return this.metaLib.getNode(this.metaNode.ownerId);
    }

    public double getModificationUserID() {
        this.idle();
        return this.metaNode.modificationUserId;
    }

    public ScriptNode getModificationUser() throws IOException, InformException, SQLException {
        this.idle();
        return this.metaLib.getNode(this.metaNode.modificationUserId);
    }

    public double getCreationTime() {
        this.idle();
        return this.metaNode.creationTime;
    }

    public double getModificationAttributeTime() {
        this.idle();
        return this.metaNode.modificationAttributeTime;
    }

    public double getModificationContentTime() {
        this.idle();
        return this.metaNode.modificationContentTime;
    }

    @Override
    public String getClassName() {
        return "MetadataNode";
    }

    public abstract ScriptCustomNode getRefNode() throws IOException, InformException, SQLException;

    void loadTag(int tag, TaggedReader reader) throws IOException {
        this.idle();
        switch (tag) {
            case 13: {
                this.defaultActionId = reader.getInt();
                break;
            }
            case 33: {
                this.auditEvents = reader.getBoolean();
            }
        }
    }

    void init() throws IOException {
        this.idle();
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(this.metaNode.attributesContent), this.metaNode.attributesContent.length);
        this.load(reader);
    }

    void load(TaggedReader reader) throws IOException {
        while (reader.getNextTag() != 0) {
            this.idle();
            this.loadTag(reader.getCurrentTag(), reader);
        }
    }

    public void setAttrTagModified(int tag) {
        this.idle();
        if (tag <= 0) {
            return;
        }
        if (this.modifiedAttrTags == null) {
            this.modifiedAttrTags = new BitSet();
        }
        this.modifiedAttrTags.set(tag);
    }

    protected boolean saveModifiedAttrTag(int tag, TaggedWriter writer) throws IOException {
        this.idle();
        switch (tag) {
            case 12: {
                writer.putString(tag, this._desc);
                return true;
            }
        }
        return false;
    }

    public void save() throws Exception {
        this.idle();
        if (this.modifiedAttrTags == null || this.modifiedAttrTags.isEmpty()) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        TaggedWriter writer = new TaggedWriter(stream);
        int tag = this.modifiedAttrTags.nextSetBit(0);
        while (tag >= 0) {
            this.saveModifiedAttrTag(tag, writer);
            tag = this.modifiedAttrTags.nextSetBit(tag + 1);
        }
        this.idle();
        writer.flush();
        ServerSideHost ssHost = this.metaLib.getServerSideHost();
        this.idle();
        ModifyNode.modifyNode(this.metaLib.getSsContext(), ssHost, stream.toByteArray(), false, this.metaNode.id);
    }

    public boolean getIsModified() {
        this.idle();
        return this.modifiedAttrTags != null && !this.modifiedAttrTags.isEmpty();
    }

    public Object getChildren() throws InformException, SQLException {
        if (this.children == null) {
            this.children = new Children(this);
        }
        return this.children;
    }

    public static class Children
    extends SmartScriptableObject {
        final ScriptNode node;
        final double[] children;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Children(ScriptNode node) throws InformException, SQLException {
            this.node = node;
            Node mtdNode = MtdEngine.getNode(node.getId());
            if (mtdNode == null) {
                this.children = Empty.doubleArray;
            } else {
                try (Connector.Metabase connector = new Connector.Metabase("ScriptNode.Children");){
                    connector.markAsReadonly();
                    this.children = mtdNode.getChildren(connector);
                    connector.commit();
                }
            }
            this.setParentScope(node);
        }

        public Children() {
            this.node = null;
            this.children = Empty.doubleArray;
            this.setParentScope(this.node);
        }

        @Override
        public String getClassName() {
            return "AccountRoles";
        }

        @Override
        public Object get(int index, Scriptable start) {
            if (index < 0 || index >= this.children.length) {
                return super.get(index, start);
            }
            try {
                return this.node.metaLib.getNode(this.children[index]);
            }
            catch (InformException | IOException | SQLException e) {
                Core.logger.error(null, e);
                return Scriptable.NOT_FOUND;
            }
        }

        @SmartScriptableObject.PropertyTag
        public int getLength() {
            return this.children.length;
        }

        @SmartScriptableObject.PropertyTag
        public int getCount() {
            return this.children.length;
        }
    }
}

