/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.metadata;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.collections.Cursor;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.utils.SqlParameter;
import inform.agent.mtd.RolesTable;
import inform.agent.mtd.Security;
import inform.agent.mtd.UsersTable;
import inform.agent.mtd.nodes.AccountNode;
import inform.agent.mtd.nodes.UserNode;
import inform.agent.mtd.nodes.UserRole;
import inform.agent.mtd.nodes.VirtualUser;
import inform.agent.scripts.Constants;
import inform.agent.scripts.metadata.MetadataLibrary;
import inform.agent.scripts.metadata.ScriptNode;
import inform.agent.scripts.metadata.ScriptUserNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;

public class ScriptTableUserNode
extends ScriptUserNode {
    private final double userId;
    private final UsersTable usersTable;
    private final RolesTable rolesTable;
    private byte[] content;
    private String login;
    private double parentGroupId;
    private SqlParameter[] attributes;
    private final UserNode.Props props = new UserNode.Props();
    private int imageId = 0;
    private final byte[] securityHash = Security.newMD5Hash();
    private final byte[] securitySalt = Security.newMD5Salt();
    private byte[] sha256Hash = null;
    private byte[] sha256Salt = null;
    private byte[] dbLogins = null;
    private byte[] startups = null;

    public ScriptTableUserNode(MetadataLibrary metadataLibrary, SqlParameter[] fields, UsersTable usersTable, RolesTable rolesTable) throws SQLException {
        super(metadataLibrary, null);
        this.attributes = fields;
        this.userId = fields[0].getDouble();
        this.usersTable = usersTable;
        this.rolesTable = rolesTable;
        this.content = fields[3].getBlob();
        this.login = fields[1].getString();
        this.parentGroupId = fields[2].getDouble();
        this.locked = fields[4].isNull() || fields[4].getAsBoolean();
        this._locked = this.locked;
        if (fields[5] != null) {
            this.propFio = fields[5].getString();
        }
        if (fields[8] != null) {
            this.propPhone = fields[8].getString();
        }
        if (fields[9] != null) {
            this.propEmail = fields[9].getString();
        }
        if (fields[7] != null) {
            this.imageId = fields[7].getInteger();
        }
        if (fields[10] != null) {
            this.props.setCardId(fields[10].getDouble());
        }
        if (fields[20] != null) {
            this.props.setServerManaged(fields[20].getAsBoolean());
        }
        if (fields[21] != null) {
            this.props.setServerManagedEndDate(fields[21].getDateTime());
        }
        this.props.setFio(this.propFio);
        this.props.setEmail(this.propEmail);
        this.props.setPhone(this.propPhone);
        this.children = new ScriptNode.Children();
    }

    @Override
    public String getClassName() {
        return "TableUserNode";
    }

    @Override
    void init() throws IOException, TaggedReaderException {
        this.idle();
        if (this.content == null || this.content.length == 0) {
            return;
        }
        TaggedReader reader = new TaggedReader(new ByteArrayInputStream(this.content), this.content.length);
        this.load(reader);
        if (this.attributes[13] != null) {
            this.activeDirectory = this.attributes[13].getAsBoolean();
        }
        if (this.attributes[14] != null) {
            this.inheritedStartup = this.attributes[14].getAsBoolean();
        }
        if (this.attributes[15] != null) {
            this.startupRootNodeId = this.attributes[15].getDouble();
        }
        if (this.attributes[16] != null) {
            this.startupStartNodeId = this.attributes[16].getDouble();
        }
        if (this.attributes[17] != null) {
            this.startupStartNodeAction = this.attributes[17].getInteger();
        }
        if (this.attributes[18] != null) {
            this.startupScriptId = this.attributes[18].getDouble();
        }
        if (this.attributes[19] != null) {
            this.webStartNodeId = this.attributes[19].getDouble();
        }
        this.attributes = null;
    }

    @Override
    void load(TaggedReader in) throws IOException, TaggedReaderException {
        this.userInterface.setAllInherited(true);
        while (in.next()) {
            switch (in.getCurrentTag()) {
                case 3: 
                case 4: 
                case 21: 
                case 24: 
                case 25: 
                case 33: 
                case 52: 
                case 87: {
                    break;
                }
                case 30: {
                    in.getRaw(this.securityHash, this.securityHash.length);
                    this.changePasswordOnLogin = false;
                    this.passwordChangeDate = DateTime.currentDate();
                    break;
                }
                case 31: {
                    in.getRaw(this.securitySalt, this.securitySalt.length);
                    this.changePasswordOnLogin = false;
                    break;
                }
                case 42: {
                    this.props.loadScale(in.getRaw());
                    break;
                }
                case 80: {
                    this.singleLogin = in.getBoolean();
                    if (this.possibleLoginCount == 0) {
                        if (!this.singleLogin) break;
                        this.possibleLoginCount = 1;
                        break;
                    }
                    this.singleLogin = this.possibleLoginCount == 1;
                    break;
                }
                case 110: {
                    this.possibleLoginCount = in.getInt();
                    this.singleLogin = this.possibleLoginCount == 1;
                    break;
                }
                case 81: {
                    this.changePasswordOnLogin = in.getBoolean();
                    break;
                }
                case 34: {
                    this.groups = LittleEndian.toDoubleArray(in.getRaw());
                    break;
                }
                case 35: {
                    this.inheritedStartup = true;
                    break;
                }
                case 37: {
                    this.constantsContent = in.getRaw();
                    break;
                }
                case 45: {
                    this.dbLogins = in.getRaw();
                    break;
                }
                case 51: {
                    this.ineritedConnectionToServer = in.getBoolean();
                    break;
                }
                case 50: {
                    this.ineritedConnectionToServer = false;
                    this.loadServerIPs(in.getStreamReader());
                    break;
                }
                case 82: {
                    this.activeDirectory = in.getBooleanDef(false);
                    break;
                }
                case 83: {
                    this.startups = in.getRaw();
                    this.inheritedStartup = false;
                    break;
                }
                case 20: {
                    this.inheritedAcl = in.getBoolean();
                    if (!this.inheritedAcl) break;
                    this.acl = null;
                    break;
                }
                case 38: {
                    int intVal = in.getInt();
                    this.accessLevel = UserRole.get(intVal);
                    assert (this.accessLevel != null);
                    break;
                }
                case 89: {
                    this.userInterface.inheritedSavePerRecord = in.getBoolean();
                    break;
                }
                case 88: {
                    this.userInterface.savePerRecord = in.getBoolean();
                    break;
                }
                case 91: {
                    this.userInterface.inheritedCanSetupUser = in.getBoolean();
                    break;
                }
                case 90: {
                    this.userInterface.canSetupUser = in.getBoolean();
                    break;
                }
                case 94: {
                    this.userInterface.inheritedCanCreateNodes = in.getBoolean();
                    break;
                }
                case 92: {
                    this.userInterface.canCreateAnyNodes = true;
                    break;
                }
                case 93: {
                    this.userInterface.canCreateAnyNodes = false;
                    this.userInterface.canCreateNodeTypes = LittleEndian.toIntArray(in.getRaw());
                    break;
                }
                case 96: {
                    this.userInterface.inheritedSimplePopup = in.getBoolean();
                    break;
                }
                case 95: {
                    this.userInterface.simplePopup = in.getBoolean();
                    break;
                }
                case 98: {
                    this.userInterface.inheritedCanWritePublicFilters = in.getBoolean();
                    break;
                }
                case 97: {
                    this.userInterface.canWritePublicFilters = in.getBoolean();
                    break;
                }
                case 100: {
                    this.userInterface.inheritedCanUploadPex = this.userInterface.inheritedCanWritePex = in.getBoolean();
                    break;
                }
                case 99: {
                    this.userInterface.canUploadPex = this.userInterface.canWritePex = in.getBoolean();
                    break;
                }
                case 107: {
                    this.userInterface.inheritedCanWritePex = in.getBoolean();
                    break;
                }
                case 106: {
                    this.userInterface.canWritePex = in.getBoolean();
                    break;
                }
                case 109: {
                    this.userInterface.inheritedCanUploadPex = in.getBoolean();
                    break;
                }
                case 108: {
                    this.userInterface.canUploadPex = in.getBoolean();
                    break;
                }
                case 103: {
                    this.userInterface.inheritedCanViewDataHistory = in.getBoolean();
                    break;
                }
                case 102: {
                    this.userInterface.canViewDataHistory = in.getBoolean();
                    break;
                }
                case 105: {
                    this.userInterface.inheritedCanViewMetadataHistory = in.getBoolean();
                    break;
                }
                case 104: {
                    this.userInterface.canViewMetadataHistory = in.getBoolean();
                    break;
                }
                case 112: {
                    this.userInterface.inheritedEditNode = in.getBoolean();
                    break;
                }
                case 111: {
                    this.userInterface.editNode = in.getBoolean();
                    break;
                }
                case 113: {
                    if (this.rolesTable == null || !this.rolesTable.enabled()) break;
                    try {
                        this.groups = this.rolesTable.select(this.metaLib.getSsContext(), this.getId());
                        break;
                    }
                    catch (SQLException e) {
                        throw InformException.wrap(e);
                    }
                }
                case 115: {
                    this.sha256Hash = in.getRaw();
                    this.changePasswordOnLogin = false;
                    this.passwordChangeDate = DateTime.currentDate();
                    break;
                }
                case 116: {
                    this.sha256Salt = in.getRaw();
                    this.changePasswordOnLogin = false;
                }
            }
        }
    }

    @Override
    public void save() throws Exception {
        ByteArrayOutputStream userContent = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(userContent);
        this.props.setFio(this.propFio);
        this.props.setEmail(this.propEmail);
        this.props.setPhone(this.propPhone);
        this.props.setScale(this.propUIScale);
        out.putInt32(38, this.accessLevel.toInt());
        if (this.sha256Hash != null && this.sha256Salt != null) {
            out.putRaw(115, this.sha256Hash);
            out.putRaw(116, this.sha256Salt);
        } else {
            out.putRaw(30, this.securityHash, this.securityHash.length);
            out.putRaw(31, this.securitySalt, this.securitySalt.length);
        }
        if (this.usersTable.field(13) == null) {
            out.putBool(82, this.activeDirectory);
        }
        if (this.roles == null) {
            out.putRaw(34, LittleEndian.doubleArrayToBinary(this.groups));
        } else {
            out.putRaw(34, LittleEndian.doubleCursorToBinary(this.roles.roles.iterator(), this.roles.roles.size()));
        }
        if (this.usersTable.field(14) == null && this.inheritedStartup) {
            out.putBool(35, this.inheritedStartup);
        }
        out.putRaw(42, this.props.getScaleProps());
        if (this.constants != null && this.constants.isModified()) {
            this.constantsContent = this.constants.storeActualConstants();
            this.constants.clearModifiedFlag();
        }
        out.putRaw(37, this.constantsContent);
        out.putBool(89, this.userInterface.inheritedSavePerRecord);
        if (!this.userInterface.inheritedSavePerRecord) {
            out.putBool(88, this.userInterface.savePerRecord);
        }
        out.putBool(91, this.userInterface.inheritedCanSetupUser);
        if (!this.userInterface.inheritedCanSetupUser) {
            out.putBool(90, this.userInterface.canSetupUser);
        }
        out.putBool(94, this.userInterface.inheritedCanCreateNodes);
        if (!this.userInterface.inheritedCanCreateNodes) {
            if (this.userInterface.canCreateAnyNodes) {
                out.putEmpty(92);
            } else {
                out.putIntArray(93, this.userInterface.canCreateNodeTypes);
            }
        }
        out.putBool(96, this.userInterface.inheritedSimplePopup);
        if (!this.userInterface.inheritedSimplePopup) {
            out.putBool(95, this.userInterface.simplePopup);
        }
        out.putBool(98, this.userInterface.inheritedCanWritePublicFilters);
        if (!this.userInterface.inheritedCanWritePublicFilters) {
            out.putBool(97, this.userInterface.canWritePublicFilters);
        }
        out.putBool(107, this.userInterface.inheritedCanWritePex);
        if (!this.userInterface.inheritedCanWritePex) {
            out.putBool(106, this.userInterface.canWritePex);
        }
        out.putBool(109, this.userInterface.inheritedCanUploadPex);
        if (!this.userInterface.inheritedCanUploadPex) {
            out.putBool(108, this.userInterface.canUploadPex);
        }
        out.putBool(103, this.userInterface.inheritedCanViewDataHistory);
        if (!this.userInterface.inheritedCanViewDataHistory) {
            out.putBool(102, this.userInterface.canViewDataHistory);
        }
        out.putBool(105, this.userInterface.inheritedCanViewMetadataHistory);
        if (!this.userInterface.inheritedCanViewMetadataHistory) {
            out.putBool(104, this.userInterface.canViewMetadataHistory);
        }
        out.putBool(112, this.userInterface.inheritedEditNode);
        if (!this.userInterface.inheritedEditNode) {
            out.putBool(111, this.userInterface.editNode);
        }
        out.putRaw(45, this.dbLogins);
        out.putBool(80, this.singleLogin);
        out.putInt32(110, this.possibleLoginCount);
        out.putBool(81, this.changePasswordOnLogin);
        out.putBool(51, this.ineritedConnectionToServer);
        if (!this.ineritedConnectionToServer) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            TaggedWriter stream = new TaggedWriter(bytes);
            if (this.scriptConnectionsToServer != null) {
                this.specifiedConnectionsToServer = this.scriptConnectionsToServer.getIps();
            }
            if (this.allowConnectionToAnyServer) {
                stream.putEmpty(1);
            }
            if (this.specifiedConnectionsToServer != null) {
                for (Cursor.Integer ip : this.specifiedConnectionsToServer) {
                    stream.putInt32(2, ip.value);
                }
            }
            stream.flush();
            out.putRaw(50, bytes);
        }
        if (this.usersTable.field(14) == null && !this.inheritedStartup) {
            out.putRaw(83, this.startups);
        }
        out.flush();
        UsersTable.UpdateParams updateParams = new UsersTable.UpdateParams();
        if (this.inheritedStartup) {
            updateParams.rootNode = 0.0;
            updateParams.startNode = 0.0;
            updateParams.startAction = -1;
            updateParams.startScript = 0.0;
            updateParams.startWebNode = 0.0;
        } else {
            updateParams.rootNode = this.startupRootNodeId;
            updateParams.startNode = this.startupStartNodeId;
            updateParams.startAction = this.startupStartNodeAction;
            updateParams.startScript = this.startupScriptId;
            updateParams.startWebNode = this.webStartNodeId;
        }
        if (this.rolesTable.enabled()) {
            updateParams.roles = this.roles.roles.toArray();
            if (updateParams.roles != null && updateParams.roles.length != 0) {
                updateParams.rolesPrimaryKeys = new double[updateParams.roles.length];
                for (int i = 0; i < updateParams.rolesPrimaryKeys.length; ++i) {
                    updateParams.rolesPrimaryKeys[i] = Core.generateId();
                }
            }
        }
        updateParams.adLogin = this.activeDirectory;
        updateParams.inheritedStartup = this.inheritedStartup;
        updateParams.rootNode = this.startupRootNodeId;
        updateParams.startNode = this.startupStartNodeId;
        updateParams.startAction = this.startupStartNodeAction;
        updateParams.startScript = this.startupScriptId;
        updateParams.startWebNode = this.webStartNodeId;
        updateParams.props = this.props;
        updateParams.content = userContent.internalBuffer();
        updateParams.contentLength = userContent.size();
        this.usersTable.update(this.metaLib.getSsContext(), this.metaLib.getServerSideHost(), this.userId, this.login, this.parentGroupId, this._locked, updateParams, this.rolesTable);
        VirtualUser.invalidateUser(this.userId);
        AccountNode.invalidateSecurity();
    }

    @Override
    public double getId() {
        this.idle();
        return this.userId;
    }

    @Override
    public Object getContent() {
        this.idle();
        return this.content;
    }

    @Override
    public String getName() {
        this.idle();
        return this.login;
    }

    @Override
    public String getScriptName() {
        this.idle();
        return "";
    }

    @Override
    public String getDescription() {
        this.idle();
        return "";
    }

    @Override
    public int getType() {
        this.idle();
        return 3;
    }

    @Override
    public double getParentID() {
        this.idle();
        return this.parentGroupId;
    }

    @Override
    public double getOwnerID() {
        return 0.0;
    }

    @Override
    public ScriptNode getOwner() throws IOException, InformException {
        return null;
    }

    @Override
    public double getCreationTime() {
        return 0.0;
    }

    @Override
    public double getModificationAttributeTime() {
        return 0.0;
    }

    @Override
    public double getModificationContentTime() {
        return 0.0;
    }

    @Override
    public ScriptNode getModificationUser() throws IOException, InformException {
        return null;
    }

    @Override
    public double getModificationUserID() {
        return 0.0;
    }

    @Override
    public Constants getConstants() throws InformException, IOException {
        this.idle();
        if (this.constants == null) {
            this.constants = new Constants(this.getId());
            this.constants.loadFromUser(this.parentGroupId, this.metaLib.getGlobalConstantsContent(), this.constantsContent);
            this.constants.setParentScope(this);
        }
        return this.constants;
    }
}

