/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.net;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class ThreadLocalCookieHandler
extends CookieHandler {
    private static final ThreadLocal<CookieHandler> LOCAL = new ThreadLocal<CookieHandler>(){

        @Override
        protected CookieHandler initialValue() {
            return new CookieManager();
        }
    };

    public static void install() {
        CookieHandler.setDefault(new ThreadLocalCookieHandler());
    }

    public static void clearLocalCookies() {
        LOCAL.remove();
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        return LOCAL.get().get(uri, requestHeaders);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        LOCAL.get().put(uri, responseHeaders);
    }
}

