/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.soap.SoapMimeHeaders;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.SOAPException;
import org.mozilla.javascript.Scriptable;

public class SoapAttachmentPart
extends SmartScriptableObject {
    private final AttachmentPart attachmentPart;
    private SoapMimeHeaders mimeHeaders = null;

    public SoapAttachmentPart(Scriptable scope, AttachmentPart attachmentPart) {
        this.setParentScope(scope);
        this.attachmentPart = attachmentPart;
    }

    @Override
    public String getClassName() {
        return "AttachmentPart";
    }

    @SmartScriptableObject.PropertyTag
    public SoapMimeHeaders getMimeHeaders() {
        if (this.mimeHeaders == null) {
            this.mimeHeaders = new SoapMimeHeaders((Scriptable)this, this.attachmentPart);
        }
        return this.mimeHeaders;
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getAsBinary() throws SOAPException {
        return new BinaryObject(this.attachmentPart.getRawContentBytes());
    }

    void setContent(String contentType, Object data, Object codepage) throws Exception {
        byte[] v = CryptoUtils.dataAsBytes(data, codepage);
        if (v == null) {
            return;
        }
        this.attachmentPart.setRawContentBytes(v, 0, v.length, contentType);
    }

    @SmartScriptableObject.PropertyTag
    public int getSize() throws SOAPException {
        return this.attachmentPart.getSize();
    }

    @SmartScriptableObject.PropertyTag
    public String getContentID() {
        return this.attachmentPart.getContentId();
    }

    public void setContentID(String id) {
        this.attachmentPart.setContentId(id);
    }

    @SmartScriptableObject.PropertyTag
    public String getContentType() {
        return this.attachmentPart.getContentType();
    }

    public void setContentType(String type) {
        this.attachmentPart.setContentType(type);
    }
}

