/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.agent.scripts.soap.SoapElement;
import inform.agent.scripts.soap.SoapHeaderElement;
import inform.agent.scripts.soap.SoapName;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.javascript.Scriptable;

public class SoapHeader
extends SoapElement {
    private final SOAPHeader header;

    public SoapHeader(Scriptable scope, SOAPHeader header) {
        super(scope, (SOAPElement)header);
        this.header = header;
    }

    @SmartScriptableObject.FunctionTag
    public SoapHeaderElement[] headerElements(Object filter) {
        Iterator iterator = null;
        iterator = filter instanceof String ? this.header.examineHeaderElements((String)filter) : this.header.examineAllHeaderElements();
        ArrayList<SoapHeaderElement> list = new ArrayList<SoapHeaderElement>();
        while (iterator.hasNext()) {
            list.add(new SoapHeaderElement(this.scope, (SOAPHeaderElement)iterator.next()));
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new SoapHeaderElement[0]);
    }

    @SmartScriptableObject.FunctionTag
    public SoapHeaderElement addHeaderElement(Object child, Object prefix, Object uri) throws SOAPException {
        if (child instanceof SoapName) {
            return new SoapHeaderElement(this.scope, this.header.addHeaderElement(((SoapName)child).name));
        }
        if (child instanceof String) {
            String n = (String)child;
            if (n.isEmpty()) {
                return null;
            }
            String p = prefix instanceof String ? (String)prefix : null;
            String u = uri instanceof String ? (String)uri : null;
            SOAPEnvelope envelope = this.getEnvelope();
            if (envelope != null) {
                return new SoapHeaderElement(this.scope, this.header.addHeaderElement(envelope.createName(n, p, u)));
            }
        }
        return null;
    }
}

