/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.soap;

import inform.agent.scripts.soap.SoapMimeHeaders;
import inform.common.SmartScriptableObject;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPPart;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Scriptable;

public class SoapPart
extends SmartScriptableObject {
    private final SOAPPart soapPart;
    private SoapMimeHeaders mimeHeaders = null;

    public SoapPart(Scriptable scope, SOAPPart soapPart) {
        this.setParentScope(scope);
        this.soapPart = soapPart;
    }

    @SmartScriptableObject.PropertyTag
    public SoapMimeHeaders getMimeHeaders() {
        if (this.mimeHeaders == null) {
            this.mimeHeaders = new SoapMimeHeaders((Scriptable)this, this.soapPart);
        }
        return this.mimeHeaders;
    }

    @SmartScriptableObject.PropertyTag
    public String getAsString() throws TransformerConfigurationException, TransformerException, SOAPException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.transform(this.soapPart.getContent(), new StreamResult(sw));
        return sw.toString();
    }
}

