/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.spreadsheets.ods;

import inform.adt.InformException;
import inform.agent.scripts.spreadsheets.ods.OdsFont;
import inform.agent.scripts.spreadsheets.ods.OdsWorkbook;
import inform.common.SmartScriptableObject;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;

public class OdsCellStyle
extends SmartScriptableObject {
    private static final String MESSAGE_BADORIENTATION = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043e\u0440\u0438\u0435\u043d\u0442\u0430\u0446\u0438\u0438 \u0442\u0435\u043a\u0441\u0442\u0430: '%s'. \u0427\u0438\u0441\u043b\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 -90 \u0434\u043e 90.";
    private static final String MESSAGE_BADBORDERSTYLE = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0442\u0438\u043f \u043b\u0438\u043d\u0438\u0438 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u044f\u0447\u0435\u0439\u043a\u0438: '%s'";
    private static final String MESSAGE_BADBORDERSIDE = "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u044f\u0447\u0435\u0439\u043a\u0438: '%s'. \u0427\u0438\u0441\u043b\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435 \u043e\u0442 0 \u0434\u043e 5.";
    private final StyleTableCellPropertiesElement element;
    private final Map<String, String> propertiesCellStyle;
    private final OdsWorkbook book;
    private OdsFont font;

    OdsCellStyle(OdsWorkbook book) {
        this.setParentScope(book);
        this.book = book;
        this.propertiesCellStyle = new HashMap<String, String>();
        this.element = new StyleTableCellPropertiesElement(book.getDom());
    }

    OdsCellStyle(OdsWorkbook book, OdsCellStyle cellStyle) {
        this(book);
        if (cellStyle != null) {
            this.propertiesCellStyle.putAll(cellStyle.propertiesCellStyle);
        }
    }

    OdsCellStyle(OdsWorkbook book, Map<String, String> propertiesCellStyle) {
        this(book);
        this.propertiesCellStyle.putAll(propertiesCellStyle);
    }

    @Override
    public String getClassName() {
        return "OdsCellStyle";
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setFont(OdsFont font) {
        this.font = font;
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsFont getFont() {
        return this.book.createFont(this.font);
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setHorizontalAlignment(Object value) {
        switch (Integer.parseInt(String.valueOf(value))) {
            case 1: {
                this.propertiesCellStyle.put("fo:text-align", "left");
                break;
            }
            case 2: {
                this.propertiesCellStyle.put("fo:text-align", "center");
                break;
            }
            case 3: {
                this.propertiesCellStyle.put("fo:text-align", "right");
                break;
            }
            default: {
                this.propertiesCellStyle.put("fo:text-align", null);
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setVerticalAlignment(Object value) {
        switch (Integer.parseInt(String.valueOf(value))) {
            case 0: {
                this.propertiesCellStyle.put("style:vertical-align", "top");
                break;
            }
            case 1: {
                this.propertiesCellStyle.put("style:vertical-align", "middle");
                break;
            }
            case 2: {
                this.propertiesCellStyle.put("style:vertical-align", "bottom");
                break;
            }
            default: {
                this.propertiesCellStyle.put("style:vertical-align", null);
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setWrapText(boolean value) {
        if (value) {
            this.propertiesCellStyle.put("fo:wrap-option", "wrap");
        } else {
            this.propertiesCellStyle.put("fo:wrap-option", "no-wrap");
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setIndent(int value) {
        this.propertiesCellStyle.put("fo:padding-right", String.valueOf(value));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setShrinkToFit(boolean value) {
        this.propertiesCellStyle.put("style:shrink-to-fit", String.valueOf(value));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setRotation(Object value) {
        int v = ((Number)value).intValue();
        if (v < -90 || v > 90) {
            throw new InformException(String.format(MESSAGE_BADORIENTATION, value));
        }
        this.propertiesCellStyle.put("style:rotation-angle", String.valueOf(value));
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setBackgroundColor(Object value) {
        org.odftoolkit.odfdom.type.Color color = OdsWorkbook.parseColor(value);
        this.propertiesCellStyle.put("fo:background-color", color.toString());
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setBorderType(Object borderSide, Object borderType) {
        int side = this.parseBorderSide(borderSide);
        BorderStyle borderStyle = this.parseBorderType(borderType);
        String style = "1pt " + borderStyle.toString().toLowerCase() + " #000000";
        switch (side) {
            case 0: {
                if (!this.propertiesCellStyle.containsKey("fo:border-top")) {
                    this.element.setFoBorderTopAttribute(style);
                    this.propertiesCellStyle.put("fo:border-top", this.element.getFoBorderTopAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderTopAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderTopAttribute(oldArr[0] + " " + newArr[1] + " " + oldArr[2]);
                this.propertiesCellStyle.put("fo:border-top", this.element.getFoBorderTopAttribute());
                break;
            }
            case 1: {
                if (!this.propertiesCellStyle.containsKey("fo:border-right")) {
                    this.element.setFoBorderRightAttribute(style);
                    this.propertiesCellStyle.put("fo:border-right", this.element.getFoPaddingRightAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderRightAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderRightAttribute(oldArr[0] + " " + newArr[1] + " " + oldArr[2]);
                this.propertiesCellStyle.put("fo:border-right", this.element.getFoPaddingRightAttribute());
                break;
            }
            case 2: {
                if (!this.propertiesCellStyle.containsKey("fo:border-bottom")) {
                    this.element.setFoBorderBottomAttribute(style);
                    this.propertiesCellStyle.put("fo:border-bottom", this.element.getFoBorderBottomAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderBottomAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderBottomAttribute(oldArr[0] + " " + newArr[1] + " " + oldArr[2]);
                this.propertiesCellStyle.put("fo:border-bottom", this.element.getFoBorderBottomAttribute());
                break;
            }
            case 3: {
                if (!this.propertiesCellStyle.containsKey("fo:border-left")) {
                    this.element.setFoBorderLeftAttribute(style);
                    this.propertiesCellStyle.put("fo:border-left", this.element.getFoBorderLeftAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderLeftAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderLeftAttribute(oldArr[0] + " " + newArr[1] + " " + oldArr[2]);
                this.propertiesCellStyle.put("fo:border-left", this.element.getFoBorderLeftAttribute());
                break;
            }
            case 4: {
                if (!this.propertiesCellStyle.containsKey("fo:border")) {
                    this.element.setFoBorderAttribute(style);
                    this.propertiesCellStyle.put("fo:border", this.element.getFoBorderAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderAttribute(oldArr[0] + " " + newArr[1] + " " + oldArr[2]);
                this.propertiesCellStyle.put("fo:border", this.element.getFoBorderAttribute());
            }
        }
        return this;
    }

    @SmartScriptableObject.FunctionTag
    public OdsCellStyle setBorderColor(Object borderSide, Object borderColor) {
        int side = this.parseBorderSide(borderSide);
        org.odftoolkit.odfdom.type.Color color = OdsWorkbook.parseColor(borderColor);
        Color awtColor = color.getAWTColor();
        String hex = String.format("#%02x%02x%02x", awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        String style = "1pt none " + hex;
        switch (side) {
            case 0: {
                if (!this.propertiesCellStyle.containsKey("fo:border-top")) {
                    this.element.setFoBorderTopAttribute(style);
                    this.propertiesCellStyle.put("fo:border-top", this.element.getFoBorderTopAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderTopAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderTopAttribute(oldArr[0] + " " + oldArr[1] + " " + newArr[2]);
                this.propertiesCellStyle.put("fo:border-top", this.element.getFoBorderTopAttribute());
                break;
            }
            case 1: {
                if (!this.propertiesCellStyle.containsKey("fo:border-right")) {
                    this.element.setFoBorderRightAttribute(style);
                    this.propertiesCellStyle.put("fo:border-right", this.element.getFoBorderRightAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderRightAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderRightAttribute(oldArr[0] + " " + oldArr[1] + " " + newArr[2]);
                this.propertiesCellStyle.put("fo:border-right", this.element.getFoBorderRightAttribute());
                break;
            }
            case 2: {
                if (!this.propertiesCellStyle.containsKey("fo:border-bottom")) {
                    this.element.setFoBorderBottomAttribute(style);
                    this.propertiesCellStyle.put("fo:border-bottom", this.element.getFoBorderBottomAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderBottomAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderBottomAttribute(oldArr[0] + " " + oldArr[1] + " " + newArr[2]);
                this.propertiesCellStyle.put("fo:border-bottom", this.element.getFoBorderBottomAttribute());
                break;
            }
            case 3: {
                if (!this.propertiesCellStyle.containsKey("fo:border-left")) {
                    this.element.setFoBorderLeftAttribute(style);
                    this.propertiesCellStyle.put("fo:border-left", this.element.getFoBorderLeftAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderLeftAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderLeftAttribute(oldArr[0] + " " + oldArr[1] + " " + newArr[2]);
                this.propertiesCellStyle.put("fo:border-left", this.element.getFoBorderLeftAttribute());
                break;
            }
            case 4: {
                if (!this.propertiesCellStyle.containsKey("fo:border")) {
                    this.element.setFoBorderAttribute(style);
                    this.propertiesCellStyle.put("fo:border", this.element.getFoBorderAttribute());
                    break;
                }
                String[] oldArr = this.element.getFoBorderAttribute().split(" ");
                String[] newArr = style.split(" ");
                this.element.setFoBorderAttribute(oldArr[0] + " " + oldArr[1] + " " + newArr[2]);
                this.propertiesCellStyle.put("fo:border", this.element.getFoBorderAttribute());
            }
        }
        return this;
    }

    public Map<String, String> getPropertiesCellStyle() {
        return this.propertiesCellStyle;
    }

    private int parseBorderSide(Object value) {
        int v = ((Number)value).intValue();
        if (v < 0 || v > 4) {
            throw new InformException(String.format(MESSAGE_BADBORDERSIDE, value));
        }
        return v;
    }

    private BorderStyle parseBorderType(Object value) {
        int v = ((Number)value).intValue();
        if (v < 0 || v > 13) {
            throw new InformException(String.format(MESSAGE_BADBORDERSTYLE, value));
        }
        return BorderStyle.valueOf((short)((short)v));
    }
}

