/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.collections.Cursor;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.db.GeneratedSql;
import inform.agent.db.SearchParameters;
import inform.agent.db.SqlGenerator;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.db.types.DateTimeFormat;
import inform.agent.db.types.DateTimeInterval;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.sql.DatasourceUsage;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryDescriptor;
import inform.agent.scripts.sql.QueryGeneratedSql;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeKind;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class DataQueryNode
extends QueryNode {
    double datasourceNodeId = 0.0;
    int nodeType = 19;
    final ParametersList nodeParams = new ParametersList();

    DataQueryNode(Query query, GenericQueryNode parentNode) {
        super(query, parentNode);
        this.nodeParams.setParentScope(this);
        DataQueryNode.putConstProperty(this, "parameters", this.nodeParams);
    }

    DataQueryNode(Query query, GenericQueryNode parentNode, double filterId) throws IOException {
        this(query, parentNode);
        this.datasourceNodeId = filterId;
        this.determineNode();
    }

    @Override
    public QueryNodeKind getKind() {
        switch (this.nodeType) {
            case 49: {
                return QueryNodeKind.QUERY;
            }
            case 19: {
                return QueryNodeKind.SEARCH;
            }
        }
        return super.getKind();
    }

    private void addDate(double value, DateTimeFormat format, SearchParameters params) throws IOException, InformException {
        Calendar cal = DateTime.toCalendar(value);
        switch (format) {
            case DD: 
            case DD_MM: {
                break;
            }
            case DD_MM_YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                Date startDate = cal.getTime();
                cal.add(5, 1);
                Date endDate = cal.getTime();
                params.addDatePair(startDate, endDate);
                break;
            }
            case DD_MM_YYYY_HH_mm: {
                cal.set(13, cal.getActualMinimum(13));
                Date startDate = cal.getTime();
                cal.add(12, 1);
                cal.set(13, cal.getActualMinimum(13));
                Date endDate = cal.getTime();
                params.addDatePair(startDate, endDate);
                break;
            }
            case HH: 
            case HH_mm: 
            case HH_mm_SS: 
            case DD_MM_YYYY_HH_mm_SS: {
                params.addDate(value);
                break;
            }
            case MM_YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                Date startDate = cal.getTime();
                cal.set(5, cal.getActualMaximum(5));
                Date endDate = cal.getTime();
                params.addDatePair(startDate, endDate);
                break;
            }
            case YYYY: {
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                cal.set(2, cal.getActualMinimum(2));
                Date startDate = cal.getTime();
                cal.set(2, cal.getActualMaximum(2));
                cal.set(5, cal.getActualMaximum(5));
                Date endDate = cal.getTime();
                params.addDatePair(startDate, endDate);
                break;
            }
            case QUARTER_YYYY: {
                Date startDate;
                cal.set(13, cal.getActualMinimum(13));
                cal.set(12, cal.getActualMinimum(12));
                cal.set(11, cal.getActualMinimum(11));
                cal.set(5, cal.getActualMinimum(5));
                int month = cal.get(2);
                if (month <= 2) {
                    cal.set(2, 0);
                    startDate = cal.getTime();
                    cal.set(2, 3);
                } else if (month <= 5) {
                    cal.set(2, 3);
                    startDate = cal.getTime();
                    cal.set(2, 6);
                } else if (month <= 8) {
                    cal.set(2, 6);
                    startDate = cal.getTime();
                    cal.set(2, 9);
                } else if (month <= 11) {
                    cal.set(2, 9);
                    startDate = cal.getTime();
                    cal.add(2, 3);
                } else {
                    this.query.throwError("\u0421\u0442\u0440\u0430\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430: " + cal.getTime().toString());
                    startDate = null;
                }
                cal.set(5, cal.getActualMaximum(5));
                Date endDate = cal.getTime();
                params.addDatePair(startDate, endDate);
            }
        }
    }

    private void addParamValue(Parameter p, SearchParameters params) throws IOException, InformException {
        Object v = p.getRawValue();
        if (v == null) {
            params.addNull();
        } else {
            switch (p.getDataType()) {
                case BLOB: {
                    params.addBlob(p.getAsBinary());
                    break;
                }
                case DIRECTORY: 
                case FLOAT: 
                case INTERVAL: 
                case METATREE_NODE: 
                case PRIMARY_KEY: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addDouble(ValueCaster.toDouble(o));
                        }
                        break;
                    }
                    params.addDouble(ValueCaster.toDouble(v));
                    break;
                }
                case BOOLEAN: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addInt(ValueCaster.toBoolean(o) != false ? 1 : 0);
                        }
                        break;
                    }
                    params.addInt(ValueCaster.toBoolean(v) != false ? 1 : 0);
                    break;
                }
                case DATE_TIME: {
                    if (v instanceof DateTimeInterval) {
                        params.addDatePair(((DateTimeInterval)v).getStartDate(), ((DateTimeInterval)v).getEndDate());
                        break;
                    }
                    DateTimeFormat format = DateTimeFormat.getFormatById(p.getFormatId());
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            this.addDate(ValueCaster.toDouble(o), format, params);
                        }
                        break;
                    }
                    this.addDate(ValueCaster.toDouble(v), format, params);
                    break;
                }
                case INTEGER: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addInt(ValueCaster.toInt(o));
                        }
                        break;
                    }
                    params.addInt(ValueCaster.toInt(v));
                    break;
                }
                case BIG_NUMBER: 
                case STRING: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addString(ValueCaster.toString(o));
                        }
                        break;
                    }
                    params.addString(ValueCaster.toString(v));
                    break;
                }
                case UNICODE: {
                    if (v instanceof Object[]) {
                        for (Object o : (Object[])v) {
                            if (o == null) {
                                params.addNull();
                                continue;
                            }
                            params.addUnicode(ValueCaster.toString(o));
                        }
                        break;
                    }
                    params.addUnicode(ValueCaster.toString(v));
                }
            }
        }
    }

    private void generateSearch(StringBuilder sql, SqlBuilder.GenerateParams generateParams) throws IOException, InformException {
        GeneratedSql generatedSql;
        assert (this.nodeType == 19);
        SqlGenerator sqlGen = new SqlGenerator(this.query.getHost(), Core.serverTimeZoneHost);
        for (Cursor.Integer returnedField : this.returnedFields) {
            sqlGen.addUsedField(returnedField.value);
        }
        sqlGen.setTableId(this.tableNodeId);
        sqlGen.setSearchId(this.datasourceNodeId);
        byte[] searchContent = MtdEngine.getNodeContent(this.datasourceNodeId);
        SqlGenerator.Method generationMethod = SqlGenerator.extractSearchGenerationMethod(searchContent);
        sqlGen.setSearchContent(searchContent);
        sqlGen.setInlineParams(this.query.isInlineParams());
        sqlGen.setDebugMode(this.query.getDebugBuilder() != null);
        sqlGen.setConstantsContent(this.query.getConstansContent(), this.query.getHost());
        if (this.isProxyNode && this.query.getSortFields() != null) {
            sqlGen.getSortFields().addAll(this.query.getSortFields().fields());
        }
        if (generateParams != null) {
            sqlGen.setCustomSubjectFieldId(generateParams.subjectFieldId);
        }
        SearchParameters params = sqlGen.getParameters();
        if (this.nodeParams != null) {
            this.nodeParams.applyParamBinding(this.query.getInputParameters());
            for (Parameter p : this.nodeParams.values()) {
                if (p.getDatasourceBinding() != 0 && p.getFieldBinding() != 0) {
                    this.throwNodeError("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u043f\u043e\u043b\u044f \u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043f\u043e\u0438\u0441\u043a\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
                }
                p.setParamBinding(0);
            }
            for (Parameter p : this.nodeParams.values()) {
                if (!p.isModified()) continue;
                params.addParameter(p.getId());
                if (p.getIsIgnored()) {
                    params.setIgnored();
                    continue;
                }
                this.addParamValue(p, params);
            }
        }
        if ((generatedSql = sqlGen.getGeneratedSql(generationMethod, -500)).isHasError()) {
            this.query.throwError(generatedSql.getError(), generatedSql.getErrorDetailing());
        }
        sql.append(generatedSql.getSqlText());
        this.query.setSortingGeneration(generatedSql.getSortingGeneration());
        this.query.getSqlParameters().addFromStream(generatedSql.getParamersReader());
    }

    private void generateQuery(StringBuilder sql, SqlBuilder.GenerateParams generateParams) throws Exception {
        this.nodeParams.applyParamBinding(this.query.getInputParameters());
        for (Parameter p : this.nodeParams.values()) {
            p.setParamBinding(0);
        }
        assert (this.nodeType == 49);
        QueryDescriptor descriptor = new QueryDescriptor(this.query, this.returnedFields, this.nodeParams, this.getDescription(), this.getEntryId(), this.query.getNullSortKind());
        QueryGeneratedSql generatedSql = Query.generateSqlText(this.datasourceNodeId, this.query.getHost(), descriptor, generateParams);
        sql.append(generatedSql.getSqlText());
        this.query.getSqlParameters().addFrom(generatedSql.getSqlParameters());
    }

    public void getDatasourceUsageBindedToParam(DatasourceUsage usage) {
        for (Parameter p : this.nodeParams.values()) {
            int entryId = p.getDatasourceBinding();
            if (entryId == 0) continue;
            usage.add(entryId, p.getFieldBinding());
        }
    }

    @Override
    public void generateSelect(StringBuilder sql, SqlBuilder.GenerateParams generateParams) throws Exception {
        this.nodeParams.applyParamBinding(this.query.getInputParameters());
        for (Parameter p : this.nodeParams.values()) {
            int entryId = p.getDatasourceBinding();
            if (entryId == 0) continue;
            GenericQueryNode node = this.query.getNodeById(entryId);
            p.setBindedToQueryNode((QueryNode)node);
        }
        switch (this.nodeType) {
            case 49: {
                this.generateQuery(sql, generateParams);
                break;
            }
            case 19: {
                this.generateSearch(sql, generateParams);
                break;
            }
            default: {
                super.generateSelect(sql, generateParams);
            }
        }
    }

    @Override
    public void generateRaw(StringBuilder sql, IntegerSet fieldsUsage, SqlBuilder.GenerateParams generateParams) throws Exception {
        switch (this.nodeType) {
            case 49: {
                sql.append('(');
                this.generateQuery(sql, generateParams);
                sql.append(')');
                break;
            }
            case 19: {
                sql.append('(');
                this.generateSearch(sql, generateParams);
                sql.append(')');
                break;
            }
            default: {
                super.generateRaw(sql, fieldsUsage, generateParams);
            }
        }
    }

    protected void determineNode() throws InformException, IOException {
        Node nodeInfo = MtdEngine.getNode(this.datasourceNodeId);
        if (nodeInfo == null) {
            this.throwNodeError("\u0423\u0437\u0435\u043b \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        } else {
            this.nodeType = nodeInfo.getType();
            this.tableNodeId = 0.0;
            switch (nodeInfo.getType()) {
                case 19: 
                case 49: {
                    TaggedReader reader = new TaggedReader(new ByteArrayInputStream(MtdEngine.getNodeContent(this.datasourceNodeId)));
                    while (reader.getNextTag() != 0) {
                        switch (reader.getCurrentTag()) {
                            case 1: {
                                this.tableNodeId = reader.getNodeID();
                                break;
                            }
                            case 15: {
                                reader.skipInt();
                                break;
                            }
                            case 153: {
                                reader.skip();
                                TaggedReader stream = new TaggedReader(reader.getSubStream());
                                this.nodeParams.load(this.query.getConstants(), stream, Core.serverTimeZoneHost);
                            }
                        }
                    }
                    break;
                }
                case 12: {
                    this.tableNodeId = this.datasourceNodeId;
                    break;
                }
                default: {
                    this.throwNodeError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430: \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043f\u043e\u0438\u0441\u043a \u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441");
                }
            }
            this.initMetadata();
        }
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws InformException, IOException {
        switch (tag) {
            case 3: {
                this.datasourceNodeId = reader.getNodeID();
                this.determineNode();
                break;
            }
            case 13: {
                if (this.nodeParams == null) break;
                reader.skip();
                TaggedReader stream = new TaggedReader(reader.getSubStream());
                this.nodeParams.load(this.query.getConstants(), stream, Core.serverTimeZoneHost, true);
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }

    @Override
    public void writeGetTableRecordsRefsContent(TaggedWriter out) throws InformException, IOException {
        super.writeGetTableRecordsRefsContent(out);
        if (this.getKind() == QueryNodeKind.QUERY) {
            if (this.nodeParams != null) {
                ParametersList inputParams = this.getQuery().getInputParameters();
                ByteArrayOutputStream bindContent = new ByteArrayOutputStream();
                TaggedWriter bindOut = new TaggedWriter(bindContent);
                for (Parameter param : this.nodeParams.values()) {
                    Parameter bind;
                    int bindId;
                    if (inputParams != null && (bindId = param.getParamBinding()) != 0 && (bind = inputParams.get(bindId)) != null) {
                        param.assignParameter(bind);
                    }
                    this.nodeParams.storeParameter(bindOut, param);
                }
                bindOut.flush();
                out.putRaw(36, bindContent);
            }
        } else if (this.datasourceNodeId != 0.0) {
            out.putDouble(31, this.datasourceNodeId);
            out.putRaw(14, MtdEngine.getNodeContent(this.datasourceNodeId));
            if (this.nodeParams != null) {
                ParametersList inputParams = this.getQuery().getInputParameters();
                SearchParameters parameters = new SearchParameters();
                Iterator<Parameter> iterator = this.nodeParams.values().iterator();
                while (iterator.hasNext()) {
                    Parameter bind;
                    int bindId;
                    Parameter param;
                    Parameter p = param = iterator.next();
                    parameters.addParameter(p.getId());
                    if (inputParams != null && (bindId = p.getParamBinding()) != 0 && (bind = inputParams.get(bindId)) != null) {
                        p = bind;
                    }
                    if (p.getIsIgnored()) {
                        parameters.setIgnored();
                    } else {
                        this.addParamValue(p, parameters);
                    }
                    parameters.storeAs(out);
                }
            }
        }
    }

    @Override
    @SmartScriptableObject.PropertyTag
    public String getCaption() {
        if (this.description == null) {
            this.description = this.metadata == null ? "" : MtdEngine.getNodeName(this.datasourceNodeId);
        }
        return this.description;
    }

    @Override
    @SmartScriptableObject.PropertyTag
    public double getFilterID() {
        return this.datasourceNodeId;
    }
}

