/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.agent.db.types.SqlDataType;

public class FieldBind {
    private int fieldId;
    private int bindedParam;
    private SqlDataType valueType;
    private double bindedNumber;
    private String bindedText;
    private int bindedDatasource;
    private int bindedField;
    private boolean isNull = false;
    BindType type = BindType.NOBIND;

    FieldBind(int fieldId) {
        this.fieldId = fieldId;
    }

    public int getBindedDatasource() {
        return this.bindedDatasource;
    }

    public int getBindedField() {
        return this.bindedField;
    }

    public double getBindedNumber() {
        return this.bindedNumber;
    }

    public int getBindedParam() {
        return this.bindedParam;
    }

    public String getBindedString() {
        return this.bindedText;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public SqlDataType getValueType() {
        return this.valueType;
    }

    public BindType getBindType() {
        return this.type;
    }

    public void bindField(int bindedField) {
        this.bindedField = bindedField;
        this.type = BindType.FIELD;
    }

    public void setBindedDatasource(int entryId) {
        this.bindedDatasource = entryId;
    }

    public void bindParam(int paramId) {
        this.bindedParam = paramId;
        this.type = BindType.PARAM;
    }

    public void bindInt(double value) {
        this.bindedNumber = value;
        this.valueType = SqlDataType.INTEGER;
        this.type = BindType.VALUE;
    }

    public void bindDouble(double value) {
        this.bindedNumber = value;
        this.valueType = SqlDataType.DOUBLE;
        this.type = BindType.VALUE;
    }

    public void bindDate(double value) {
        this.bindedNumber = value;
        this.valueType = SqlDataType.DATE_TIME;
        this.type = BindType.VALUE;
    }

    public void bindAnsiString(String value) {
        this.bindedText = value;
        this.valueType = SqlDataType.STRING;
        this.type = BindType.VALUE;
    }

    public void bindUTFString(String value) {
        this.bindedText = value;
        this.valueType = SqlDataType.STRING;
        this.type = BindType.VALUE;
    }

    public void setNull() {
        this.isNull = true;
        this.type = BindType.VALUE;
    }

    public void setFieldId(int fieldId) {
        this.fieldId = fieldId;
    }

    public static enum BindType {
        NOBIND,
        FIELD,
        PARAM,
        VALUE;

    }
}

