/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.scripts.sql.FieldBind;
import inform.agent.scripts.sql.GenericQueryNode;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FieldBindList
implements Iterable<FieldBind> {
    private static final int TAG_FS_BIND_FLD_ID = 1;
    private static final int TAG_FS_BIND_FLD_PARAM = 2;
    private static final int TAG_FS_BIND_FLD_FIELD = 4;
    private static final int TAG_FS_BIND_FLD_VALUE_INT = 7;
    private static final int TAG_FS_BIND_FLD_VALUE_DOUBLE = 8;
    private static final int TAG_FS_BIND_FLD_VALUE_STRING = 9;
    private static final int TAG_FS_BIND_FLD_VALUE_DATATIME = 10;
    private static final int TAG_FS_BIND_FLD_NULL = 11;
    private static final int TAG_FS_BIND_FLD_FIELD_DATASOURCE = 12;
    private static final int TAG_FS_BIND_DONT_ADD_NULL_BINDS = 13;
    final ArrayList<FieldBind> binds = new ArrayList();
    private boolean addNullBinds = true;

    @Override
    public Iterator<FieldBind> iterator() {
        return this.binds.iterator();
    }

    public boolean isAddNullBinds() {
        return this.addNullBinds;
    }

    public void Load(TaggedReader reader) throws IOException, TaggedReaderException {
        FieldBind bind = new FieldBind(0);
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    int id = reader.getInt();
                    bind = new FieldBind(id);
                    this.binds.add(bind);
                    break;
                }
                case 2: {
                    int id = reader.getInt();
                    bind.bindParam(id);
                    break;
                }
                case 4: {
                    int id = reader.getInt();
                    bind.bindField(id);
                    break;
                }
                case 12: {
                    int id = reader.getInt(12);
                    bind.setBindedDatasource(id);
                    break;
                }
                case 11: {
                    bind.setNull();
                    break;
                }
                case 7: {
                    bind.bindInt(reader.getInt());
                    break;
                }
                case 8: {
                    bind.bindDouble(reader.getDouble());
                    break;
                }
                case 10: {
                    bind.bindDate(reader.getDouble());
                    break;
                }
                case 9: {
                    bind.bindAnsiString(reader.getAnsi());
                    break;
                }
                case 13: {
                    this.addNullBinds = false;
                }
            }
        }
    }

    public void generateSql(Query query, QueryNode node, StringBuilder sql) throws InformException {
        boolean addAnd = false;
        block11: for (FieldBind bind : this.binds) {
            if (addAnd) {
                sql.append(" AND ");
            }
            block0 : switch (bind.type) {
                case FIELD: {
                    GenericQueryNode parent = query.getNodeById(bind.getBindedDatasource());
                    parent.generateFieldAlias(sql, bind.getBindedField(), false);
                    break;
                }
                case PARAM: {
                    query.generateParameter(bind.getBindedParam(), sql);
                    break;
                }
                case VALUE: {
                    if (bind.getIsNull()) {
                        node.generateFieldAlias(sql, bind.getFieldId(), false);
                        sql.append(" IS NULL");
                        addAnd = true;
                        continue block11;
                    }
                    switch (bind.getValueType()) {
                        case STRING: {
                            query.generateAnsiStringValueSql(bind.getBindedString(), sql);
                            break block0;
                        }
                        case DATE_TIME: {
                            query.generateDateValueSql(bind.getBindedNumber(), sql);
                            break block0;
                        }
                        case DOUBLE: {
                            query.generateDoubleValueSql(bind.getBindedNumber(), sql);
                            break block0;
                        }
                        case INTEGER: {
                            query.generateIntValueSql((int)bind.getBindedNumber(), sql);
                            break block0;
                        }
                    }
                    continue block11;
                }
                default: {
                    continue block11;
                }
            }
            sql.append('=');
            node.generateFieldAlias(sql, bind.getFieldId(), false);
            addAnd = true;
        }
    }
}

