/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.adt.collections.IntegerSet;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryNode;
import inform.agent.scripts.sql.QueryNodeKind;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.util.ArrayList;

public abstract class GenericQueryNode
extends SmartScriptableObject
implements IntegerHash.Entry {
    private static int maxEntryId = 0;
    private int entryId = 0;
    protected String description = null;
    protected String scriptName = null;
    protected final ArrayList<GenericQueryNode> children = new ArrayList();
    protected GenericQueryNode parent;
    protected Query query;
    protected final int aliasNo;

    GenericQueryNode(Query query, GenericQueryNode parentNode) {
        this.query = query;
        this.parent = parentNode;
        this.aliasNo = query.nextAlias();
    }

    public Query getQuery() {
        return this.query;
    }

    protected void enumFromTablesThis(ArrayList<QueryNode> joins, ArrayList<QueryNode> nonjoins) {
    }

    public void enumFromTables(ArrayList<QueryNode> joins, ArrayList<QueryNode> nonjoins) {
        this.enumFromTablesThis(joins, nonjoins);
        for (GenericQueryNode child : this.children) {
            child.enumFromTables(joins, nonjoins);
        }
    }

    @Override
    public String getClassName() {
        return "QueryNode";
    }

    public int getEntryId() {
        return this.entryId;
    }

    public int getParentEntryId() {
        return this.parent == null ? 0 : this.parent.entryId;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract QueryNodeKind getKind();

    public abstract void internalGenerateAlias(StringBuilder var1);

    public abstract void generateAlias(StringBuilder var1, boolean var2) throws InformException;

    public abstract void generateRaw(StringBuilder var1, IntegerSet var2, SqlBuilder.GenerateParams var3) throws Exception;

    public abstract void generateJoin(StringBuilder var1, IntegerSet var2) throws Exception;

    public abstract void generateChildAlias(StringBuilder var1, String var2) throws InformException;

    public abstract void generateFieldAlias(StringBuilder var1, int var2, boolean var3) throws InformException;

    public abstract FieldDescriptor getFieldByName(String var1);

    public void throwNodeError(String error) throws InformException {
        StringBuilder msg = new StringBuilder();
        msg.append("(id: ");
        msg.append(this.entryId);
        msg.append(", \u0437\u0430\u0433\u043b\u043e\u0432\u043e\u043a: ");
        msg.append(this.description);
        msg.append(", \u0438\u043c\u044f: ");
        msg.append(this.scriptName);
        msg.append(')');
        this.query.throwDetailingError(error, msg);
    }

    public void getDetailing(StringBuilder detailing) {
        detailing.append(this.description);
        detailing.append("(id: ");
        detailing.append(this.entryId);
        detailing.append(", \u0438\u043c\u044f: ");
        detailing.append(this.scriptName);
        detailing.append(')');
    }

    public void throwDetailingError(String error, StringBuilder detailing) throws InformException {
        detailing.append("(id: ");
        detailing.append(this.entryId);
        detailing.append(", \u0437\u0430\u0433\u043b\u043e\u0432\u043e\u043a: ");
        detailing.append(this.description);
        detailing.append(", \u0438\u043c\u044f: ");
        detailing.append(this.scriptName);
        detailing.append(')');
        this.query.throwDetailingError(error, detailing);
    }

    protected void loadChildren(TaggedReader reader) throws IOException, InformException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    GenericQueryNode node;
                    int nodeKindId = reader.getInt();
                    QueryNodeKind kind = QueryNodeKind.fromInt(nodeKindId);
                    if (kind == null || (node = kind.create(this.query, this)) == null) break;
                    this.children.add(node);
                    node.load(new TaggedReader(reader.getSubStream()));
                    this.query.registerNode(node);
                }
            }
        }
    }

    protected void loadTag(int tag, TaggedReader reader) throws InformException, IOException {
        switch (tag) {
            case 1: {
                this.entryId = reader.getInt();
                if (maxEntryId < this.entryId) {
                    maxEntryId = this.entryId;
                }
                GenericQueryNode.putConstProperty(this, "id", this.entryId);
                break;
            }
            case 2: {
                reader.skip();
                this.loadChildren(new TaggedReader(reader.getSubStream()));
                break;
            }
            case 6: {
                this.description = reader.getAnsi();
                break;
            }
            case 7: {
                this.scriptName = reader.getAnsi();
                GenericQueryNode.putConstProperty(this, "name", this.scriptName);
            }
        }
    }

    public void load(TaggedReader reader) throws IOException, InformException {
        while (reader.getNextTag() != 0) {
            this.loadTag(reader.getCurrentTag(), reader);
        }
    }

    protected void afterLoad() {
        if (this.description == null) {
            this.description = "";
        }
        if (this.scriptName == null) {
            this.scriptName = "";
        }
    }

    @Override
    public int key() {
        return this.entryId;
    }

    protected void generateEntryID() {
        this.entryId = ++maxEntryId;
    }

    void internalSetEntryID(int id) {
        this.entryId = id;
        if (maxEntryId < this.entryId) {
            maxEntryId = this.entryId;
        }
    }

    public abstract void writeGetTableRecordsRefsContent(TaggedWriter var1) throws InformException, IOException;
}

