/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.collections.ArrayMap;
import inform.agent.db.sql.ProcedureQueryBuilder;
import inform.agent.db.sql.ProxyQueryBuilder;
import inform.agent.db.sql.QueryInSqlBuilder;
import inform.agent.db.sql.SimpleSqlBuilder;
import inform.agent.db.sql.SqlBuilder;
import inform.agent.scripts.sql.Query;

public enum QueryKind {
    SIMPLE(0){

        @Override
        public SqlBuilder createSqlBuilder(Query query) {
            return new SimpleSqlBuilder(query);
        }
    }
    ,
    ADVANCED(1){

        @Override
        public SqlBuilder createSqlBuilder(Query query) {
            return new SimpleSqlBuilder(query);
        }
    }
    ,
    SQL(2){

        @Override
        public SqlBuilder createSqlBuilder(Query query) {
            return new QueryInSqlBuilder(query);
        }
    }
    ,
    PROXY(3){

        @Override
        public SqlBuilder createSqlBuilder(Query query) {
            return new ProxyQueryBuilder(query);
        }
    }
    ,
    PROCEDURE(4){

        @Override
        public SqlBuilder createSqlBuilder(Query query) {
            return new ProcedureQueryBuilder(query);
        }
    };

    private final int typeId;
    static final ArrayMap<QueryKind> kindMap;

    private QueryKind(int value) {
        this.typeId = value;
    }

    public int toInt() {
        return this.typeId;
    }

    public static QueryKind fromInt(int typeId) {
        return kindMap.get(typeId);
    }

    public SqlBuilder createSqlBuilder(Query query) {
        return null;
    }

    static {
        kindMap = new ArrayMap<QueryKind>(QueryKind.values());
    }
}

