/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.types.DataType;
import inform.agent.db.types.SqlDataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.sql.QueryParameter;
import java.io.IOException;
import java.util.ArrayList;

public class QueryParameterList {
    private ArrayList<QueryParameter> list = new ArrayList();

    public ArrayList<QueryParameter> items() {
        return this.list;
    }

    public void addBool(boolean value) {
        this.list.add(new QueryParameter(value));
    }

    public void addInt(int value) {
        this.list.add(new QueryParameter(value, SqlDataType.INTEGER));
    }

    public void addDouble(double value) {
        this.list.add(new QueryParameter(value, SqlDataType.DOUBLE));
    }

    public void addDate(double value) {
        this.list.add(new QueryParameter(value, SqlDataType.DATE_TIME));
    }

    public void addAnsiString(String value) {
        this.list.add(new QueryParameter(value, SqlDataType.STRING));
    }

    public void addUTFString(String value) {
        this.list.add(new QueryParameter(value, SqlDataType.UNICODE));
    }

    public void addNull(SqlDataType type) {
        this.list.add(new QueryParameter(type));
    }

    public void addParamValue(Object value, DataType dataType) throws InformException {
        SqlDataType type = SqlDataType.get(dataType);
        if (value instanceof Object[]) {
            for (Object v : (Object[])value) {
                this.addParamValue(v, dataType);
            }
        } else if (value == null) {
            this.addNull(type);
        } else {
            value = ValueCaster.getCastedValue(dataType, value);
            switch (type) {
                case BOOLEAN: {
                    if (value instanceof Boolean) {
                        this.addBool((Boolean)value);
                        break;
                    }
                    this.addBool(((Number)value).intValue() != 0);
                    break;
                }
                case INTEGER: {
                    assert (value instanceof Number || value instanceof Boolean);
                    if (value instanceof Boolean) {
                        this.addBool((Boolean)value);
                        break;
                    }
                    this.addInt(((Number)value).intValue());
                    break;
                }
                case DOUBLE: {
                    assert (value instanceof Number);
                    this.addDouble(((Number)value).doubleValue());
                    break;
                }
                case DATE_TIME: {
                    assert (value instanceof Number);
                    this.addDate(((Number)value).doubleValue());
                    break;
                }
                case STRING: {
                    assert (value instanceof String);
                    this.addAnsiString((String)value);
                    break;
                }
                case UNICODE: {
                    assert (value instanceof String);
                    this.addUTFString((String)value);
                    break;
                }
                default: {
                    this.addNull(type);
                }
            }
        }
    }

    public void addParam(Parameter param) throws InformException {
        this.addParamValue(param.getRawValue(), param.getDataType());
    }

    public void addFrom(QueryParameterList params) {
        for (QueryParameter p : params.items()) {
            this.list.add(p);
        }
    }

    public void addFromStream(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    this.addNull(SqlDataType.UNSUPPORTED);
                    break;
                }
                case 8: {
                    this.addBool(reader.getInt() != 0);
                    break;
                }
                case 2: {
                    this.addInt(reader.getInt());
                    break;
                }
                case 3: {
                    this.addDouble(reader.getDouble());
                    break;
                }
                case 4: {
                    this.addAnsiString(reader.getAnsi());
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.addDate(reader.getDouble());
                    break;
                }
                case 7: {
                    this.addAnsiString(reader.getUnicode());
                }
            }
        }
    }

    public void getLog(StringBuilder log) {
        if (this.list.isEmpty()) {
            return;
        }
        int index = 1;
        int comma = 123;
        for (QueryParameter p : this.list) {
            log.append((char)comma).append(PreparedStatement.sqlDataType2char(p.getType())).append(index).append('@');
            p.getLog(log);
            comma = 44;
            ++index;
        }
        log.append('}');
    }
}

