/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.sql.expr.fn;

import inform.agent.db.connect.DatabaseCaps;
import inform.agent.expr.Term;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.expr.cnd.QueryEvaluator;
import inform.agent.scripts.sql.expr.fn.OneArgFunctionEvaluator;

public class SQLDateExtractEvaluator
extends OneArgFunctionEvaluator {
    public SQLDateExtractEvaluator(Term term) {
        super(term);
    }

    @Override
    public void generate(StringBuilder sql, Query query) throws Exception {
        if (this.isIgnored()) {
            return;
        }
        DatabaseCaps caps = query.getDatabaseCaps();
        switch (this.term.getToken()) {
            case functionDayOf: {
                sql.append(caps.function(0));
                break;
            }
            case functionMonthOf: {
                sql.append(caps.function(1));
                break;
            }
            case functionQuarterOf: {
                sql.append("(case ");
                sql.append(caps.function(1));
                break;
            }
            case functionYearOf: {
                sql.append(caps.function(2));
                break;
            }
            case functionHourOf: {
                sql.append(caps.function(3));
                break;
            }
            case functionMinuteOf: {
                sql.append(caps.function(4));
                break;
            }
            case functionSecondOf: {
                sql.append(caps.function(5));
                break;
            }
            case functionDateOf: {
                sql.append(caps.function(6));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        for (QueryEvaluator arg : this.arguments) {
            if (arg.isIgnored()) continue;
            arg.generate(sql, query);
            break;
        }
        switch (this.term.getToken()) {
            case functionDayOf: {
                sql.append(caps.functionSuffix(0));
                break;
            }
            case functionMonthOf: {
                sql.append(caps.functionSuffix(1));
                break;
            }
            case functionQuarterOf: {
                sql.append(caps.functionSuffix(1));
                sql.append(" WHEN  1 THEN 1 WHEN  2 THEN 1 WHEN  3 THEN 1");
                sql.append(" WHEN  4 THEN 2 WHEN  5 THEN 2 WHEN  6 THEN 2");
                sql.append(" WHEN  7 THEN 3 WHEN  8 THEN 3 WHEN  9 THEN 3");
                sql.append(" WHEN 10 THEN 4 WHEN 11 THEN 4 WHEN 12 THEN 4");
                sql.append(" ELSE null END)");
                break;
            }
            case functionYearOf: {
                sql.append(caps.functionSuffix(2));
                break;
            }
            case functionHourOf: {
                sql.append(caps.functionSuffix(3));
                break;
            }
            case functionMinuteOf: {
                sql.append(caps.functionSuffix(4));
                break;
            }
            case functionSecondOf: {
                sql.append(caps.functionSuffix(5));
                break;
            }
            case functionDateOf: {
                sql.append(caps.functionSuffix(6));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

