/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.stat;

import inform.adt.collections.DoubleHash;
import inform.agent.scripts.stat.DataNodeProfile;
import inform.agent.scripts.stat.ProfileItem;

public class DirectoryProfile
extends ProfileItem
implements DoubleHash.Entry {
    private final double nodeId;
    private final DataNodeProfile nodeStat;

    public DirectoryProfile(DataNodeProfile nodeStat) {
        this.nodeId = nodeStat.getNodeId();
        this.nodeStat = nodeStat;
    }

    @Override
    public double key() {
        return this.nodeId;
    }

    @Override
    public void getProfile(StringBuilder profile) {
        if (this.recordCount == 0 && this.accessCount == 0 && this.requestCount == 0L && this.requestTime == 0L) {
            return;
        }
        profile.append("      Directory (: ").append((long)this.nodeId).append("):\n");
        super.getProfile(profile);
    }

    @Override
    public void addAccessCount() {
        super.addAccessCount();
        this.nodeStat.addAccessCount();
    }

    @Override
    public void addRecordCount(int recordCount) {
        super.addRecordCount(recordCount);
        this.nodeStat.addRecordCount(recordCount);
    }

    @Override
    public void addRequestCount() {
        super.addRequestCount();
        this.nodeStat.addRequestCount();
    }

    @Override
    public void addRequestTime(long requestTime) {
        super.addRequestTime(requestTime);
        this.nodeStat.addRequestTime(requestTime);
    }

    @Override
    public void incRecordCount() {
        super.incRecordCount();
        this.nodeStat.incRecordCount();
    }
}

