/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.util;

import inform.adt.DateTime;
import inform.adt.NumberConverter;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DataRow;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.connect.BlobStream;
import inform.agent.db.connect.ResultSet;
import inform.agent.db.connect.ResultSetPostProcess;
import inform.agent.db.types.Geometry;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableHost;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.util.PostProcessRecord;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class QueryPostProcess
extends ServerSideExecutable
implements ResultSetPostProcess {
    private final Context context;
    private final Scriptable toplevelScope;
    private final Query query;
    private int shift;
    private PostProcessRecord record = null;
    private DataRow row = null;
    private boolean isNull = false;
    private final int nullSortKind;

    public QueryPostProcess(SSContext parentContext, Query query, int nullSortKind, Context context, ServerSideHost ssHost, AbstractConnectionManager dbManager) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        super(parentContext, 7, query.getNodeId(), ssHost, dbManager, null);
        if (this.ssContext != null) {
            this.ssContext.nodeId = this.nodeID;
            this.ssContext.script = "query";
        }
        this.query = query;
        this.context = context;
        this.nullSortKind = nullSortKind;
        this.toplevelScope = ScriptableRequest.createTopLevelScope(context, this, ssHost, dbManager);
        if (ssHost instanceof ScriptableHost) {
            ScriptableHost scriptableHost = (ScriptableHost)((Object)ssHost);
            scriptableHost.setTopLevelScope(this.toplevelScope);
            scriptableHost.setConstants(query.getConstants());
        }
        this.setParentScope(this.toplevelScope);
        this.parameters.attachParams(query.getInputParameters());
    }

    @Override
    public void setResultSet(ResultSet resultSet, boolean hasPrimaryKey) throws SQLException {
        this.record = new PostProcessRecord(this, this.nullSortKind);
        this.record.setParentScope(this.toplevelScope);
        this.record.setQuery(this.query);
        this.record.setResultSet(resultSet, hasPrimaryKey);
        this.shift = this.record.getResultRowset().isHasRecordIdField() ? 2 : 1;
        QueryPostProcess.putConstProperty(this, "result", this.record);
        this.context.evaluateString(this, this.query.getScriptText(), this.query.toLogString(), 1, null);
    }

    @Override
    public boolean next() throws IOException, SQLException {
        this.row = this.record.next();
        ScriptableObject.callMethod(this, this.query.getOnGetData(), null);
        return this.record.getVisible();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.record.getFields().size() + this.shift - 1;
    }

    @Override
    public String getColumnLabel(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            FieldDescriptor d = this.record.getRecordIdField();
            if (d == null) {
                return null;
            }
            return d.getRawName();
        }
        DatasourceField field = this.record.getFields().getByIndex(idx);
        return field.getDescriptor().getRawName();
    }

    @Override
    public boolean getBoolean(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return this.row.getId() != 0.0;
        }
        this.isNull = this.row.getNullFlag(idx);
        return this.row.getNumeric(idx) != 0.0;
    }

    @Override
    public int getInt(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return (int)this.row.getId();
        }
        this.isNull = this.row.getNullFlag(idx);
        return (int)this.row.getNumeric(idx);
    }

    @Override
    public long getLong(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return (long)this.row.getId();
        }
        this.isNull = this.row.getNullFlag(idx);
        return (long)this.row.getNumeric(idx);
    }

    @Override
    public double getDouble(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return this.row.getId();
        }
        this.isNull = this.row.getNullFlag(idx);
        return this.row.getNumeric(idx);
    }

    @Override
    public Timestamp getTimestamp(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return new Timestamp(DateTime.toUnixTime(this.row.getId()));
        }
        this.isNull = this.row.getNullFlag(idx);
        if (this.isNull) {
            return null;
        }
        return new Timestamp(DateTime.toUnixTime(this.row.getNumeric(idx)));
    }

    @Override
    public String getString(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return NumberConverter.doubleToString(this.row.getId());
        }
        this.isNull = this.row.getNullFlag(idx);
        if (this.isNull) {
            return null;
        }
        return ValueCaster.toString(this.row.getComplex(idx));
    }

    @Override
    public Geometry getGeometry(int idx) throws SQLException {
        this.isNull = true;
        return null;
    }

    @Override
    public byte[] getBlobBytes(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = true;
            return null;
        }
        this.isNull = this.row.getNullFlag(idx);
        if (this.isNull) {
            return null;
        }
        return ValueCaster.toBytes(this.row.getComplex(idx));
    }

    @Override
    public BlobStream getBlobStream(int idx) throws SQLException {
        this.isNull = true;
        return null;
    }

    @Override
    public double getDateTime(int idx) throws SQLException {
        if ((idx -= this.shift) < 0) {
            this.isNull = false;
            return this.row.getId();
        }
        this.isNull = this.row.getNullFlag(idx);
        return this.row.getNumeric(idx);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.isNull;
    }

    @Override
    public int getAsInteger(int colIdx) throws SQLException {
        return this.getInt(colIdx);
    }

    @Override
    public double getAsDouble(int colIdx) throws SQLException {
        return this.getDouble(colIdx);
    }
}

