/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.zip;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.common.SmartScriptableObject;
import java.util.zip.ZipEntry;

public class ZipWriterEntry
extends SmartScriptableObject {
    protected ZipEntry _entry;
    protected boolean _canModified;

    public ZipWriterEntry(ZipEntry entry) {
        this._entry = entry;
        this._canModified = true;
    }

    @Override
    public String getClassName() {
        return "ZipWriterEntry";
    }

    @SmartScriptableObject.PropertyTag
    public String getcomment() {
        return this._entry.getComment();
    }

    public void setcomment(String comment) throws InformException {
        if (!this._canModified) {
            throw new InformException("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u043f\u043e\u0441\u043b\u0435 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432 \u0432 \u0430\u0440\u0445\u0438\u0432!");
        }
        this._entry.setComment(comment);
    }

    @SmartScriptableObject.PropertyTag
    public String getname() {
        return this._entry.getName();
    }

    @SmartScriptableObject.PropertyTag
    public long getcompressedSize() {
        return this._entry.getCompressedSize();
    }

    @SmartScriptableObject.PropertyTag
    public long getcrc() {
        return this._entry.getCrc();
    }

    @SmartScriptableObject.PropertyTag
    public long getsize() {
        return this._entry.getSize();
    }

    @SmartScriptableObject.PropertyTag
    public double getmodificationTime() {
        return DateTime.fromUnixTime(this._entry.getTime());
    }

    @SmartScriptableObject.PropertyTag
    public boolean getisDirectory() {
        return this._entry.isDirectory();
    }

    public ZipEntry getEntry() {
        return this._entry;
    }
}

