/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.Core;
import inform.agent.db.BlobDataReader;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.TableDescriptor;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.net.Security;
import inform.agent.web.AsmoServlet;
import inform.agent.web.Session;
import inform.agent.web.WebServerSideHost;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class BlobBinaryServlet
extends AsmoServlet.WithSession {
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final long DEFAULT_EXPIRE_TIME = 300L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";

    public BlobBinaryServlet() {
        super(AsmoServlet.Type.RAW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response, Session session) throws Throwable {
        ServletOutputStream output;
        RandomAccessFile input;
        block33: {
            String requestedFile = null;
            try {
                requestedFile = URLDecoder.decode(request.getPathInfo(), StandardCharsets.UTF_8);
            }
            catch (NullPointerException e) {
                response.sendError(404);
                return;
            }
            String[] path = requestedFile.split("/");
            String tableIDStr = null;
            String fieldIDStr = null;
            String recordIDStr = null;
            double tableID = -1.0;
            int fieldID = -1;
            double recordID = -1.0;
            try {
                tableIDStr = path[1];
                fieldIDStr = path[2];
                recordIDStr = path[3];
                tableID = Double.parseDouble(tableIDStr);
                fieldID = Integer.parseInt(fieldIDStr);
                recordID = Double.parseDouble(recordIDStr);
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                response.sendError(404);
                return;
            }
            BasicNode node = MtdEngine.getValidNode(tableID).getRealNode();
            Session.User user = session.user();
            Acl acl = Security.acl(node);
            if ((user.accessMask(acl) & 0x4000000) == 0) {
                throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
            }
            TableDescriptor table = TableDescriptor.get(tableID);
            FieldDescriptor field = table.getExistingFieldDescriptor(fieldID);
            BlobDataReader blobData = null;
            File file = null;
            WebServerSideHost host = new WebServerSideHost(tableID, user, (AbstractConnection)((Request)request).getConnection());
            try {
                blobData = new BlobDataReader(-1, host);
                file = blobData.getBlobFile(null, table.getDbId(), table, fieldID, recordID);
            }
            finally {
                if (blobData != null) {
                    blobData.release();
                }
                host.close();
            }
            if (file == null) {
                response.sendError(404);
                return;
            }
            long lastModified = file.lastModified();
            long length = file.length();
            String fileName = tableIDStr + "_" + fieldIDStr + "_" + recordIDStr;
            String eTag = fileName + "_" + length + "_" + lastModified;
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null && BlobBinaryServlet.matches(ifNoneMatch, eTag)) {
                response.setHeader("ETag", eTag);
                response.sendError(304);
                return;
            }
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
                response.setHeader("ETag", eTag);
                response.sendError(304);
                return;
            }
            String ifMatch = request.getHeader("If-Match");
            if (ifMatch != null && !BlobBinaryServlet.matches(ifMatch, eTag)) {
                response.sendError(412);
                return;
            }
            long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
            if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
                response.sendError(412);
                return;
            }
            Range full = new Range(0L, length - 1L, length);
            ArrayList<Range> ranges = new ArrayList<Range>();
            String range = request.getHeader("Range");
            if (range != null) {
                if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                    response.setHeader("Content-Range", "bytes */" + length);
                    response.sendError(416);
                    return;
                }
                String ifRange = request.getHeader("If-Range");
                if (ifRange != null && !ifRange.equals(eTag)) {
                    try {
                        long ifRangeTime = request.getDateHeader("If-Range");
                        if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                            ranges.add(full);
                        }
                    }
                    catch (IllegalArgumentException ignore) {
                        Core.logger.error(null, ignore);
                        ranges.add(full);
                    }
                }
                if (ranges.isEmpty()) {
                    for (String part : range.substring(6).split(",")) {
                        long start = BlobBinaryServlet.sublong(part, 0, part.indexOf(45));
                        long end = BlobBinaryServlet.sublong(part, part.indexOf(45) + 1, part.length());
                        if (start == -1L) {
                            start = length - end;
                            end = length - 1L;
                        } else if (end == -1L || end > length - 1L) {
                            end = length - 1L;
                        }
                        if (start > end) {
                            response.setHeader("Content-Range", "bytes */" + length);
                            response.sendError(416);
                            return;
                        }
                        ranges.add(new Range(start, end, length));
                    }
                }
            }
            String contentType = this.getServletContext().getMimeType(fileName);
            String disposition = "inline";
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            response.reset();
            response.setBufferSize(10240);
            response.setHeader("Content-Disposition", disposition + ";filename=\"" + fileName + "\"");
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("ETag", eTag);
            response.setDateHeader("Last-Modified", lastModified);
            response.setHeader("Cache-Control", "max-age=300");
            input = null;
            output = null;
            try {
                Range r;
                input = new RandomAccessFile(file, "r");
                output = response.getOutputStream();
                if (ranges.isEmpty() || ranges.get(0) == full) {
                    r = full;
                    response.setContentType(contentType);
                    response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                    response.setHeader("Content-Length", String.valueOf(r.length));
                    BlobBinaryServlet.copy(input, (OutputStream)output, r.start, r.length);
                    break block33;
                }
                if (ranges.size() == 1) {
                    r = (Range)ranges.get(0);
                    response.setContentType(contentType);
                    response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                    response.setHeader("Content-Length", String.valueOf(r.length));
                    response.setStatus(206);
                    BlobBinaryServlet.copy(input, (OutputStream)output, r.start, r.length);
                    break block33;
                }
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                ServletOutputStream sos = output;
                for (Range r2 : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r2.start + "-" + r2.end + "/" + r2.total);
                    BlobBinaryServlet.copy(input, (OutputStream)output, r2.start, r2.length);
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
            catch (Throwable throwable) {
                BlobBinaryServlet.close(output);
                BlobBinaryServlet.close(input);
                throw throwable;
            }
        }
        BlobBinaryServlet.close((Closeable)output);
        BlobBinaryServlet.close(input);
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private static void copy(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        block6: {
            byte[] buffer = new byte[10240];
            try {
                int read;
                if (input.length() == length) {
                    int read2;
                    while ((read2 = input.read(buffer)) > 0) {
                        output.write(buffer, 0, read2);
                    }
                    break block6;
                }
                input.seek(start);
                long toRead = length;
                while ((read = input.read(buffer)) > 0) {
                    if ((toRead -= (long)read) > 0L) {
                        output.write(buffer, 0, read);
                        continue;
                    }
                    output.write(buffer, 0, (int)toRead + read);
                    break;
                }
            }
            catch (IOException ignore) {
                Core.logger.error(null, ignore);
            }
        }
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException ignore) {
                Core.logger.error(null, ignore);
            }
        }
    }

    protected static class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

