/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.IO;
import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.mtd.Acl;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.mtd.nodes.ExtFilesNode;
import inform.agent.mtd.nodes.Node;
import inform.agent.net.Security;
import inform.agent.scripts.Constants;
import inform.agent.scripts.ParametersList;
import inform.agent.web.AsmoServlet;
import inform.agent.web.AsyncExecutor;
import inform.agent.web.DocumentServlet;
import inform.agent.web.Helpers;
import inform.agent.web.ParametersForm;
import inform.agent.web.RequestTask;
import inform.agent.web.Session;
import inform.agent.web.WaitForm;
import inform.agent.web.WebServerSideHost;
import inform.agent.web.forms.WebForm;
import inform.agent.web.reports.AsyncReport;
import inform.agent.web.reports.ReportTask;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.generators.DocxGenerator;
import inform.agent.web.reports.generators.HtmlGenerator;
import inform.agent.web.reports.generators.PdfGenerator;
import inform.agent.web.reports.generators.TxtGenerator;
import inform.agent.web.reports.generators.WebReportGenerator;
import inform.agent.web.reports.generators.XlsxGenerator;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Future;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.server.Request;

public class NodeServlet
extends AsmoServlet.WithSession {
    public NodeServlet() {
        super(AsmoServlet.Type.HTML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute(HttpServletRequest req, HttpServletResponse resp, Session session) throws Throwable {
        Acl acl;
        Node nod;
        String pathInfo = req.getPathInfo();
        if (null == pathInfo) {
            throw new AsmoServlet.ClientRequestErrorException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0437\u043b\u0430");
        }
        String[] path = pathInfo.split("/");
        if (path.length < 2 || path[1].isEmpty()) {
            throw new AsmoServlet.ClientRequestErrorException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0437\u043b\u0430");
        }
        String id = path[1];
        Node node = nod = Character.isDigit(id.charAt(0)) ? MtdEngine.getNode(Long.parseLong(id)) : MtdEngine.getNodeByIdent(id);
        if (nod == null) {
            throw new AsmoServlet.ClientRequestErrorException("\u0423\u0437\u0435\u043b [" + id + "] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        double nodeId = nod.getId();
        BasicNode node2 = nod.getRealNode();
        Session.User user = session.anonWebUser(req.getPathInfo());
        if (user == null) {
            user = session.user();
        }
        if ((user.accessMask(acl = Security.acl(node2)) & 0x8000000) == 0) {
            throw new AsmoServlet.WithSession.InsufficientPrivilegiesException();
        }
        switch (node2.getType()) {
            case 14: 
            case 18: {
                long mtime = node2.getModificationContentTime();
                resp.addDateHeader("Last-Modified", mtime);
                if (mtime <= req.getDateHeader("If-Modified-Since")) {
                    resp.setStatus(304);
                    break;
                }
                resp.setStatus(200);
                resp.getOutputStream().write(node2.getContent());
                break;
            }
            case 54: {
                boolean inline;
                if (!Ini.Web) {
                    this.webModeError(id);
                }
                resp.setCharacterEncoding("WINDOWS-1251");
                resp.setHeader("Cache-Control", "no-cache");
                String p2 = path.length > 2 ? path[2] : null;
                Session.Store store = session.store();
                if ("async".equals(p2)) {
                    WebReportGenerator gen;
                    String aid = path[3];
                    Future<Document> f = store.get(aid, Document.class);
                    if (f == null) {
                        resp.setStatus(404);
                        return;
                    }
                    Document doc = f.get();
                    if ("img".equals(path[4])) {
                        int imgId = Integer.parseInt(path[5]);
                        byte[] img = doc.getImageContent(imgId);
                        if (img == null) {
                            resp.setStatus(404);
                            return;
                        }
                        ServletOutputStream os = resp.getOutputStream();
                        os.write(img);
                        break;
                    }
                    doc.setImageBaseURL(String.format("%s/node/%s/async/%s/img/", this.root(), id, aid));
                    String fname = path.length > 4 ? path[4] : ".html";
                    String[] sp = fname.split("\\.");
                    String ext = sp[sp.length - 1].toLowerCase();
                    String name = fname.substring(0, fname.length() - ext.length() - 1);
                    Core.logger.info("webreport (id:{},async:{},format:{}): generating...", id, aid, ext);
                    if ("html".equals(ext)) {
                        gen = new HtmlGenerator(doc);
                    } else if ("xlsx".equals(ext)) {
                        gen = new XlsxGenerator(doc, name);
                    } else if ("docx".equals(ext)) {
                        gen = new DocxGenerator(doc, name);
                    } else if ("txt".equals(ext)) {
                        gen = new TxtGenerator(doc, name, "cp1251");
                    } else if ("pdf".equals(ext)) {
                        gen = new PdfGenerator(doc, name);
                    } else {
                        throw new InformException("unknown output document (" + ext + ")");
                    }
                    gen.generateHeaders(resp);
                    gen.generateBody((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding());
                    Core.logger.info("webreport (id:{},async:{}): generated", (Object)id, (Object)aid);
                    break;
                }
                byte[] content = node2.getContent();
                Constants constants = new Constants(user.id());
                ParametersList parameters = new ParametersList();
                int output = 0;
                int outMask = 0;
                TaggedReader reader = new TaggedReader(content);
                while (reader.next()) {
                    switch (reader.getCurrentTag()) {
                        case 152: {
                            Helpers.datamodelParameters(parameters, reader.getSubStreamData(), constants);
                            break;
                        }
                        case 15: {
                            output = reader.getInt();
                            break;
                        }
                        case 16: {
                            TaggedReader r = reader.getStreamReader();
                            while (r.next()) {
                                if (r.getCurrentTag() != 15) continue;
                                outMask |= 1 << r.getInt();
                            }
                            break;
                        }
                    }
                }
                String overrideOutput = req.getParameter("@output");
                if (overrideOutput != null) {
                    output = Integer.parseInt(overrideOutput);
                    outMask = -1;
                }
                ParametersForm.Force force = req.getParameter("@force_request_params") == null ? ParametersForm.Force.NONE : ParametersForm.Force.REQUEST;
                boolean bl = inline = req.getParameter("$as_inline") != null;
                if (inline) {
                    force = ParametersForm.Force.PROCESS;
                    output = 1;
                }
                if (!ParametersForm.processParameters(user, req, resp, parameters, node2.getName(), nodeId, constants, force, this.root())) {
                    return;
                }
                Core.logger.info("webreport (id:{}): building document...", (Object)id);
                ReportTask.Async async = new ReportTask.Async(node2, content, user, parameters, false);
                Future<Document> f = AsyncExecutor.submit(async);
                String asyncId = store.generateId();
                store.put(asyncId, f);
                Document doc = f.get();
                doc.setImageBaseURL(String.format("%s/node/%s/async/%s/img/", this.root(), id, asyncId));
                if (output == 0) {
                    Core.logger.info("webreport (id:{}): switching to async form...", (Object)id);
                    resp.setHeader("Content-Type", "text/html; charset=windows-1251");
                    resp.setCharacterEncoding("WINDOWS-1251");
                    resp.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
                    PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                    AsyncReport.response(w, node2, asyncId, outMask, parameters, this.root());
                    w.flush();
                    break;
                }
                long st = System.currentTimeMillis();
                while (!f.isDone() && (inline || System.currentTimeMillis() - st < 1000L)) {
                    Future<Document> future = f;
                    synchronized (future) {
                        f.wait(100L);
                    }
                }
                if (f.isDone()) {
                    WebReportGenerator gen;
                    Core.logger.info("webreport (id:{}): document builded, generating...", (Object)id);
                    switch (output) {
                        case 1: {
                            gen = new HtmlGenerator(doc);
                            break;
                        }
                        case 2: {
                            gen = new XlsxGenerator(doc, node2.getName());
                            break;
                        }
                        case 3: {
                            gen = new DocxGenerator(doc, node2.getName());
                            break;
                        }
                        case 5: {
                            gen = new PdfGenerator(doc, node2.getName());
                            break;
                        }
                        case 4: {
                            gen = new TxtGenerator(doc, node2.getName(), "cp1251");
                            break;
                        }
                        default: {
                            throw new InformException("Unknown generator type (" + output + ")");
                        }
                    }
                    gen.generateHeaders(resp);
                    gen.generateBody((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding());
                    Core.logger.info("webreport (id:{}): generated", (Object)id);
                    break;
                }
                Core.logger.info("webreport (id:{}): switching to async wait...", (Object)id);
                PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding()), true);
                StringBuilder redir = new StringBuilder();
                redir.append("window.location='").append(this.root()).append("/node/").append((long)node2.getId()).append("/async/").append(asyncId).append('/').append(node2.getName()).append('.');
                switch (output) {
                    case 1: {
                        redir.append("html");
                        break;
                    }
                    case 2: {
                        redir.append("xlsx");
                        break;
                    }
                    case 3: {
                        redir.append("docx");
                        break;
                    }
                    case 4: {
                        redir.append("txt");
                        break;
                    }
                    case 5: {
                        redir.append("pdf");
                    }
                }
                redir.append('\'');
                WaitForm.response(w, node2.getName(), asyncId, redir.toString(), this.root());
                w.flush();
                break;
            }
            case 56: {
                try (WebServerSideHost.WithScriptable host = new WebServerSideHost.WithScriptable(node2.getId(), user, (AbstractConnection)((Request)req).getConnection()){

                    @Override
                    public void writeLog(String msg) throws Exception {
                        Core.logger.info(msg);
                    }

                    @Override
                    public void appendToLog(String msg) throws Exception {
                        Core.logger.info(msg);
                    }

                    @Override
                    public void writeLogLine(String msg) throws Exception {
                        Core.logger.info(msg);
                    }
                };){
                    host.setConstants(task.getConstants());
                    try (RequestTask task = new RequestTask(host, node2, req, resp, user, this.root());){
                        if (ParametersForm.processParameters(user, req, resp, task.getParameters(), node2.getName(), nodeId, task.getConstants(), ParametersForm.Force.PROCESS, this.root())) {
                            task.execute();
                        }
                        break;
                    }
                }
            }
            case 45: {
                if (!Ini.Web) {
                    this.webModeError(id);
                }
                resp.setStatus(200);
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("Content-Type", "text/html");
                resp.setHeader("X-UA-Compatible", "IE=edge,chrome=1");
                resp.setCharacterEncoding("WINDOWS-1251");
                WebForm form = WebForm.load(node2);
                WebForm.Task.Arg arg = form.createTaskArg(user.id());
                boolean inline = req.getParameter("$as_inline") != null;
                if (!ParametersForm.processParameters(user, req, resp, arg.parameters, node2.getName(), nodeId, arg.constants, inline ? ParametersForm.Force.PROCESS : ParametersForm.Force.NONE, this.root())) break;
                try (WebServerSideHost.WithScriptable host = new WebServerSideHost.WithScriptable(node2.getId(), user, (AbstractConnection)((Request)req).getConnection());){
                    if (!inline) {
                        IO.transfer(WebForm.class.getResourceAsStream("form.html"), (OutputStream)resp.getOutputStream());
                    }
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding());
                    if (!inline) {
                        ((Writer)writer).append("<title>").append(node2.getName()).append("</title>\n");
                    }
                    try (WebForm.Task task = form.createTask(arg, host, user, inline, this.root());){
                        form.generate(writer, "", task);
                    }
                    if (!inline) {
                        ((Writer)writer).append("</html>");
                    }
                    ((Writer)writer).flush();
                    break;
                }
            }
            case 42: {
                DocumentServlet.exec((AbstractConnection)((Request)req).getConnection(), req.getRequestURI(), path, node2, resp, user, this.root());
                break;
            }
            case 25: {
                StringBuilder filePath = new StringBuilder();
                for (int j = 2; j < path.length; ++j) {
                    if (j != 2) {
                        filePath.append('/');
                    }
                    filePath.append(path[j]);
                }
                if (filePath.length() == 0) {
                    return;
                }
                assert (node2 instanceof ExtFilesNode);
                byte[] content = ExtFilesNode.getFileContent((ExtFilesNode)node2, filePath.toString());
                resp.setStatus(200);
                resp.getOutputStream().write(content);
                break;
            }
            default: {
                throw new AsmoServlet.ClientRequestErrorException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 [" + id + "] (" + node2.getType() + ")");
            }
        }
    }

    private void webModeError(String id) throws InformException {
        throw new InformException("\u0421\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0443\u0437\u043b\u0430 [" + id + "] ");
    }
}

