/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.net.MultiProtocolServerHandler;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class PortUnificationSslSelectChannelConnector
extends SslSelectChannelConnector {
    public PortUnificationSslSelectChannelConnector(SslContextFactory sslContextFactory) {
        super(sslContextFactory);
    }

    protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        return super.newEndPoint((SocketChannel)new ReadAheadSocketChannelWrapper(channel, 5), selectSet, key);
    }

    protected AsyncConnection newConnection(SocketChannel channel, AsyncEndPoint endPoint) {
        return new LazyConnection((ReadAheadSocketChannelWrapper)channel, endPoint);
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        String scheme = request.getScheme();
        try {
            super.customize(endpoint, request);
        }
        catch (ClassCastException e) {
            request.setScheme(scheme);
        }
    }

    public boolean isConfidential(Request request) {
        if (request.getAttribute("javax.servlet.request.cipher_suite") != null) {
            return true;
        }
        return this.isForwarded() && request.getScheme().equalsIgnoreCase("https");
    }

    public boolean isIntegral(Request request) {
        return this.isConfidential(request);
    }

    static class ReadAheadSocketChannelWrapper
    extends SocketChannel {
        private final SocketChannel channel;
        private final ByteBuffer start;
        private byte[] bytes;
        private IOException pendingException;
        private int leftToRead;

        public ReadAheadSocketChannelWrapper(SocketChannel channel, int readAheadLength) throws IOException {
            super(channel.provider());
            this.channel = channel;
            this.start = ByteBuffer.allocate(readAheadLength);
            this.leftToRead = readAheadLength;
            this.readAhead();
        }

        public synchronized void readAhead() throws IOException {
            if (this.leftToRead > 0) {
                int n = this.channel.read(this.start);
                this.leftToRead = n == -1 ? -1 : (this.leftToRead -= n);
                if (this.leftToRead <= 0) {
                    this.start.flip();
                    this.bytes = new byte[this.start.remaining()];
                    this.start.get(this.bytes);
                    this.start.rewind();
                }
            }
        }

        public synchronized void skipRest() throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(128);
            int n = this.channel.read(buffer);
            if (n < 0) {
                this.close();
            }
        }

        public byte[] getBytes() {
            if (this.pendingException == null) {
                try {
                    this.readAhead();
                }
                catch (IOException e) {
                    this.pendingException = e;
                }
            }
            return this.bytes;
        }

        public void pendingException(IOException e) {
            if (this.pendingException == null) {
                this.pendingException = e;
            }
        }

        public void throwPendingException() throws IOException {
            if (this.pendingException != null) {
                IOException e = this.pendingException;
                this.pendingException = null;
                throw e;
            }
        }

        private int readFromStart(ByteBuffer dst) {
            int sr = this.start.remaining();
            int dr = dst.remaining();
            if (dr == 0) {
                return 0;
            }
            int n = Math.min(dr, sr);
            dst.put(this.bytes, this.start.position(), n);
            this.start.position(this.start.position() + n);
            return n;
        }

        @Override
        public synchronized int read(ByteBuffer dst) throws IOException {
            int n;
            this.throwPendingException();
            this.readAhead();
            if (this.leftToRead > 0) {
                return 0;
            }
            int sr = this.start.remaining();
            if (sr > 0 && (n = this.readFromStart(dst)) < sr) {
                return n;
            }
            return sr + this.channel.read(dst);
        }

        @Override
        public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            int newOffset;
            this.throwPendingException();
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.readAhead();
            if (this.leftToRead > 0) {
                return 0L;
            }
            int sr = this.start.remaining();
            if (sr > 0) {
                int accum = 0;
                for (newOffset = offset; newOffset < offset + length && (accum += this.readFromStart(dsts[newOffset])) != sr; ++newOffset) {
                }
                if (accum < sr) {
                    return accum;
                }
            }
            return (long)sr + this.channel.read(dsts, newOffset, length - newOffset + offset);
        }

        public int hashCode() {
            return this.channel.hashCode();
        }

        public boolean equals(Object obj) {
            return this.channel.equals(obj);
        }

        public String toString() {
            return this.channel.toString();
        }

        @Override
        public Socket socket() {
            return this.channel.socket();
        }

        @Override
        public boolean isConnected() {
            return this.channel.isConnected();
        }

        @Override
        public boolean isConnectionPending() {
            return this.channel.isConnectionPending();
        }

        @Override
        public boolean connect(SocketAddress remote) throws IOException {
            return this.channel.connect(remote);
        }

        @Override
        public boolean finishConnect() throws IOException {
            return this.channel.finishConnect();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.channel.write(src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.channel.write(srcs, offset, length);
        }

        @Override
        protected void implCloseSelectableChannel() throws IOException {
            this.channel.close();
        }

        @Override
        protected void implConfigureBlocking(boolean block) throws IOException {
            this.channel.configureBlocking(block);
        }

        @Override
        public SocketAddress getLocalAddress() throws IOException {
            return this.channel.getLocalAddress();
        }

        @Override
        public <T> T getOption(SocketOption<T> name) throws IOException {
            return this.channel.getOption(name);
        }

        @Override
        public Set<SocketOption<?>> supportedOptions() {
            return this.channel.supportedOptions();
        }

        @Override
        public SocketChannel bind(SocketAddress local) throws IOException {
            return this.channel.bind(local);
        }

        @Override
        public SocketAddress getRemoteAddress() throws IOException {
            return this.channel.getRemoteAddress();
        }

        @Override
        public <T> SocketChannel setOption(SocketOption<T> name, T value) throws IOException {
            return this.channel.setOption((SocketOption)name, (Object)value);
        }

        @Override
        public SocketChannel shutdownInput() throws IOException {
            return this.channel.shutdownInput();
        }

        @Override
        public SocketChannel shutdownOutput() throws IOException {
            return this.channel.shutdownOutput();
        }
    }

    class LazyConnection
    implements AsyncConnection {
        private final ReadAheadSocketChannelWrapper channel;
        private final AsyncEndPoint endPoint;
        private final long timestamp;
        private AsyncConnection connection;

        public LazyConnection(ReadAheadSocketChannelWrapper channel, AsyncEndPoint endPoint) {
            this.channel = channel;
            this.endPoint = endPoint;
            this.timestamp = System.currentTimeMillis();
            this.connection = this.determineNewConnection(channel, endPoint, false);
        }

        public Connection handle() throws IOException {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, false);
                this.channel.throwPendingException();
            }
            if (this.connection != null && this.connection != this) {
                return this.connection.handle();
            }
            this.channel.skipRest();
            return this;
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public void onInputShutdown() throws IOException {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, true);
            }
            this.connection.onInputShutdown();
        }

        public boolean isIdle() {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, false);
            }
            if (this.connection != null && this.connection != this) {
                return this.connection.isIdle();
            }
            return false;
        }

        public boolean isSuspended() {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, false);
            }
            if (this.connection != null && this.connection != this) {
                return this.connection.isSuspended();
            }
            return false;
        }

        public void onClose() {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, true);
            }
            this.connection.onClose();
        }

        public void onIdleExpired(long l) {
            if (this.connection == null) {
                this.connection = this.determineNewConnection(this.channel, this.endPoint, true);
            }
            if (this.connection != null && this.connection != this) {
                this.connection.onIdleExpired(l);
            }
        }

        AsyncConnection determineNewConnection(ReadAheadSocketChannelWrapper channel, AsyncEndPoint endPoint, boolean force) {
            byte[] bytes = channel.getBytes();
            if (!(bytes != null && bytes.length != 0 || force)) {
                return null;
            }
            if (bytes != null && MultiProtocolServerHandler.isAsmo(bytes)) {
                ByteArrayOutputStream response = new ByteArrayOutputStream();
                MultiProtocolServerHandler.getRedirectClientToTCPResponse(response);
                ByteBuffer data = ByteBuffer.wrap(response.internalBuffer(), 0, response.size());
                try {
                    channel.write(data);
                }
                catch (IOException e) {
                    Core.logger.error(null, e);
                    channel.pendingException(e);
                    return this;
                }
                return this;
            }
            return PortUnificationSslSelectChannelConnector.super.newConnection(channel, endPoint);
        }
    }
}

