/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web;

import inform.agent.ActiveDirectory;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.ServerNode;
import inform.agent.web.AsmoServlet;
import inform.agent.web.Session;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WasmLoginServlet
extends AsmoServlet {
    @Override
    protected void execute(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Map parameters;
        String sessionId = "";
        String sessionUserName = null;
        if (!Ini.WasmNoAD && !(parameters = request.getParameterMap()).containsKey("no_ad")) {
            ServerNode.Descriptor sd = MtdEngine.serverNode().descriptor();
            if (sd.ntlm) {
                Session session = (Session)request.getSession(true);
                String hha = request.getHeader("Authorization");
                if (hha == null || !hha.startsWith(Ini.WWW_AUTHORIZATION_TYPE)) {
                    session.removeAttribute("__asmo_active_directory");
                }
                try {
                    Session.User user = null;
                    try {
                        user = session.processAuthentification(request, response);
                    }
                    catch (AsmoServlet.WithSession.InsufficientPrivilegiesException insufficientPrivilegiesException) {
                        // empty catch block
                    }
                    if (user == null) {
                        session.requestAuthentification(request, response, false, this.root());
                        return;
                    }
                    user.revalidateNode();
                    sessionUserName = user.name();
                    sessionId = session.getId();
                    session.setAttribute("__asmo_wasm", sessionId);
                }
                catch (ActiveDirectory.Error e) {
                    Core.logger.error(null, e);
                    response.setStatus(500);
                    response.setHeader("Content-disposition", "");
                    response.setContentType("text/html");
                    response.setCharacterEncoding("UTF-8");
                    PrintWriter w = response.getWriter();
                    w.append("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                    session.removeAttribute("__asmo_active_directory");
                    return;
                }
                catch (Session.UserNotFoundException e) {
                    Core.logger.error(null, e);
                    response.setStatus(500);
                    response.setHeader("Cache-Control", "no-store");
                    response.setContentType("text/html");
                    response.setCharacterEncoding("UTF-8");
                    PrintWriter w = response.getWriter();
                    w.append("<!doctype html><html lang=\"ru\"><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"><title>\u0410\u0421\u041c\u041e</title></head><body><div><h1>\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.<br>\u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443.</h1></div></body></html>");
                    session.removeAttribute("__asmo_active_directory");
                    return;
                }
                catch (Throwable e) {
                    Core.logger.error(null, e);
                    this.type.sendServerError(response, e);
                    return;
                }
            }
        }
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Content-Type", "text");
        response.setCharacterEncoding("ISO-8859-1");
        PrintWriter w = response.getWriter();
        w.append("#" + sessionId);
    }
}

