/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebPanel;
import inform.agent.web.forms.WebToolbar;
import java.io.IOException;

public class WebBand
extends WebPanel {
    private static final int TAG_WEB_FORM_TOOLBAR = 71;
    Toolbar toolbar;
    protected double formMinWidth;
    protected double formMinHeight;
    protected double formMaxWidth;
    protected double formMaxHeight;
    protected WebControl.HorzAlign formHorzAlign;
    protected WebControl.VertAlign formVertAlign;

    public WebBand() {
        super(0, 0, null);
        this.arrangeDirection = 1;
        this.formHorzAlign = WebControl.HorzAlign.JUSTIFY;
        this.formVertAlign = WebControl.VertAlign.JUSTIFY;
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 71: {
                this.toolbar = new Toolbar(0, 0, this);
                this.toolbar.load(reader.getSubStreamReader());
                break;
            }
            case 2: {
                this.formMinWidth = reader.getDouble();
                break;
            }
            case 3: {
                this.formMinHeight = reader.getDouble();
                break;
            }
            case 24: {
                this.formMaxWidth = reader.getDouble();
                break;
            }
            case 25: {
                this.formMaxHeight = reader.getDouble();
                break;
            }
            case 4: {
                this.formHorzAlign = WebControl.HorzAlign.values()[reader.getInt()];
                break;
            }
            case 5: {
                this.formVertAlign = WebControl.VertAlign.values()[reader.getInt()];
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    protected HtmlWriter appendStyles(HtmlWriter writer, Resolver resolver) throws IOException {
        if (resolver.arg.inline) {
            writer.style("padding", "1mm");
        }
        return super.appendStyles(writer, resolver);
    }

    public static class Toolbar
    extends WebToolbar {
        private static final int TAG_WEB_FORM_TOOLBAR_VISIBLE = 40;
        private static final int TAG_WEB_FORM_TOOLBAR_BUTTON = 41;

        private Toolbar(int id, int options, WebControlContainer parent) {
            super(id, options, parent);
            this.visible = false;
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 40: {
                    this.visible = true;
                    break;
                }
                case 41: {
                    WebToolbar.Button b = new WebToolbar.Button(0, this);
                    b.load(reader.getSubStreamReader());
                    this.controls.add(b);
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }
    }
}

