/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.JSON;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebForm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@JSRequire(value={"WebDiagram"})
public class WebDiagram
extends WebControl
implements DatasourceUsage,
WebControl.JSGenerator {
    static final int TAG_WF_DIAGRAM_SERIES = 40;
    Collection<Series> seriesList = new ArrayList<Series>();

    public WebDiagram(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 40: {
                this.seriesList.add(new Series(reader.getSubStreamReader()));
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
        for (Series p : this.seriesList) {
            out.append((Object)this, p.DatasorceID, p.xField);
            out.append((Object)this, p.DatasorceID, p.yField);
            out.append((Object)this, p.DatasorceID, p.lField);
        }
    }

    @Override
    public void generate(Appendable out, String pad, WebForm.Task task) throws IOException {
        StringBuilder pseries = new StringBuilder();
        boolean nc = false;
        for (Series p : this.seriesList) {
            boolean isl;
            boolean isx = p.xField != null && p.xField.length > 0;
            boolean isy = p.yField != null && p.yField.length > 0;
            boolean bl = isl = p.lField != null && p.lField.length > 0;
            if (p.DatasorceID == 0 || !isx && !isy) continue;
            if (nc) {
                pseries.append(',');
            }
            pseries.append("\n\t\t\t{");
            if (isx) {
                pseries.append("x:datamodel._datasources[").append(p.DatasorceID).append("]._fbyid[").append(p.xField[0]).append(']');
            }
            if (isy) {
                if (isx) {
                    pseries.append(",");
                }
                pseries.append("y:datamodel._datasources[").append(p.DatasorceID).append("]._fbyid[").append(p.yField[0]).append(']');
            }
            if (isl) {
                pseries.append(",l:datamodel._datasources[").append(p.DatasorceID).append("]._fbyid[").append(p.lField[0]).append(']');
            }
            pseries.append(",type:").append(p.type);
            pseries.append(",ID:").append(p.ID);
            pseries.append(",name:").append(JSON.toString(p.name));
            pseries.append(",title:").append(JSON.toString(p.title));
            if (p.invisible) {
                pseries.append(",invisible:true");
            }
            pseries.append("}");
            nc = true;
        }
        out.append(pad).append("components[").append(Integer.toString(this.id)).append("] = new WebDiagram({dmodel:datamodel,element:args.root.find('#").append(Integer.toString(this.id)).append("')");
        if (pseries.length() > 0) {
            out.append(",seriesList:[").append(pseries).append("]");
        }
        out.append('\n').append(pad).append("});\n");
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        writer.tag("canvas").attr("class", "diagram").attr("id", this.id);
        if (this.width != 0.0) {
            writer.style("width", this.width, "mm");
        }
        if (this.height != 0.0) {
            writer.style("height", this.height, "mm");
        }
        writer.style("background-color", "white");
        writer.attr("id", this.id);
        writer.text("This browser does not seem to support HTML5 Canvas.");
        writer.end();
    }

    private static class Series {
        static final int TAG_WF_DIAGRAM_SERIES_DATASOURCEID = 1;
        static final int TAG_WF_DIAGRAM_SERIES_XFIELD = 2;
        static final int TAG_WF_DIAGRAM_SERIES_YFIELD = 3;
        static final int TAG_WF_DIAGRAM_SERIES_LFIELD = 4;
        static final int TAG_WF_DIAGRAM_SERIES_TYPE = 5;
        static final int TAG_WF_DIAGRAM_SERIES_ID = 6;
        static final int TAG_WF_DIAGRAM_SERIES_NAME = 7;
        static final int TAG_WF_DIAGRAM_SERIES_TITLE = 8;
        static final int TAG_WF_DIAGRAM_SERIES_INVISBLE = 9;
        int type;
        int ID;
        String name;
        int DatasorceID;
        int[] xField;
        int[] yField;
        int[] lField;
        String title;
        boolean invisible;

        public Series(TaggedReader reader) throws IOException {
            while (reader.next()) {
                switch (reader.getCurrentTag()) {
                    case 1: {
                        this.DatasorceID = reader.getInt();
                        break;
                    }
                    case 2: {
                        this.xField = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 3: {
                        this.yField = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 4: {
                        this.lField = LittleEndian.toIntArray(reader.getRaw());
                        break;
                    }
                    case 5: {
                        this.type = reader.getInt();
                        break;
                    }
                    case 6: {
                        this.ID = reader.getInt();
                        break;
                    }
                    case 7: {
                        this.name = reader.getString();
                        break;
                    }
                    case 8: {
                        this.title = reader.getString();
                        break;
                    }
                    case 9: {
                        this.invisible = true;
                    }
                }
            }
        }
    }
}

