/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.Strings;
import inform.adt.taggedio.TaggedReader;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.expr.JsEvaluator;
import inform.agent.web.forms.expr.JsExpression;
import inform.common.Base64BinString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WebGridCommon {
    public static final String REQUIRE = "WebGridCommon";

    public static void generateHeader(HtmlWriter writer, Resolver resolver, Iterator<? extends ColumnCaption> columns, boolean genci) throws IOException {
        writer.tag("thead");
        ArrayList<Collection<ColumnCaptionInfo>> levels = new ArrayList<Collection<ColumnCaptionInfo>>();
        WebGridCommon.walk(columns, 0, levels);
        int maxdepth = levels.size();
        int lidx = 0;
        StringBuilder cls = new StringBuilder();
        for (Collection collection : levels) {
            writer.tag("tr");
            if (genci && lidx == 0) {
                writer.tag("th").attr("class", "ci").attr("rowspan", maxdepth).tag("span").end().end();
            }
            for (ColumnCaptionInfo c : collection) {
                writer.tag("th");
                cls.setLength(0);
                if (c.leaf) {
                    int cid = c.c.id();
                    writer.attr("data-colid", cid);
                    cls.append("c").append(cid);
                    int rs = maxdepth - lidx;
                    if (rs != 1) {
                        writer.attr("rowspan", rs);
                    }
                } else if (c.colspan != 1) {
                    writer.attr("colspan", c.colspan);
                }
                if (cls.length() != 0) {
                    writer.attr("class", cls);
                }
                c.c.appendCaptionStyles(writer, resolver);
                String text = c.c.captionText();
                (Strings.isVoid(text) ? writer.html("&nbsp;") : writer.text(text)).end();
            }
            writer.end();
            ++lidx;
        }
        writer.end();
    }

    public static void generateFooter(HtmlWriter writer, Resolver resolver, Footer footer, boolean genci, boolean genskel) throws IOException {
        if (footer.controls.isEmpty()) {
            return;
        }
        writer.tag("tfoot");
        StringBuilder cls = new StringBuilder();
        boolean firstrow = true;
        for (WebControl i : footer.controls) {
            if (!i.getVisible()) continue;
            Footer.Row r = (Footer.Row)i;
            if (genskel && firstrow) {
                firstrow = false;
                writer.tag("tr").attr("class", "skel");
                if (genci) {
                    writer.tag("td").attr("class", "ci").html("&nbsp;").end();
                }
                for (WebControl j : r.controls) {
                    if (!j.getVisible()) continue;
                    Footer.Row.Cell c = (Footer.Row.Cell)j;
                    writer.tag("td").attr("class", "c" + c.columnId);
                    writer.html("&nbsp;");
                    writer.end();
                }
                writer.end();
            }
            writer.tag("tr");
            int captcols = genci ? 1 : 0;
            boolean empty = true;
            for (WebControl j : r.controls) {
                boolean hasbind;
                if (!j.getVisible()) continue;
                Footer.Row.Cell c = (Footer.Row.Cell)j;
                boolean hasdb = c.hasdb(c.dsid, c.fpath);
                boolean bl = hasbind = hasdb || c.expression != null;
                if (!hasbind && empty) {
                    ++captcols;
                    continue;
                }
                if (captcols != 0) {
                    WebGridCommon.genThCaption(writer, captcols, r);
                    captcols = 0;
                }
                cls.setLength(0);
                cls.append("c").append(c.columnId);
                writer.tag("td").attr("class", cls);
                DataType dataType = DataType.getDataTypeById(c.dataType);
                int formatId = c.formatId;
                if (hasbind) {
                    if (c.expression != null) {
                        writer.attr("data-expression", c.expr2str(c.expression, resolver));
                    } else {
                        c.appendDataBindingsAsExpressionTo(writer, c.dsid, c.fpath);
                    }
                    if (hasdb) {
                        if (dataType == DataType.NONE) {
                            dataType = resolver.resolveDataType(c.dsid, c.fpath);
                        }
                        if (formatId == 0) {
                            formatId = resolver.resolveFormatId(c.dsid, c.fpath);
                        }
                    }
                    if (dataType != null && dataType != DataType.NONE) {
                        Format fmt = FormatManager.createFormat(formatId, dataType, c.formatOption);
                        writer.style("text-align", fmt.getAlignment().name().toLowerCase());
                        writer.attr("data-datatype", dataType.toInt());
                    }
                    if (formatId != 0) {
                        writer.attr("data-format", formatId);
                        if (c.formatOption != null) {
                            writer.attr("data-format-option", Base64BinString.Encode(c.formatOption));
                        }
                    }
                } else {
                    writer.html("&nbsp;");
                }
                writer.end();
                empty = false;
            }
            if (captcols != 0) {
                WebGridCommon.genThCaption(writer, captcols, r);
            }
            writer.end();
        }
        writer.end();
    }

    private static void genThCaption(HtmlWriter writer, int captcols, Footer.Row row) throws IOException {
        writer.tag("td").attr("class", "capt").attr("colspan", captcols);
        String text = row.description;
        if (Strings.isVoid(text)) {
            writer.html("&nbsp;");
        } else {
            writer.text(text);
        }
        writer.end();
    }

    private static int walk(Iterator<? extends ColumnCaption> columns, int level, List<Collection<ColumnCaptionInfo>> levels) {
        int result = 0;
        ColumnCaption cc = WebGridCommon.poolNextVisible(columns);
        if (cc != null) {
            while (levels.size() <= level) {
                levels.add(new ArrayList());
            }
            do {
                int cs;
                result += (cs = WebGridCommon.walk(cc.childrenIterator(), level + 1, levels)) == 0 ? 1 : cs;
                ColumnCaptionInfo i = new ColumnCaptionInfo(cc, cs, cs == 0);
                levels.get(level).add(i);
            } while ((cc = WebGridCommon.poolNextVisible(columns)) != null);
        }
        return result;
    }

    private static ColumnCaption poolNextVisible(Iterator<? extends ColumnCaption> columns) {
        while (columns.hasNext()) {
            ColumnCaption cc = columns.next();
            if (!cc.getVisible()) continue;
            return cc;
        }
        return null;
    }

    private static class ColumnCaptionInfo {
        final ColumnCaption c;
        final int colspan;
        final boolean leaf;

        ColumnCaptionInfo(ColumnCaption c, int colspan, boolean leaf) {
            this.c = c;
            this.colspan = colspan;
            this.leaf = leaf;
        }
    }

    @WebControlContainer.ContainsChildren(type=509, cls=Row.class)
    public static class Footer
    extends WebControlContainer {
        public Footer(int id, WebControlContainer parent) {
            super(id, parent, true);
        }

        @WebControlContainer.ContainsChildren(type=510, cls=Cell.class)
        public static class Row
        extends WebControlContainer {
            public Row(int id, WebControlContainer parent) {
                super(id, parent, true);
            }

            public static class Cell
            extends WebControl
            implements DatasourceUsage {
                static final int TAG_WF_GRID_FOOTER_CELL_COLUMN_ID = 40;
                static final int TAG_WF_GRID_FOOTER_CELL_DATASOURCE = 41;
                static final int TAG_WF_GRID_FOOTER_CELL_FIELD = 42;
                static final int TAG_WF_GRID_FOOTER_CELL_DATA_TYPE = 43;
                static final int TAG_WF_GRID_FOOTER_CELL_EXPRESSION = 44;
                static final int TAG_WF_GRID_FOOTER_CELL_FORMAT = 48;
                static final int TAG_WF_GRID_FOOTER_CELL_FORMAT_OPTION = 49;
                int columnId;
                int dsid;
                int[] fpath;
                int formatId;
                byte[] formatOption;
                int dataType;
                JsEvaluator expression;

                public Cell(int id, WebControlContainer parent) {
                    super(id, parent, true);
                }

                @Override
                public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
                    out.append((Object)this, this.dsid, this.fpath);
                    if (this.expression != null) {
                        this.expression.appendUsedDirectoriesTo(this, out);
                    }
                }

                @Override
                protected void loadTag(TaggedReader reader) throws IOException {
                    switch (reader.getCurrentTag()) {
                        case 40: {
                            this.columnId = reader.getInt();
                            break;
                        }
                        case 41: {
                            this.dsid = reader.getInt();
                            break;
                        }
                        case 42: {
                            this.fpath = LittleEndian.toIntArray(reader.getRaw());
                            break;
                        }
                        case 43: {
                            this.dataType = reader.getInt();
                            break;
                        }
                        case 44: {
                            this.expression = JsExpression.loadAndCompile(reader.getStreamReader());
                            break;
                        }
                        case 48: {
                            this.formatId = reader.getInt();
                            break;
                        }
                        case 49: {
                            this.formatOption = reader.getRaw();
                            break;
                        }
                        default: {
                            super.loadTag(reader);
                        }
                    }
                }
            }
        }
    }

    public static interface ColumnCaption {
        public int id();

        public boolean getVisible();

        public String captionText();

        public void appendCaptionStyles(HtmlWriter var1, Resolver var2) throws IOException;

        public Iterator<ColumnCaption> childrenIterator();
    }
}

