/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import java.io.IOException;
import java.util.Arrays;

public class WebGridVeer {
    private int veerId = 0;
    private int[] veerFieldPath = null;
    private int dataId = 0;
    private int[] dataFieldPath = null;
    private int captionFormatId = 0;
    private byte[] captionFormatOptions = null;
    private int[] captionDataFieldPath = null;
    private static final int TAG_WEB_VEER_VEER_ID = 1;
    private static final int TAG_WEB_VEER_VEER_FIELD = 2;
    private static final int TAG_WEB_VEER_DATA_ID = 3;
    private static final int TAG_WEB_VEER_DATA_FIELD = 4;
    private static final int TAG_WEB_VEER_CAPTION_FORMAT = 5;
    private static final int TAG_WEB_VEER_CAPTION_FORMAT_OPTIONS = 6;
    private static final int TAG_WEB_VEER_CAPTION_DATA_FIELD = 7;

    public WebGridVeer() {
    }

    public WebGridVeer(TaggedReader reader) throws IOException {
        while (reader.next()) {
            this.loadTag(reader);
        }
    }

    public WebGridVeer(WebGridVeer key) {
        this.veerId = key.veerId;
        this.veerFieldPath = key.veerFieldPath;
        this.dataId = key.dataId;
        this.dataFieldPath = key.dataFieldPath;
        this.captionDataFieldPath = key.captionDataFieldPath;
        this.captionFormatId = key.captionFormatId;
        this.captionFormatOptions = key.captionFormatOptions;
    }

    protected void loadTag(TaggedReader reader) throws IOException, TaggedReaderException {
        switch (reader.getCurrentTag()) {
            case 5: {
                this.captionFormatId = reader.getInt();
                break;
            }
            case 6: {
                this.captionFormatOptions = reader.getRaw();
                break;
            }
            case 1: {
                this.veerId = reader.getInt();
                break;
            }
            case 2: {
                this.veerFieldPath = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 3: {
                this.dataId = reader.getInt();
                break;
            }
            case 4: {
                this.dataFieldPath = LittleEndian.toIntArray(reader.getRaw());
                break;
            }
            case 7: {
                this.captionDataFieldPath = LittleEndian.toIntArray(reader.getRaw());
            }
        }
    }

    public int getVeerId() {
        return this.veerId;
    }

    public int[] getVeerFieldPath() {
        if (this.veerFieldPath == null) {
            return null;
        }
        return Arrays.copyOf(this.veerFieldPath, this.veerFieldPath.length);
    }

    public int getDataId() {
        return this.dataId;
    }

    public int[] getDataFieldPath() {
        if (this.dataFieldPath == null) {
            return null;
        }
        return Arrays.copyOf(this.dataFieldPath, this.dataFieldPath.length);
    }

    public int[] getCaptionDataFieldPath() {
        if (this.captionDataFieldPath == null) {
            return null;
        }
        return Arrays.copyOf(this.captionDataFieldPath, this.captionDataFieldPath.length);
    }

    public int getCaptionFormatId() {
        return this.captionFormatId;
    }

    public byte[] getCaptionFormatOptions() {
        if (this.captionFormatOptions == null) {
            return null;
        }
        return Arrays.copyOf(this.captionFormatOptions, this.captionFormatOptions.length);
    }
}

