/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.forms;

import inform.adt.LittleEndian;
import inform.adt.taggedio.TaggedReader;
import inform.agent.web.forms.DatasourceUsage;
import inform.agent.web.forms.HtmlWriter;
import inform.agent.web.forms.JSRequire;
import inform.agent.web.forms.JsonWriter;
import inform.agent.web.forms.Resolver;
import inform.agent.web.forms.WebControl;
import inform.agent.web.forms.WebControlContainer;
import inform.agent.web.forms.WebPanel;
import java.io.IOException;

@JSRequire(value={"WebPages"})
public class WebPages
extends WebControlContainer {
    private static final int WF_PAGESHEET = 502;
    private static final int TAG_WF_PAGE_ACTIVE_PAGE = 43;
    private int activePageId;

    public WebPages(int id, int options, WebControlContainer parent) {
        super(id, parent, false);
    }

    @Override
    protected void loadTag(TaggedReader reader) throws IOException {
        switch (reader.getCurrentTag()) {
            case 43: {
                this.activePageId = reader.getInt();
                break;
            }
            default: {
                super.loadTag(reader);
            }
        }
    }

    @Override
    public void generate(HtmlWriter writer, Resolver resolver) throws IOException {
        Sheet s;
        writer.tag("div").attr("class", "tabs").attr("data-id", this.id).attr("id", this.id);
        for (WebControl c : this.controls) {
            s = (Sheet)c;
            if (this.activePageId == 0) {
                this.activePageId = s.id;
            }
            writer.tag("button").attr("data-id", s.id);
            if (s.id == this.activePageId) {
                writer.attr("class", "active");
            }
            if (s.dsid != 0) {
                writer.attr("data-datasource", s.dsid);
                if (s.fpath != null) {
                    writer.attr("data-capfield", this.iarr2str(s.fpath));
                }
            }
            s.appendStyles(writer, resolver);
            if (s.event != null) {
                writer.attr("data-postaction", s.event.toValue());
            }
            writer.text(s.captionText).end();
        }
        for (WebControl c : this.controls) {
            boolean empty;
            s = (Sheet)c;
            writer.tag("div");
            if (s.id == this.activePageId) {
                writer.attr("class", "active");
            }
            if (empty = ((WebControlContainer)c).controls.isEmpty()) {
                writer.style("display", "none");
            }
            if (!empty) {
                c.generate(writer, resolver);
            }
            writer.end();
        }
        writer.end();
    }

    @Override
    protected void generate_(HtmlWriter html, JsonWriter json, Resolver resolver) throws IOException {
        json.object().underscore("WebPages.WclControl", this).prop("cmps").js("components");
        json.prop("pages").array();
        for (WebControl c : this.controls) {
            Sheet s = (Sheet)c;
            json.prop().object().prop("id").val(s.id).prop("text").val(s.captionText);
            if (s.id == this.activePageId) {
                json.prop("active").val(true);
            }
            if (this.hasdb(s.dsid, s.fpath)) {
                json.prop("ds").js("components[").val(s.dsid).js("]");
                if (s.fpath != null) {
                    json.prop("fcap").js("DM.mkFieldPath(").val(s.fpath).js(",").val(s.dsid).js(",components)");
                }
            }
            if (s.event != null) {
                json.prop("postaction").val(s.event.toValue());
            }
            c.generate(html, json.prop("item"), resolver);
            json.end();
        }
        json.end();
        json.end();
    }

    @Override
    protected WebControl createTypedControl(int type, int id, int options) {
        if (type == 502) {
            return new Sheet(id, options, this);
        }
        return super.createTypedControl(type, id, options);
    }

    private static class Sheet
    extends WebPanel
    implements DatasourceUsage {
        private static final int TAG_WF_PAGESHEET_CAPTION = 70;
        private static final int TAG_WF_PAGESHEET_CAPTION_TEXT = 1;
        private static final int TAG_WF_PAGESHEET_CAPTION_FONT = 2;
        private static final int TAG_WF_PAGESHEET_DATASOURCE = 3;
        private static final int TAG_WF_PAGESHEET_FIELD = 4;
        private static final int TAG_WF_PAGESHEET_EVENT = 7;
        String captionText;
        WebControl.WebFont captionFont;
        int dsid;
        int[] fpath;
        WebControl.WebEvent event;

        Sheet(int id, int options, WebControlContainer parent) {
            super(id, options, parent);
        }

        @Override
        protected void loadTag(TaggedReader reader) throws IOException {
            switch (reader.getCurrentTag()) {
                case 70: {
                    TaggedReader r = reader.getSubStreamReader();
                    while (r.next()) {
                        switch (r.getCurrentTag()) {
                            case 1: {
                                this.captionText = r.getString();
                                break;
                            }
                            case 2: {
                                this.captionFont = new WebControl.WebFont(r.getStreamReader(), this);
                                break;
                            }
                            case 3: {
                                this.dsid = r.getInt();
                                break;
                            }
                            case 4: {
                                this.fpath = LittleEndian.toIntArray(r.getRaw());
                                break;
                            }
                            case 7: {
                                this.event = new WebControl.WebEvent(r.getRaw());
                            }
                        }
                    }
                    break;
                }
                default: {
                    super.loadTag(reader);
                }
            }
        }

        @Override
        public void appendUsedDirectoriesTo(DatasourceUsage.Scanner out) throws IOException {
            out.append((Object)this, this.dsid, this.fpath);
        }
    }
}

