/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.web.reports;

import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Request;
import inform.agent.RequestDuration;
import inform.agent.RequestHeader;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.BasicNode;
import inform.agent.web.reports.ReportTask;
import inform.agent.web.reports.document.Document;
import inform.agent.web.reports.generators.HtmlGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ClientReportRequest
extends Request {
    private static final int TAG_MODIFIED_CONSTANTS = 1;
    private static final int TAG_NODE_CONTENT = 2;
    private static final int TAG_RESULT = 1;

    public ClientReportRequest(RequestHeader rq) {
        super(rq, RequestDuration.MIDDLE);
    }

    @Override
    public void execute() throws Throwable {
        byte[] modifiedConstantsContent = null;
        byte[] inputParametersContent = null;
        byte[] webReportContent = null;
        TaggedReader reader = this.createRequestContentReader();
        while (reader.next()) {
            switch (reader.getCurrentTag()) {
                case 1: {
                    modifiedConstantsContent = reader.getRaw();
                    break;
                }
                case 2: {
                    webReportContent = reader.getRaw();
                    break;
                }
                case 153: {
                    inputParametersContent = reader.getSubStreamData();
                }
            }
        }
        double nodeId = this.getNodeID();
        BasicNode node = (BasicNode)MtdEngine.getValidNode(nodeId);
        if (webReportContent == null) {
            webReportContent = node.getContent();
        }
        StringWriter writer = new StringWriter();
        ReportTask task = new ReportTask(this, node, webReportContent, modifiedConstantsContent, null, false);
        if (inputParametersContent != null) {
            task.getParameters().loadParametersValues(task.getConstants(), new TaggedReader(inputParametersContent), task.getHost());
        }
        Document document = task.generate();
        HtmlGenerator gen = new HtmlGenerator(document);
        gen.generateBody(new PrintWriter(writer));
        String result = writer.toString();
        if (!result.isEmpty()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TaggedWriter w = new TaggedWriter(out);
            w.putAnsi(1, result);
            for (int i = 0; i <= document.getLastImageId(); ++i) {
                w.putRaw(141, document.getImageContent(i));
            }
            w.flush();
            this.sendResult(out.internalBuffer(), out.size());
        } else {
            this.sendResult();
        }
    }
}

